/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openscience.cdk.group.Permutation;

public class Partition {
    private List<SortedSet<Integer>> cells = new ArrayList<SortedSet<Integer>>();

    public Partition() {
    }

    public Partition(Partition other) {
        this();
        for (SortedSet<Integer> block : other.cells) {
            this.cells.add(new TreeSet<Integer>(block));
        }
    }

    public Partition(int[][] cellData) {
        this();
        for (int[] aCellData : cellData) {
            this.addCell(aCellData);
        }
    }

    public static Partition unit(int size) {
        Partition unit = new Partition();
        unit.cells.add(new TreeSet());
        for (int i = 0; i < size; ++i) {
            unit.cells.get(0).add(i);
        }
        return unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        return this.cells != null ? this.cells.equals(partition.cells) : partition.cells == null;
    }

    public int hashCode() {
        return this.cells != null ? this.cells.hashCode() : 0;
    }

    public int size() {
        return this.cells.size();
    }

    public int numberOfElements() {
        int n = 0;
        for (SortedSet<Integer> cell : this.cells) {
            n += cell.size();
        }
        return n;
    }

    public boolean isDiscrete() {
        for (SortedSet<Integer> cell : this.cells) {
            if (cell.size() == 1) continue;
            return false;
        }
        return true;
    }

    public Permutation toPermutation() {
        Permutation p = new Permutation(this.size());
        for (int i = 0; i < this.size(); ++i) {
            p.set(i, this.cells.get(i).first());
        }
        return p;
    }

    public boolean inOrder() {
        SortedSet<Integer> prev = null;
        for (SortedSet<Integer> cell : this.cells) {
            if (prev == null) {
                prev = cell;
                continue;
            }
            int first = cell.first();
            int last = cell.last();
            if (first > prev.first() && last > prev.last()) {
                prev = cell;
                continue;
            }
            return false;
        }
        return true;
    }

    public int getFirstInCell(int cellIndex) {
        return this.cells.get(cellIndex).first();
    }

    public SortedSet<Integer> getCell(int cellIndex) {
        return this.cells.get(cellIndex);
    }

    public Partition splitBefore(int cellIndex, int splitElement) {
        Partition r = new Partition();
        for (int j = 0; j < cellIndex; ++j) {
            r.addCell(this.copyBlock(j));
        }
        r.addSingletonCell(splitElement);
        SortedSet<Integer> splitBlock = this.copyBlock(cellIndex);
        splitBlock.remove(splitElement);
        r.addCell(splitBlock);
        for (int j = cellIndex + 1; j < this.size(); ++j) {
            r.addCell(this.copyBlock(j));
        }
        return r;
    }

    public Partition splitAfter(int cellIndex, int splitElement) {
        Partition r = new Partition();
        for (int j = 0; j < cellIndex; ++j) {
            r.addCell(this.copyBlock(j));
        }
        SortedSet<Integer> splitBlock = this.copyBlock(cellIndex);
        splitBlock.remove(splitElement);
        r.addCell(splitBlock);
        r.addSingletonCell(splitElement);
        for (int j = cellIndex + 1; j < this.size(); ++j) {
            r.addCell(this.copyBlock(j));
        }
        return r;
    }

    public Permutation setAsPermutation(int upTo) {
        int[] p = new int[upTo];
        for (int i = 0; i < upTo; ++i) {
            p[i] = this.cells.get(i).first();
        }
        return new Permutation(p);
    }

    public boolean isDiscreteCell(int cellIndex) {
        return this.cells.get(cellIndex).size() == 1;
    }

    public int getIndexOfFirstNonDiscreteCell() {
        for (int i = 0; i < this.cells.size(); ++i) {
            if (this.isDiscreteCell(i)) continue;
            return i;
        }
        return -1;
    }

    public void addSingletonCell(int element) {
        TreeSet<Integer> cell = new TreeSet<Integer>();
        cell.add(element);
        this.cells.add(cell);
    }

    public void removeCell(int index) {
        this.cells.remove(index);
    }

    public void addCell(int ... elements) {
        TreeSet<Integer> cell = new TreeSet<Integer>();
        for (int element : elements) {
            cell.add(element);
        }
        this.cells.add(cell);
    }

    public void addCell(Collection<Integer> elements) {
        this.cells.add(new TreeSet<Integer>(elements));
    }

    public void addToCell(int index, int element) {
        if (this.cells.size() < index + 1) {
            this.addSingletonCell(element);
        } else {
            this.cells.get(index).add(element);
        }
    }

    public void insertCell(int index, SortedSet<Integer> cell) {
        this.cells.add(index, cell);
    }

    public SortedSet<Integer> copyBlock(int cellIndex) {
        return new TreeSet<Integer>(this.cells.get(cellIndex));
    }

    public void order() {
        Collections.sort(this.cells, new Comparator<SortedSet<Integer>>(){

            @Override
            public int compare(SortedSet<Integer> cellA, SortedSet<Integer> cellB) {
                return cellA.first().compareTo(cellB.first());
            }
        });
    }

    public boolean inSameCell(int elementI, int elementJ) {
        for (int cellIndex = 0; cellIndex < this.size(); ++cellIndex) {
            SortedSet<Integer> cell = this.getCell(cellIndex);
            if (!cell.contains(elementI) || !cell.contains(elementJ)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int cellIndex = 0; cellIndex < this.cells.size(); ++cellIndex) {
            SortedSet<Integer> cell = this.cells.get(cellIndex);
            int elementIndex = 0;
            Iterator iterator = cell.iterator();
            while (iterator.hasNext()) {
                int element = (Integer)iterator.next();
                sb.append(element);
                if (cell.size() > 1 && elementIndex < cell.size() - 1) {
                    sb.append(',');
                }
                ++elementIndex;
            }
            if (this.cells.size() <= 1 || cellIndex >= this.cells.size() - 1) continue;
            sb.append('|');
        }
        sb.append(']');
        return sb.toString();
    }

    public static Partition fromString(String strForm) {
        if (strForm == null || strForm.isEmpty()) {
            throw new IllegalArgumentException("null or empty string provided");
        }
        Partition p = new Partition();
        int index = 0;
        if (strForm.charAt(0) == '[') {
            ++index;
        }
        int endIndex = strForm.charAt(strForm.length() - 1) == ']' ? strForm.length() - 2 : strForm.length() - 1;
        int currentCell = -1;
        int numStart = -1;
        while (index <= endIndex) {
            int element;
            char c = strForm.charAt(index);
            if (Character.isDigit(c)) {
                if (numStart == -1) {
                    numStart = index;
                }
            } else if (c == ',') {
                element = Integer.parseInt(strForm.substring(numStart, index));
                if (currentCell == -1) {
                    p.addCell(element);
                    currentCell = 0;
                } else {
                    p.addToCell(currentCell, element);
                }
                numStart = -1;
            } else if (c == '|') {
                element = Integer.parseInt(strForm.substring(numStart, index));
                if (currentCell == -1) {
                    p.addCell(element);
                    currentCell = 0;
                } else {
                    p.addToCell(currentCell, element);
                }
                ++currentCell;
                p.addCell(new int[0]);
                numStart = -1;
            }
            ++index;
        }
        int lastElement = Integer.parseInt(strForm.substring(numStart, endIndex + 1));
        p.addToCell(currentCell, lastElement);
        return p;
    }
}

