/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.CircularFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;

public class Bayesian {
    private int classType;
    private int folding = 0;
    private int numActive = 0;
    protected Map<Integer, int[]> inHash = new HashMap<Integer, int[]>();
    protected ArrayList<int[]> training = new ArrayList();
    protected ArrayList<Boolean> activity = new ArrayList();
    protected Map<Integer, Double> contribs = new HashMap<Integer, Double>();
    protected double lowThresh = 0.0;
    protected double highThresh = 0.0;
    protected double range = 0.0;
    protected double invRange = 0.0;
    protected double[] estimates = null;
    protected float[] rocX = null;
    protected float[] rocY = null;
    protected String rocType = null;
    protected double rocAUC = Double.NaN;
    protected int trainingSize = 0;
    protected int trainingActives = 0;
    private String noteTitle = null;
    private String noteOrigin = null;
    private String[] noteComments = null;
    private static final Pattern PTN_HASHLINE = Pattern.compile("^(-?\\d+)=([\\d\\.Ee-]+)");

    public Bayesian(int classType) {
        this.classType = classType;
    }

    public Bayesian(int classType, int folding) {
        this.classType = classType;
        this.folding = folding;
        boolean bad = false;
        if (folding > 0) {
            for (int f = folding; f > 0; f >>= 1) {
                if ((f & 1) != 1 || f == 1) continue;
                bad = true;
                break;
            }
        }
        if (folding < 0 || bad) {
            throw new ArithmeticException("Fingerprint folding " + folding + " invalid: must be 0 or power of 2.");
        }
    }

    public int getClassType() {
        return this.classType;
    }

    public int getFolding() {
        return this.folding;
    }

    public void addMolecule(IAtomContainer mol, boolean active) throws CDKException {
        if (mol == null || mol.getAtomCount() == 0) {
            throw new CDKException("Molecule cannot be blank or null.");
        }
        CircularFingerprinter circ = new CircularFingerprinter(this.classType);
        circ.calculate(mol);
        int AND_BITS = this.folding - 1;
        TreeSet<Integer> hashset = new TreeSet<Integer>();
        for (int n = circ.getFPCount() - 1; n >= 0; --n) {
            int code = circ.getFP((int)n).hashCode;
            if (this.folding > 0) {
                code &= AND_BITS;
            }
            hashset.add(code);
        }
        int[] hashes = new int[hashset.size()];
        int p = 0;
        for (Integer h : hashset) {
            hashes[p++] = h;
        }
        if (active) {
            ++this.numActive;
        }
        this.training.add(hashes);
        this.activity.add(active);
        for (Object h : (Object)hashes) {
            int[] stash = this.inHash.get((int)h);
            if (stash == null) {
                stash = new int[]{0, 0};
            }
            if (active) {
                stash[0] = stash[0] + 1;
            }
            stash[1] = stash[1] + 1;
            this.inHash.put((int)h, stash);
        }
    }

    public void build() throws CDKException {
        this.trainingSize = this.training.size();
        this.trainingActives = this.numActive;
        this.contribs.clear();
        int sz = this.training.size();
        double invSz = 1.0 / (double)sz;
        double P_AT = (double)this.numActive * invSz;
        for (Integer hash : this.inHash.keySet()) {
            int[] AT = this.inHash.get(hash);
            int A = AT[0];
            int T = AT[1];
            double Pcorr = (double)(A + 1) / ((double)T * P_AT + 1.0);
            double P = Math.log(Pcorr);
            this.contribs.put(hash, P);
        }
        this.lowThresh = Double.POSITIVE_INFINITY;
        this.highThresh = Double.NEGATIVE_INFINITY;
        for (int[] fp : this.training) {
            double val = 0.0;
            for (int hash : fp) {
                val += this.contribs.get(hash).doubleValue();
            }
            this.lowThresh = Math.min(this.lowThresh, val);
            this.highThresh = Math.max(this.highThresh, val);
        }
        this.range = this.highThresh - this.lowThresh;
        this.invRange = this.range > 0.0 ? 1.0 / this.range : 0.0;
    }

    public double predict(IAtomContainer mol) throws CDKException {
        if (mol == null || mol.getAtomCount() == 0) {
            throw new CDKException("Molecule cannot be blank or null.");
        }
        CircularFingerprinter circ = new CircularFingerprinter(this.classType);
        circ.calculate(mol);
        int AND_BITS = this.folding - 1;
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (int n = circ.getFPCount() - 1; n >= 0; --n) {
            int code = circ.getFP((int)n).hashCode;
            if (this.folding > 0) {
                code &= AND_BITS;
            }
            hashset.add(code);
        }
        double val = 0.0;
        Iterator iterator = hashset.iterator();
        while (iterator.hasNext()) {
            int h = (Integer)iterator.next();
            Double c = this.contribs.get(h);
            if (c == null) continue;
            val += c.doubleValue();
        }
        return val;
    }

    public double scalePredictor(double pred) {
        if (this.range == 0.0) {
            return pred >= this.highThresh ? 1.0 : 0.0;
        }
        return (pred - this.lowThresh) * this.invRange;
    }

    public void validateLeaveOneOut() {
        int sz = this.training.size();
        this.estimates = new double[sz];
        for (int n = 0; n < sz; ++n) {
            this.estimates[n] = this.singleLeaveOneOut(n);
        }
        this.calculateROC();
        this.rocType = "leave-one-out";
    }

    public void validateFiveFold() {
        this.rocType = "five-fold";
        this.validateNfold(5);
    }

    public void validateThreeFold() {
        this.rocType = "three-fold";
        this.validateNfold(3);
    }

    public void clearTraining() {
        this.training.clear();
        this.activity.clear();
    }

    public int getTrainingSize() {
        return this.trainingSize;
    }

    public int getTrainingActives() {
        return this.trainingActives;
    }

    public double getROCAUC() {
        return this.rocAUC;
    }

    public String getROCType() {
        return this.rocType;
    }

    public float[] getRocX() {
        return this.rocX;
    }

    public float[] getRocY() {
        return this.rocY;
    }

    public String getNoteTitle() {
        return this.noteTitle;
    }

    public void setNoteTitle(String title) {
        if (title.indexOf(10) >= 0 || title.indexOf(9) >= 0) {
            throw new IllegalArgumentException("Comments cannot contain newlines or tabs.");
        }
        this.noteTitle = title;
    }

    public String getNoteOrigin() {
        return this.noteOrigin;
    }

    public void setNoteOrigin(String origin) {
        this.noteOrigin = origin;
    }

    public String[] getNoteComments() {
        return this.noteComments == null ? null : Arrays.copyOf(this.noteComments, this.noteComments.length);
    }

    public void setNoteComments(String[] comments) {
        if (comments != null) {
            for (String comment : comments) {
                if (comment.indexOf(10) < 0 && comment.indexOf(9) < 0) continue;
                throw new IllegalArgumentException("Comments cannot contain newlines or tabs.");
            }
        }
        this.noteComments = comments == null ? null : Arrays.copyOf(comments, comments.length);
    }

    public String serialise() {
        StringBuffer buff = new StringBuffer();
        String fpname = this.classType == 1 ? "ECFP0" : (this.classType == 2 ? "ECFP2" : (this.classType == 3 ? "ECFP4" : (this.classType == 4 ? "ECFP6" : (this.classType == 5 ? "FCFP0" : (this.classType == 6 ? "FCFP2" : (this.classType == 7 ? "FCFP4" : (this.classType == 8 ? "FCFP6" : "?")))))));
        buff.append("Bayesian!(" + fpname + "," + this.folding + "," + this.lowThresh + "," + this.highThresh + ")\n");
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        for (Integer hash : this.contribs.keySet()) {
            sorted.add(hash);
        }
        for (Integer hash : sorted) {
            double c = this.contribs.get(hash);
            buff.append(hash + "=" + c + "\n");
        }
        buff.append("training:size=").append(this.trainingSize).append('\n');
        buff.append("training:actives=").append(this.trainingActives).append('\n');
        if (!Double.isNaN(this.rocAUC)) {
            buff.append("roc:auc=").append(this.rocAUC).append('\n');
        }
        if (this.rocType != null) {
            buff.append("roc:type=").append(this.rocType).append('\n');
        }
        if (this.rocX != null && this.rocY != null) {
            int n;
            buff.append("roc:x=");
            for (n = 0; n < this.rocX.length; ++n) {
                buff.append((n == 0 ? "" : ",") + this.rocX[n]);
            }
            buff.append('\n');
            buff.append("roc:y=");
            for (n = 0; n < this.rocY.length; ++n) {
                buff.append((n == 0 ? "" : ",") + this.rocY[n]);
            }
            buff.append('\n');
        }
        if (this.noteTitle != null) {
            buff.append("note:title=").append(this.noteTitle).append('\n');
        }
        if (this.noteOrigin != null) {
            buff.append("note:origin=").append(this.noteOrigin).append('\n');
        }
        if (this.noteComments != null) {
            for (String comment : this.noteComments) {
                buff.append("note:comment=").append(comment).append('\n');
            }
        }
        buff.append("!End\n");
        return buff.toString();
    }

    public static Bayesian deserialise(String str) throws IOException {
        BufferedReader rdr = new BufferedReader(new StringReader(str));
        Bayesian model = Bayesian.deserialise(rdr);
        rdr.close();
        return model;
    }

    public static Bayesian deserialise(BufferedReader rdr) throws IOException {
        int classType;
        String line = rdr.readLine();
        if (line == null || !line.startsWith("Bayesian!(") || !line.endsWith(")")) {
            throw new IOException("Not a serialised Bayesian model.");
        }
        String[] bits = line.substring(10, line.length() - 1).split(",");
        if (bits.length < 4) {
            throw new IOException("Invalid header content");
        }
        int n = bits[0].equals("ECFP0") ? 1 : (bits[0].equals("ECFP2") ? 2 : (bits[0].equals("ECFP4") ? 3 : (bits[0].equals("ECFP6") ? 4 : (bits[0].equals("FCFP0") ? 5 : (bits[0].equals("FCFP2") ? 6 : (bits[0].equals("FCFP4") ? 7 : (classType = bits[0].equals("FCFP6") ? 8 : 0)))))));
        if (classType == 0) {
            throw new IOException("Unknown fingerprint type: " + bits[0]);
        }
        int folding = Integer.valueOf(bits[1]);
        if (folding > 0) {
            for (int f = folding; f > 0; f >>= 1) {
                if ((f & 1) != 1 || f == 1) continue;
                folding = -1;
                break;
            }
        }
        if (folding < 0) {
            throw new IOException("Fingerprint folding " + bits[1] + " invalid: must be 0 or power of 2.");
        }
        Bayesian model = new Bayesian(classType, folding);
        model.lowThresh = Double.valueOf(bits[2]);
        model.highThresh = Double.valueOf(bits[3]);
        model.range = model.highThresh - model.lowThresh;
        double d = model.invRange = model.range > 0.0 ? 1.0 / model.range : 0.0;
        block11: while (true) {
            if ((line = rdr.readLine()) == null) {
                throw new IOException("Missing correct terminator line.");
            }
            if (line.equals("!End")) break;
            Matcher m = PTN_HASHLINE.matcher(line);
            if (m.find()) {
                int hash = Integer.valueOf(m.group(1));
                double c = Double.valueOf(m.group(2));
                model.contribs.put(hash, c);
                continue;
            }
            if (line.startsWith("training:size=")) {
                try {
                    model.trainingSize = Integer.valueOf(line.substring(14));
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Invalid training info line: " + line);
                }
            }
            if (line.startsWith("training:actives=")) {
                try {
                    model.trainingActives = Integer.valueOf(line.substring(17));
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Invalid training info line: " + line);
                }
            }
            if (line.startsWith("roc:auc=")) {
                try {
                    model.rocAUC = Double.valueOf(line.substring(8));
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Invalid AUC line: " + line);
                }
            }
            if (line.startsWith("roc:type=")) {
                model.rocType = line.substring(9);
                continue;
            }
            if (line.startsWith("roc:x=")) {
                String[] nums = line.substring(6).split(",");
                model.rocX = new float[nums.length];
                int n2 = 0;
                while (true) {
                    if (n2 >= nums.length) continue block11;
                    try {
                        model.rocX[n2] = Float.valueOf(nums[n2]).floatValue();
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Invalid ROC X coordinates, number=" + nums[n2]);
                    }
                    ++n2;
                }
            }
            if (line.startsWith("roc:y=")) {
                String[] nums = line.substring(6).split(",");
                model.rocY = new float[nums.length];
                int n3 = 0;
                while (true) {
                    if (n3 >= nums.length) continue block11;
                    try {
                        model.rocY[n3] = Float.valueOf(nums[n3]).floatValue();
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("Invalid ROC Y coordinates, number=" + nums[n3]);
                    }
                    ++n3;
                }
            }
            if (line.startsWith("note:title=")) {
                model.noteTitle = line.substring(11);
                continue;
            }
            if (line.startsWith("note:origin=")) {
                model.noteOrigin = line.substring(12);
                continue;
            }
            if (!line.startsWith("note:comment=")) continue;
            model.noteComments = model.noteComments == null ? new String[1] : Arrays.copyOf(model.noteComments, model.noteComments.length + 1);
            model.noteComments[model.noteComments.length - 1] = line.substring(13);
        }
        return model;
    }

    private double singleLeaveOneOut(int N) {
        boolean exclActive = this.activity.get(N);
        int[] exclFP = this.training.get(N);
        int sz = this.training.size();
        int szN = sz - 1;
        double invSzN = 1.0 / (double)szN;
        int activeN = exclActive ? this.numActive - 1 : this.numActive;
        double P_AT = (double)activeN * invSzN;
        double val = 0.0;
        for (Integer hash : this.inHash.keySet()) {
            if (Arrays.binarySearch(exclFP, hash) < 0) continue;
            int[] AT = this.inHash.get(hash);
            int A = AT[0] - (exclActive ? 1 : 0);
            int T = AT[1] - 1;
            double Pcorr = (double)(A + 1) / ((double)T * P_AT + 1.0);
            double P = Math.log(Pcorr);
            val += P;
        }
        return val;
    }

    private void validateNfold(int nsegs) {
        int n;
        int n2;
        int sz = this.training.size();
        int[] order = new int[sz];
        int p = 0;
        for (n2 = 0; n2 < sz; ++n2) {
            if (!this.activity.get(n2).booleanValue()) continue;
            order[p++] = n2;
        }
        for (n2 = 0; n2 < sz; ++n2) {
            if (this.activity.get(n2).booleanValue()) continue;
            order[p++] = n2;
        }
        Map[] segContribs = new Map[nsegs];
        for (n = 0; n < nsegs; ++n) {
            segContribs[n] = this.buildPartial(order, n, nsegs);
        }
        this.estimates = new double[sz];
        for (n = 0; n < sz; ++n) {
            this.estimates[order[n]] = this.estimatePartial(order, n, segContribs[n % nsegs]);
        }
        this.calculateROC();
    }

    private Map<Integer, Double> buildPartial(int[] order, int seg, int div) {
        int sz = this.training.size();
        int na = 0;
        int nt = 0;
        HashMap<Integer, int[]> ih = new HashMap<Integer, int[]>();
        for (int n = 0; n < sz; ++n) {
            if (n % div == seg) continue;
            boolean active = this.activity.get(order[n]);
            if (active) {
                ++na;
            }
            ++nt;
            for (int h : this.training.get(order[n])) {
                int[] stash = (int[])ih.get(h);
                if (stash == null) {
                    stash = new int[]{0, 0};
                }
                if (active) {
                    stash[0] = stash[0] + 1;
                }
                stash[1] = stash[1] + 1;
                ih.put(h, stash);
            }
        }
        HashMap<Integer, Double> segContribs = new HashMap<Integer, Double>();
        double invSz = 1.0 / (double)nt;
        double P_AT = (double)na * invSz;
        for (Integer hash : ih.keySet()) {
            int[] AT = (int[])ih.get(hash);
            int A = AT[0];
            int T = AT[1];
            double Pcorr = (double)(A + 1) / ((double)T * P_AT + 1.0);
            double P = Math.log(Pcorr);
            segContribs.put(hash, P);
        }
        return segContribs;
    }

    private double estimatePartial(int[] order, int N, Map<Integer, Double> segContrib) {
        double val = 0.0;
        for (int h : this.training.get(order[N])) {
            Double c = segContrib.get(h);
            if (c == null) continue;
            val += c.doubleValue();
        }
        return val;
    }

    private void calculateROC() {
        int n;
        int sz = this.training.size();
        Integer[] idx = new Integer[sz];
        for (int n2 = 0; n2 < sz; ++n2) {
            idx[n2] = n2;
        }
        Arrays.sort(idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                double v2;
                double v1 = Bayesian.this.estimates[i1];
                return v1 < (v2 = Bayesian.this.estimates[i2]) ? -1 : (v1 > v2 ? 1 : 0);
            }
        });
        double[] thresholds = new double[sz + 1];
        int tsz = 0;
        thresholds[tsz++] = this.lowThresh - 0.01 * this.range;
        for (int n3 = 0; n3 < sz - 1; ++n3) {
            double th2;
            double th1 = this.estimates[idx[n3]];
            if (th1 == (th2 = this.estimates[idx[n3 + 1]])) continue;
            thresholds[tsz++] = 0.5 * (th1 + th2);
        }
        thresholds[tsz++] = this.highThresh + 0.01 * this.range;
        this.rocX = new float[tsz];
        this.rocY = new float[tsz];
        double[] rocT = new double[tsz];
        int posTrue = 0;
        int posFalse = 0;
        int ipos = 0;
        float invPos = 1.0f / (float)this.numActive;
        float invNeg = 1.0f / (float)(sz - this.numActive);
        int rsz = 0;
        for (n = 0; n < tsz; ++n) {
            double th = thresholds[n];
            while (ipos < sz && !(th < this.estimates[idx[ipos]])) {
                if (this.activity.get(idx[ipos]).booleanValue()) {
                    ++posTrue;
                } else {
                    ++posFalse;
                }
                ++ipos;
            }
            float x = (float)posFalse * invNeg;
            float y = (float)posTrue * invPos;
            if (rsz > 0 && x == this.rocX[rsz - 1] && y == this.rocY[rsz - 1]) continue;
            this.rocX[rsz] = 1.0f - x;
            this.rocY[rsz] = 1.0f - y;
            rocT[rsz] = th;
            ++rsz;
        }
        this.rocX = this.reverse(this.resize(this.rocX, rsz));
        this.rocY = this.reverse(this.resize(this.rocY, rsz));
        rocT = this.reverse(this.resize(rocT, rsz));
        this.calibrateThresholds(this.rocX, this.rocY, rocT);
        this.rocAUC = 0.0;
        for (n = 0; n < rsz - 1; ++n) {
            double w = this.rocX[n + 1] - this.rocX[n];
            double h = 0.5 * (double)(this.rocY[n] + this.rocY[n + 1]);
            this.rocAUC += w * h;
        }
        float DIST = 0.002f;
        float DSQ = 4.0000004E-6f;
        float[] gx = new float[rsz];
        float[] gy = new float[rsz];
        gx[0] = this.rocX[0];
        gy[0] = this.rocY[0];
        int gsz = 1;
        for (int i = 1; i < rsz - 1; ++i) {
            float dx = this.rocX[i] - gx[gsz - 1];
            float dy = this.rocY[i] - gy[gsz - 1];
            if (dx * dx + dy * dy < 4.0000004E-6f) continue;
            gx[gsz] = this.rocX[i];
            gy[gsz] = this.rocY[i];
            ++gsz;
        }
        gx[gsz] = this.rocX[rsz - 1];
        gy[gsz] = this.rocY[rsz - 1];
        this.rocX = this.resize(gx, ++gsz);
        this.rocY = this.resize(gy, gsz);
    }

    private void calibrateThresholds(float[] x, float[] y, double[] t) {
        int idxX;
        int sz = t.length;
        int idx = 0;
        for (int n = 1; n < sz; ++n) {
            if (!(y[n] - x[n] > y[idx] - x[idx])) continue;
            idx = n;
        }
        double midThresh = t[idx];
        int idxY = sz - 1;
        for (idxX = 0; idxX < idx - 1 && !(x[idxX] > 0.0f); ++idxX) {
        }
        while (idxY > idx + 1 && !(y[idxY] < 1.0f)) {
            --idxY;
        }
        double delta = Math.min(t[idxX] - midThresh, midThresh - t[idxY]);
        this.lowThresh = midThresh - delta;
        this.highThresh = midThresh + delta;
        this.range = 2.0 * delta;
        this.invRange = this.range > 0.0 ? 1.0 / this.range : 0.0;
    }

    private double[] resize(double[] arr, int sz) {
        double[] ret = new double[sz];
        for (int n = (arr == null ? 0 : Math.min(sz, arr.length)) - 1; n >= 0; --n) {
            ret[n] = arr[n];
        }
        return ret;
    }

    private float[] resize(float[] arr, int sz) {
        float[] ret = new float[sz];
        for (int n = (arr == null ? 0 : Math.min(sz, arr.length)) - 1; n >= 0; --n) {
            ret[n] = arr[n];
        }
        return ret;
    }

    private double[] reverse(double[] arr) {
        double[] ret = new double[arr.length];
        int i = 0;
        for (int j = arr.length - 1; j >= 0; --j) {
            ret[j] = arr[i];
            ++i;
        }
        return ret;
    }

    private float[] reverse(float[] arr) {
        float[] ret = new float[arr.length];
        int i = 0;
        for (int j = arr.length - 1; j >= 0; --j) {
            ret[j] = arr[i];
            ++i;
        }
        return ret;
    }
}

