/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFName;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFImageDelayQueue {
    private int currentNumber = 0;
    private Map<RenderedImage, Entry> imageMap;
    private List<Entry> imageList;
    private PDFWriter pdf;

    public PDFImageDelayQueue(PDFWriter pdf) {
        this.pdf = pdf;
        this.imageMap = new HashMap<RenderedImage, Entry>();
        this.imageList = new LinkedList<Entry>();
    }

    public PDFName delayImage(RenderedImage image, Color bkg, String writeAs) {
        Entry entry = this.imageMap.get(image);
        if (entry == null) {
            entry = new Entry(image, bkg, writeAs);
            this.imageMap.put(image, entry);
            this.imageList.add(entry);
        }
        return this.pdf.name(entry.name);
    }

    public void processAll() throws IOException {
        for (Entry entry : this.imageList) {
            if (entry.written) continue;
            entry.written = true;
            PDFStream img = this.pdf.openStream(entry.name);
            img.entry("Subtype", this.pdf.name("Image"));
            if (entry.maskName != null) {
                img.entry("SMask", this.pdf.ref(entry.maskName));
            }
            img.image(entry.image, entry.bkg, entry.writeAs);
            this.pdf.close(img);
            if (entry.maskName == null) continue;
            PDFStream mask = this.pdf.openStream(entry.maskName);
            mask.entry("Subtype", this.pdf.name("Image"));
            mask.imageMask(entry.image, entry.writeAs);
            this.pdf.close(mask);
        }
    }

    public int addXObjects() throws IOException {
        if (this.imageList.size() > 0) {
            PDFDictionary xobj = this.pdf.openDictionary("XObjects");
            for (Entry entry : this.imageList) {
                xobj.entry(entry.name, this.pdf.ref(entry.name));
                if (entry.maskName == null) continue;
                xobj.entry(entry.maskName, this.pdf.ref(entry.maskName));
            }
            this.pdf.close(xobj);
        }
        return this.imageList.size();
    }

    private class Entry {
        private RenderedImage image;
        private String name;
        private String maskName;
        private Color bkg;
        private String writeAs;
        private boolean written;

        private Entry(RenderedImage image, Color bkg, String writeAs) {
            this.image = image;
            this.bkg = bkg;
            this.writeAs = writeAs;
            this.name = "Img" + PDFImageDelayQueue.this.currentNumber++;
            this.maskName = image.getColorModel().hasAlpha() && bkg == null ? this.name + "Mask" : null;
            this.written = false;
        }
    }
}

