/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.DoubleResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.IonizationPotentialTool;
import org.openscience.cdk.tools.LonePairElectronChecker;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.IPMolecularLearningDescriptorTest")
public class IPMolecularLearningDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean addlp = true;
    private static final String[] names = new String[]{"MolIP"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ip", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("One parameter expected");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("Boolean parameter expected");
        }
        this.addlp = (Boolean)params[0];
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return new Object[]{this.addlp};
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        DoubleResult value;
        IAtomContainer local;
        if (this.addlp) {
            try {
                local = atomContainer.clone();
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(local);
            }
            catch (CloneNotSupportedException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), (Exception)e);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), (Exception)((Object)e));
            }
        } else {
            local = atomContainer;
        }
        try {
            value = new DoubleResult(((DoubleArrayResult)this.calculatePlus(local).getValue()).get(0));
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), (Exception)((Object)e));
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)value, this.getDescriptorNames());
    }

    @TestMethod(value="testIPDescriptor_2,testIPDescriptor_3")
    public DescriptorValue calculatePlus(IAtomContainer container) throws CDKException {
        double value;
        ArrayList<Double> dar = new ArrayList<Double>();
        for (IAtom atom : container.atoms()) {
            value = IonizationPotentialTool.predictIP((IAtomContainer)container, (IAtom)atom);
            if (value == 0.0) continue;
            dar.add(value);
        }
        for (IBond bond : container.bonds()) {
            if (!(bond.getOrder() == IBond.Order.DOUBLE & bond.getAtom(0).getSymbol().equals("C") & bond.getAtom(1).getSymbol().equals("C")) || (value = IonizationPotentialTool.predictIP((IAtomContainer)container, (IBond)bond)) == 0.0) continue;
            dar.add(value);
        }
        DoubleArrayResult results = this.arrangingEnergy(dar);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)results, this.getDescriptorNames(), null);
    }

    private DoubleArrayResult arrangingEnergy(ArrayList<Double> array) {
        DoubleArrayResult results = new DoubleArrayResult();
        int count = array.size();
        for (int i = 0; i < count; ++i) {
            double min = array.get(0);
            int pos = 0;
            for (int j = 0; j < array.size(); ++j) {
                double value = array.get(j);
                if (!(value < min)) continue;
                min = value;
                pos = j;
            }
            array.remove(pos);
            results.add(min);
        }
        return results;
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResultType();
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[]{"addlp"};
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return this.addlp;
    }
}

