/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class AtomTypeTools {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomTypeTools.class);
    HOSECodeGenerator hcg = new HOSECodeGenerator();
    SmilesGenerator sg = null;

    public IRingSet assignAtomTypePropertiesToAtom(IAtomContainer molecule) throws Exception {
        return this.assignAtomTypePropertiesToAtom(molecule, true);
    }

    public IRingSet assignAtomTypePropertiesToAtom(IAtomContainer molecule, boolean aromaticity) throws Exception {
        SmilesGenerator sg = new SmilesGenerator();
        logger.debug((Object)"assignAtomTypePropertiesToAtom Start ...");
        String hoseCode = "";
        IRingSet ringSetA = null;
        IRingSet ringSetMolecule = Cycles.sssr((IAtomContainer)molecule).toRingSet();
        logger.debug((Object)ringSetMolecule);
        if (aromaticity) {
            try {
                Aromaticity.cdkLegacy().apply(molecule);
            }
            catch (Exception cdk1) {
                logger.error((Object)("AROMATICITYError: Cannot determine aromaticity due to: " + cdk1.toString()));
            }
        }
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            IAtom atom2 = molecule.getAtom(i);
            if (ringSetMolecule.contains(atom2)) {
                ringSetA = ringSetMolecule.getRings(atom2);
                RingSetManipulator.sort((IRingSet)ringSetA);
                IRing sring = (IRing)ringSetA.getAtomContainer(ringSetA.getAtomContainerCount() - 1);
                atom2.setProperty((Object)"cdk:Part of ring of size", (Object)sring.getRingSize());
                atom2.setProperty((Object)"cdk:Chemical Group", (Object)this.ringSystemClassifier(sring, sg.create((IAtomContainer)atom2.getBuilder().newInstance(IAtomContainer.class, new Object[]{sring}))));
                atom2.setFlag(2, true);
                atom2.setFlag(8, false);
            } else {
                atom2.setProperty((Object)"cdk:Chemical Group", (Object)4);
                atom2.setFlag(2, false);
                atom2.setFlag(8, true);
            }
            try {
                hoseCode = this.hcg.getHOSECode(molecule, atom2, 3);
                hoseCode = this.removeAromaticityFlagsFromHoseCode(hoseCode);
                atom2.setProperty((Object)"cdk:HOSE code spherical matcher", (Object)hoseCode);
                continue;
            }
            catch (CDKException ex1) {
                throw new CDKException("Could not build HOSECode from atom " + i + " due to " + ex1.toString(), (Throwable)ex1);
            }
        }
        return ringSetMolecule;
    }

    private int ringSystemClassifier(IRing ring, String smile) {
        logger.debug((Object)"Comparing ring systems: SMILES=", new Object[]{smile});
        if (smile.equals("c1ccnc1")) {
            return 4;
        }
        if (smile.equals("c1ccoc1")) {
            return 6;
        }
        if (smile.equals("c1ccsc1")) {
            return 8;
        }
        if (smile.equals("c1ccncc1")) {
            return 10;
        }
        if (smile.equals("c1cncnc1")) {
            return 12;
        }
        if (smile.equals("c1ccccc1")) {
            return 5;
        }
        int ncount = 0;
        for (int i = 0; i < ring.getAtomCount(); ++i) {
            if (!ring.getAtom(i).getSymbol().equals("N")) continue;
            ++ncount;
        }
        if (ring.getAtomCount() == 6 & ncount == 1) {
            return 10;
        }
        if (ring.getAtomCount() == 5 & ncount == 1) {
            return 4;
        }
        if (ncount == 0) {
            return 3;
        }
        return 0;
    }

    private String removeAromaticityFlagsFromHoseCode(String hoseCode) {
        String hosecode = "";
        for (int i = 0; i < hoseCode.length(); ++i) {
            if (hoseCode.charAt(i) == '*') continue;
            hosecode = hosecode + hoseCode.charAt(i);
        }
        return hosecode;
    }
}

