/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugIsotope
extends Isotope
implements IIsotope {
    private static final long serialVersionUID = -2659188100080921299L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugIsotope.class);

    public DebugIsotope(String elementSymbol) {
        super(elementSymbol);
        this.logger.debug((Object)"Instantiated a DebugIsotope.");
    }

    public DebugIsotope(int atomicNumber, String elementSymbol, int massNumber, double exactMass, double abundance) {
        super(atomicNumber, elementSymbol, massNumber, exactMass, abundance);
        this.logger.debug((Object)"Instantiated a DebugIsotope.");
    }

    public DebugIsotope(int atomicNumber, String elementSymbol, double exactMass, double abundance) {
        super(atomicNumber, elementSymbol, exactMass, abundance);
        this.logger.debug((Object)"Instantiated a DebugIsotope.");
    }

    public DebugIsotope(String elementSymbol, int massNumber) {
        super(elementSymbol, massNumber);
        this.logger.debug((Object)"Instantiated a DebugIsotope.");
    }

    public DebugIsotope(IElement element) {
        super(element);
        this.logger.debug((Object)"Instantiated a DebugIsotope from element: ", new Object[]{element});
    }

    public Integer getAtomicNumber() {
        this.logger.debug((Object)"Getting atomic number: ", new Object[]{super.getAtomicNumber()});
        return super.getAtomicNumber();
    }

    public void setAtomicNumber(Integer atomicNumber) {
        this.logger.debug((Object)"Setting atomic number: ", new Object[]{atomicNumber});
        super.setAtomicNumber(atomicNumber);
    }

    public String getSymbol() {
        this.logger.debug((Object)"Getting symbol: ", new Object[]{super.getSymbol()});
        return super.getSymbol();
    }

    public void setSymbol(String symbol) {
        this.logger.debug((Object)"Setting symbol: ", new Object[]{symbol});
        super.setSymbol(symbol);
    }

    public void addListener(IChemObjectListener col) {
        this.logger.debug((Object)"Adding listener: ", new Object[]{col});
        super.addListener(col);
    }

    public int getListenerCount() {
        this.logger.debug((Object)"Getting listener count: ", new Object[]{super.getListenerCount()});
        return super.getListenerCount();
    }

    public void removeListener(IChemObjectListener col) {
        this.logger.debug((Object)"Removing listener: ", new Object[]{col});
        super.removeListener(col);
    }

    public void notifyChanged() {
        this.logger.debug((Object)"Notifying changed");
        super.notifyChanged();
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug((Object)"Notifying changed event: ", new Object[]{evt});
        super.notifyChanged(evt);
    }

    public void setProperty(Object description, Object property) {
        this.logger.debug((Object)"Setting property: ", new Object[]{description + "=" + property});
        super.setProperty(description, property);
    }

    public void removeProperty(Object description) {
        this.logger.debug((Object)"Removing property: ", new Object[]{description});
        super.removeProperty(description);
    }

    public <T> T getProperty(Object description) {
        this.logger.debug((Object)"Getting property: ", new Object[]{description + "=" + super.getProperty(description)});
        return (T)super.getProperty(description);
    }

    public Map<Object, Object> getProperties() {
        this.logger.debug((Object)"Getting properties");
        return super.getProperties();
    }

    public String getID() {
        this.logger.debug((Object)"Getting ID: ", new Object[]{super.getID()});
        return super.getID();
    }

    public void setID(String identifier) {
        this.logger.debug((Object)"Setting ID: ", new Object[]{identifier});
        super.setID(identifier);
    }

    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flag_type + "=" + flag_value});
        super.setFlag(flag_type, flag_value);
    }

    public boolean getFlag(int flag_type) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flag_type + "=" + super.getFlag(flag_type)});
        return super.getFlag(flag_type);
    }

    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug((Object)"Setting properties: ", new Object[]{properties});
        super.addProperties(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        this.logger.debug((Object)"Setting flags:", new Object[]{flagsNew.length});
        super.setFlags(flagsNew);
    }

    public boolean[] getFlags() {
        this.logger.debug((Object)"Getting flags:", new Object[]{super.getFlags().length});
        return super.getFlags();
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not clone DebugAtom: " + exception.getMessage()), new Object[]{exception});
            this.logger.debug((Object)exception);
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    public void setNaturalAbundance(Double naturalAbundance) {
        this.logger.debug((Object)"Setting natural abundance: ", new Object[]{naturalAbundance});
        super.setNaturalAbundance(naturalAbundance);
    }

    public void setExactMass(Double exactMass) {
        this.logger.debug((Object)"Setting exact mass: ", new Object[]{exactMass});
        super.setExactMass(exactMass);
    }

    public Double getNaturalAbundance() {
        this.logger.debug((Object)"Getting natural abundance: ", new Object[]{super.getNaturalAbundance()});
        return super.getNaturalAbundance();
    }

    public Double getExactMass() {
        this.logger.debug((Object)"Getting exact mass: ", new Object[]{super.getExactMass()});
        return super.getExactMass();
    }

    public Integer getMassNumber() {
        this.logger.debug((Object)"Getting mass number: ", new Object[]{super.getMassNumber()});
        return super.getMassNumber();
    }

    public void setMassNumber(Integer massNumber) {
        this.logger.debug((Object)"Setting mass number: ", new Object[]{massNumber});
        super.setMassNumber(massNumber);
    }
}

