/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLBuilder;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractDictionary;
import org.xmlcml.cml.element.CMLEntry;

public class CMLDictionary
extends AbstractDictionary {
    private static final Logger LOG = Logger.getLogger(CMLDictionary.class);
    public static final String NS = "cml:dictionary";
    static final Logger logger = Logger.getLogger(CMLDictionary.class);
    protected Map<String, CMLEntry> entryMap = null;

    public CMLDictionary() {
    }

    public CMLDictionary(CMLDictionary old) {
        super(old);
    }

    public Node copy() {
        return new CMLDictionary(this);
    }

    public CMLElement makeElementInContext(Element parent) {
        return new CMLDictionary();
    }

    public int indexEntries() {
        if (this.entryMap == null) {
            this.entryMap = new HashMap<String, CMLEntry>();
            CMLElements<CMLEntry> entryNodes = this.getEntryElements();
            for (CMLEntry entry : entryNodes) {
                String id = entry.getId();
                if (id == null) continue;
                this.entryMap.put(id, entry);
            }
            LOG.debug((Object)("Created dictionary with entries: " + entryNodes.size()));
        }
        return this.entryMap.size();
    }

    public CMLDictionary createDictionary(File file) throws IOException {
        return this.createDictionary(file.toURI().toURL());
    }

    public CMLDictionary createDictionary(URL url) throws IOException {
        Document dictDoc = CMLDictionary.createDictionary0(url);
        CMLDictionary dictionary1 = null;
        if (dictDoc != null) {
            Element root = dictDoc.getRootElement();
            if (root instanceof CMLDictionary) {
                dictionary1 = new CMLDictionary((CMLDictionary)root);
            } else {
                throw new RuntimeException("Expected CMLDictionary root element, found: " + root.getClass().getName() + "/" + root.getLocalName());
            }
        }
        if (dictionary1 != null) {
            dictionary1.indexEntries();
        }
        return dictionary1;
    }

    static Document createDictionary0(File file) throws IOException {
        return CMLDictionary.createDictionary0(file.toURI().toURL());
    }

    static Document createDictionary0(URL url) throws IOException {
        Document dictDoc = null;
        InputStream in = null;
        try {
            in = url.openStream();
            dictDoc = new CMLBuilder().build(in);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new RuntimeException("NULL " + e.getMessage() + "/" + e.getCause() + " in " + url);
        }
        catch (ValidityException e) {
            throw new RuntimeException("" + e.getMessage() + "/" + e.getCause() + " in " + url);
        }
        catch (ParsingException e) {
            System.err.println("ERR at line/col " + e.getLineNumber() + "/" + e.getColumnNumber());
            throw new RuntimeException(" in " + url, e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return dictDoc;
    }

    public CMLEntry getGenericEntry(String id) {
        return this.getCMLEntry(id);
    }

    public CMLEntry getCMLEntry(String id) {
        int nentries = this.indexEntries();
        return this.entryMap.get(id);
    }

    public void addEntry(CMLEntry entry) {
        String id = entry.getId();
        if (id == null) {
            throw new RuntimeException("Entry has no id");
        }
        if (this.getCMLEntry(id) != null) {
            throw new RuntimeException("Entry for " + id + " already present");
        }
        this.entryMap.put(id, entry);
        this.appendChild((Node)entry);
    }

    public void addEntryInOrder(CMLEntry entry) {
        String id = entry.getId();
        if (id == null) {
            throw new RuntimeException("Entry has no id");
        }
        if (this.getCMLEntry(id) == null) {
            this.entryMap.put(id, entry);
            CMLElements<CMLEntry> entries = this.getEntryElements();
            int idx = entries.size();
            for (CMLEntry entry0 : entries) {
                if (id.compareTo(entry0.getId()) >= 0) continue;
                idx = this.indexOf((Node)entry0);
                break;
            }
            this.insertChild((Node)entry, idx);
        }
    }

    public void removeEntry(CMLEntry entry) {
        String id = entry.getId();
        this.removeEntryById(id);
    }

    public void removeEntryById(String id) {
        CMLEntry entry1;
        if (id != null && (entry1 = this.getCMLEntry(id)) != null) {
            this.entryMap.remove(id);
            entry1.detach();
        }
    }
}

