/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.tools.diff.AtomDiff;
import org.openscience.cdk.tools.diff.ElectronContainerDiff;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;

@TestClass(value="org.openscience.cdk.tools.diff.SingleElectronDiffTest")
public class SingleElectronDiff {
    private SingleElectronDiff() {
    }

    @TestMethod(value="testMatchAgainstItself,testDiff")
    public static String diff(IChemObject first, IChemObject second) {
        IDifference diff = SingleElectronDiff.difference(first, second);
        if (diff == null) {
            return "";
        }
        return diff.toString();
    }

    @TestMethod(value="testDifference")
    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof ISingleElectron) || !(second instanceof ISingleElectron)) {
            return null;
        }
        ISingleElectron firstB = (ISingleElectron)first;
        ISingleElectron secondB = (ISingleElectron)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("SingleElectronDiff");
        totalDiff.addChild(AtomDiff.difference((IChemObject)firstB.getAtom(), (IChemObject)secondB.getAtom()));
        totalDiff.addChild(ElectronContainerDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

