/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import Jama.Matrix;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.LengthOverBreadthDescriptorTest")
public class LengthOverBreadthDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(LengthOverBreadthDescriptor.class);
    private static final String[] names = new String[]{"LOBMAX", "LOBMIN"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#lengthOverBreadth", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult result = new DoubleArrayResult(2);
        result.add(Double.NaN);
        result.add(Double.NaN);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)result, this.getDescriptorNames(), e);
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        if (!GeometryTools.has3DCoordinates((IAtomContainer)atomContainer)) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Molecule must have 3D coordinates")));
        }
        double angle = 10.0;
        double maxLOB = 0.0;
        double minArea = 1000000.0;
        double mmLOB = 0.0;
        double[][] coords = new double[atomContainer.getAtomCount()][3];
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            coords[i][0] = atomContainer.getAtom((int)i).getPoint3d().x;
            coords[i][1] = atomContainer.getAtom((int)i).getPoint3d().y;
            coords[i][2] = atomContainer.getAtom((int)i).getPoint3d().z;
        }
        Point3d com = GeometryTools.get3DCentreOfMass((IAtomContainer)atomContainer);
        if (com == null) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Error in center of mass calculation")));
        }
        for (int i = 0; i < coords.length; ++i) {
            double[] dArray = coords[i];
            dArray[0] = dArray[0] - com.x;
            double[] dArray2 = coords[i];
            dArray2[1] = dArray2[1] - com.y;
            double[] dArray3 = coords[i];
            dArray3[2] = dArray3[2] - com.z;
        }
        int nangle = (int)(90.0 / angle);
        for (int i = 0; i < nangle; ++i) {
            double[] xyzRanges;
            this.rotateZ(coords, Math.PI / 180 * angle);
            try {
                xyzRanges = this.extents(atomContainer, coords, true);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue((Exception)((Object)e));
            }
            double lob = xyzRanges[0] / xyzRanges[1];
            double bol = 1.0 / lob;
            if (lob < bol) {
                double tmp = lob;
                lob = bol;
                bol = tmp;
            }
            double area = xyzRanges[0] * xyzRanges[1];
            if (lob > maxLOB) {
                maxLOB = lob;
            }
            if (!(area < minArea)) continue;
            minArea = area;
            mmLOB = lob;
        }
        DoubleArrayResult result = new DoubleArrayResult(2);
        result.add(maxLOB);
        result.add(mmLOB);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)result, this.getDescriptorNames());
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(2);
    }

    private void rotateZ(double[][] coords, double theta) {
        int j;
        int i;
        int natom = coords.length;
        Matrix rZ = new Matrix(4, 4);
        rZ.set(0, 0, Math.cos(theta));
        rZ.set(0, 1, Math.sin(theta));
        rZ.set(1, 0, -1.0 * Math.sin(theta));
        rZ.set(1, 1, Math.cos(theta));
        rZ.set(2, 2, 1.0);
        rZ.set(3, 3, 1.0);
        Matrix newCoord = new Matrix(4, natom);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < natom; ++j) {
                newCoord.set(i, j, coords[j][i]);
                newCoord.set(3, j, 1.0);
            }
        }
        newCoord = rZ.times(newCoord);
        newCoord = newCoord.transpose();
        for (i = 0; i < natom; ++i) {
            for (j = 0; j < 3; ++j) {
                coords[i][j] = newCoord.get(i, j);
            }
        }
    }

    private double[] extents(IAtomContainer atomContainer, double[][] coords, boolean withRadii) throws CDKException {
        double xmax = -1.0E30;
        double ymax = -1.0E30;
        double zmax = -1.0E30;
        double xmin = 1.0E30;
        double ymin = 1.0E30;
        double zmin = 1.0E30;
        int natom = atomContainer.getAtomCount();
        for (int i = 0; i < natom; ++i) {
            double[] coord = new double[coords[0].length];
            System.arraycopy(coords[i], 0, coord, 0, coords[0].length);
            if (withRadii) {
                IAtom atom = atomContainer.getAtom(i);
                double radius = PeriodicTable.getCovalentRadius((String)atom.getSymbol());
                xmax = Math.max(xmax, coord[0] + radius);
                ymax = Math.max(ymax, coord[1] + radius);
                zmax = Math.max(zmax, coord[2] + radius);
                xmin = Math.min(xmin, coord[0] - radius);
                ymin = Math.min(ymin, coord[1] - radius);
                zmin = Math.min(zmin, coord[2] - radius);
                continue;
            }
            xmax = Math.max(xmax, coord[0]);
            ymax = Math.max(ymax, coord[1]);
            zmax = Math.max(zmax, coord[2]);
            xmin = Math.min(xmin, coord[0]);
            ymin = Math.min(ymin, coord[1]);
            zmin = Math.min(zmin, coord[2]);
        }
        double[] ranges = new double[]{xmax - xmin, ymax - ymin, zmax - zmin};
        return ranges;
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

