/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.dict;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.dict.DictionaryHandler;
import org.openscience.cdk.dict.Entry;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@TestClass(value="org.openscience.cdk.dict.DictionaryTest")
public class Dictionary {
    private Map<String, Entry> entries = new Hashtable<String, Entry>();
    private String ownNS = null;

    public static Dictionary unmarshal(Reader reader) {
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(Dictionary.class);
        DictionaryHandler handler = new DictionaryHandler();
        XMLReader parser = null;
        try {
            parser = XMLReaderFactory.createXMLReader();
            logger.debug((Object)("Using " + parser));
        }
        catch (Exception e) {
            logger.error((Object)"Could not instantiate any JAXP parser!");
            logger.debug((Object)e);
        }
        try {
            if (parser == null) {
                logger.debug((Object)"parser object was null!");
                return null;
            }
            parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.debug((Object)"Deactivated validation");
        }
        catch (SAXException e) {
            logger.warn((Object)"Cannot deactivate validation.");
            logger.debug((Object)e);
        }
        parser.setContentHandler(handler);
        Dictionary dict = null;
        try {
            parser.parse(new InputSource(reader));
            dict = handler.getDictionary();
        }
        catch (IOException e) {
            logger.error((Object)("IOException: " + e.toString()));
            logger.debug((Object)e);
        }
        catch (SAXException saxe) {
            logger.error((Object)("SAXException: " + saxe.getClass().getName()));
            logger.debug((Object)saxe);
        }
        return dict;
    }

    @TestMethod(value="testAddEntry")
    public void addEntry(Entry entry) {
        this.entries.put(entry.getID().toLowerCase(), entry);
    }

    public Entry[] getEntries() {
        int size = this.entries.size();
        Entry[] entryArray = new Entry[size];
        Iterator<Entry> elements = this.entries.values().iterator();
        for (int counter = 0; elements.hasNext() && counter < size; ++counter) {
            entryArray[counter] = elements.next();
        }
        return entryArray;
    }

    @TestMethod(value="testAddEntry")
    public boolean hasEntry(String identifier) {
        return this.entries.containsKey(identifier);
    }

    @TestMethod(value="testAddEntry")
    public Entry getEntry(String identifier) {
        return this.entries.get(identifier);
    }

    @TestMethod(value="testAddEntry")
    public int size() {
        return this.entries.size();
    }

    @TestMethod(value="testNS")
    public void setNS(String nameSpace) {
        this.ownNS = nameSpace;
    }

    @TestMethod(value="testNS")
    public String getNS() {
        return this.ownNS;
    }
}

