/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.io.IOException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.CovalentRadiusDescriptorTest")
public class CovalentRadiusDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private AtomTypeFactory factory = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CovalentRadiusDescriptor.class);

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#covalentradius", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return new String[]{"covalentRadius"};
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        if (this.factory == null) {
            try {
                this.factory = AtomTypeFactory.getInstance((String)"org/openscience/cdk/config/data/jmol_atomtypes.txt", (IChemObjectBuilder)container.getBuilder());
            }
            catch (Exception exception) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), exception);
            }
        }
        try {
            String symbol = atom.getSymbol();
            IAtomType type = this.factory.getAtomType(symbol);
            double covalentradius = type.getCovalentRadius();
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(covalentradius), this.getDescriptorNames());
        }
        catch (Exception exception) {
            logger.debug((Object)exception);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), exception);
        }
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

