/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.formula.MolecularFormulaRange;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;

@TestClass(value="org.openscience.cdk.formula.MolecularFormulaRangeManipulatorTest")
public class MolecularFormulaRangeManipulator {
    @TestMethod(value="testGetRange_IMolecularFormulaSet")
    public static MolecularFormulaRange getRange(IMolecularFormulaSet mfSet) {
        MolecularFormulaRange mfRange = new MolecularFormulaRange();
        for (IMolecularFormula mf : mfSet.molecularFormulas()) {
            for (IIsotope isotope : mf.isotopes()) {
                int occur_new = mf.getIsotopeCount(isotope);
                if (!mfRange.contains(isotope)) {
                    mfRange.addIsotope(isotope, occur_new, occur_new);
                    continue;
                }
                int occur_old_Max = mfRange.getIsotopeCountMax(isotope);
                int occur_old_Min = mfRange.getIsotopeCountMin(isotope);
                if (occur_new > occur_old_Max) {
                    mfRange.removeIsotope(isotope);
                    mfRange.addIsotope(isotope, occur_old_Min, occur_new);
                    continue;
                }
                if (occur_new >= occur_old_Min) continue;
                mfRange.removeIsotope(isotope);
                mfRange.addIsotope(isotope, occur_new, occur_old_Max);
            }
        }
        for (IMolecularFormula mf : mfSet.molecularFormulas()) {
            if (mf.getIsotopeCount() == mfRange.getIsotopeCount()) continue;
            for (IIsotope isotope : mfRange.isotopes()) {
                if (mf.contains(isotope)) continue;
                int occurMax = mfRange.getIsotopeCountMax(isotope);
                mfRange.addIsotope(isotope, 0, occurMax);
            }
        }
        return mfRange;
    }

    @TestMethod(value="testGetMaximalFormula_MolecularFormulaRange_IChemObjectBuilder")
    public static IMolecularFormula getMaximalFormula(MolecularFormulaRange mfRange, IChemObjectBuilder builder) {
        IMolecularFormula formula = (IMolecularFormula)builder.newInstance(IMolecularFormula.class, new Object[0]);
        for (IIsotope isotope : mfRange.isotopes()) {
            formula.addIsotope(isotope, mfRange.getIsotopeCountMax(isotope));
        }
        return formula;
    }

    @TestMethod(value="testGetMinimalFormula_MolecularFormulaRange_IChemObjectBuilder")
    public static IMolecularFormula getMinimalFormula(MolecularFormulaRange mfRange, IChemObjectBuilder builder) {
        IMolecularFormula formula = (IMolecularFormula)builder.newInstance(IMolecularFormula.class, new Object[0]);
        for (IIsotope isotope : mfRange.isotopes()) {
            formula.addIsotope(isotope, mfRange.getIsotopeCountMin(isotope));
        }
        return formula;
    }
}

