/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MoSSOutputFormat;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.io.MoSSOutputReaderTest")
public class MoSSOutputReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MoSSOutputReader.class);

    public MoSSOutputReader(Reader input) {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public MoSSOutputReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public MoSSOutputReader() {
        this(new StringReader(""));
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MoSSOutputFormat.getInstance();
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(this.input);
    }

    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class<? extends IChemObject> testClass) {
        if (IAtomContainerSet.class.equals(testClass)) {
            return true;
        }
        if (IChemFile.class.equals(testClass)) {
            return true;
        }
        Class<?>[] interfaces = testClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IAtomContainerSet.class.equals(interfaces[i])) {
                return true;
            }
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = testClass.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainerSet) {
            IAtomContainerSet cf = (IAtomContainerSet)object;
            try {
                cf = this.readAtomContainerSet(cf);
            }
            catch (IOException e) {
                logger.error((Object)"Input/Output error while reading from input.");
            }
            return (T)cf;
        }
        if (object instanceof IChemFile) {
            IChemFile chemFile = (IChemFile)object;
            IChemSequence chemSeq = (IChemSequence)object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            IChemModel chemModel = (IChemModel)object.getBuilder().newInstance(IChemModel.class, new Object[0]);
            IAtomContainerSet molSet = (IAtomContainerSet)object.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            try {
                molSet = this.readAtomContainerSet(molSet);
            }
            catch (IOException e) {
                logger.error((Object)"Input/Output error while reading from input.");
            }
            chemModel.setMoleculeSet(molSet);
            chemSeq.addChemModel(chemModel);
            chemFile.addChemSequence(chemSeq);
            return (T)chemFile;
        }
        throw new CDKException("Only supported is reading of IMoleculeSet.");
    }

    private IAtomContainerSet readAtomContainerSet(IAtomContainerSet molSet) throws IOException {
        SmilesParser parser = new SmilesParser(molSet.getBuilder());
        parser.kekulise(false);
        String line = this.input.readLine();
        line = this.input.readLine();
        while (line != null) {
            String[] cols = line.split(",");
            try {
                IAtomContainer mol = parser.parseSmiles(cols[1]);
                mol.setProperty((Object)"focusSupport", (Object)cols[5]);
                mol.setProperty((Object)"complementSupport", (Object)cols[7]);
                mol.setProperty((Object)"atomCount", (Object)cols[2]);
                mol.setProperty((Object)"bondCount", (Object)cols[3]);
                molSet.addAtomContainer(mol);
            }
            catch (InvalidSmilesException exception) {
                logger.error((Object)("Skipping invalid SMILES: " + cols[1]));
                logger.debug((Object)exception);
            }
            line = this.input.readLine();
        }
        return molSet;
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

