/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;

@TestClass(value="org.openscience.cdk.fingerprint.LingoFingerprinterTest")
public class LingoFingerprinter
implements IFingerprinter {
    int q = 4;
    SmilesGenerator gen = new SmilesGenerator();
    Pattern ringClosurePattern = Pattern.compile("[0-9]+");

    @TestMethod(value="testFingerprint")
    public LingoFingerprinter() {
    }

    @TestMethod(value="testFingerprint")
    public LingoFingerprinter(int q) {
        this.q = q;
    }

    public IBitFingerprint getBitFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @TestMethod(value="testFingerprint")
    public Map<String, Integer> getRawFingerprint(IAtomContainer atomContainer) throws CDKException {
        Aromaticity.cdkLegacy().apply(atomContainer);
        String smiles = this.refactorSmiles(this.gen.create(atomContainer));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < smiles.length() - this.q + 1; ++i) {
            String subsmi = smiles.substring(i, i + this.q);
            if (map.containsKey(subsmi)) {
                map.put(subsmi, (Integer)map.get(subsmi) + 1);
                continue;
            }
            map.put(subsmi, 1);
        }
        return map;
    }

    @TestMethod(value="testGetSize")
    public int getSize() {
        return -1;
    }

    private String refactorSmiles(String smiles) {
        Matcher matcher = this.ringClosurePattern.matcher(smiles);
        return matcher.replaceAll("0");
    }

    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }
}

