/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles.smarts;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.ComponentGrouping;
import org.openscience.cdk.isomorphism.SmartsStereoMatch;
import org.openscience.cdk.isomorphism.Ullmann;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.SmartsMatchers;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.smiles.smarts.parser.SMARTSParser;
import org.openscience.cdk.smiles.smarts.parser.TokenMgrError;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.smiles.smarts.SMARTSQueryToolTest")
public class SMARTSQueryTool {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(SMARTSQueryTool.class);
    private String smarts;
    private IAtomContainer atomContainer = null;
    private QueryAtomContainer query = null;
    private List<int[]> mappings;
    private RingSet ringSet = RingSet.EssentialRings;
    private final IChemObjectBuilder builder;
    private Aromaticity aromaticity = new Aromaticity(ElectronDonation.daylight(), Cycles.allOrVertexShort());
    private boolean skipAromaticity = false;
    private int MAX_ENTRIES = 20;
    Map<String, QueryAtomContainer> cache = new LinkedHashMap<String, QueryAtomContainer>(this.MAX_ENTRIES + 1, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > SMARTSQueryTool.this.MAX_ENTRIES;
        }
    };

    public SMARTSQueryTool(String smarts, IChemObjectBuilder builder) {
        this.builder = builder;
        this.smarts = smarts;
        try {
            this.initializeQuery();
        }
        catch (TokenMgrError error) {
            throw new IllegalArgumentException("Error parsing SMARTS", error);
        }
        catch (CDKException error) {
            throw new IllegalArgumentException("Error parsing SMARTS", error);
        }
    }

    public void setQueryCacheSize(int maxEntries) {
        this.MAX_ENTRIES = maxEntries;
    }

    public void useSmallestSetOfSmallestRings() {
        this.ringSet = RingSet.SmallestSetOfSmallestRings;
    }

    public void useRelevantRings() {
        this.ringSet = RingSet.RelevantRings;
    }

    public void useEssentialRings() {
        this.ringSet = RingSet.EssentialRings;
    }

    @TestMethod(value="setAromaticity,nullAromaticity")
    public void setAromaticity(Aromaticity aromaticity) {
        this.aromaticity = (Aromaticity)Preconditions.checkNotNull((Object)aromaticity, (Object)"aromaticity was not provided");
    }

    @TestMethod(value="testQueryTool")
    public String getSmarts() {
        return this.smarts;
    }

    @TestMethod(value="testQueryTool, testQueryToolResetSmart")
    public void setSmarts(String smarts) throws CDKException {
        this.smarts = smarts;
        this.initializeQuery();
    }

    public boolean matches(IAtomContainer atomContainer) throws CDKException {
        return this.matches(atomContainer, false);
    }

    @TestMethod(value="testQueryTool, testQueryToolSingleAtomCase, testQuery")
    public boolean matches(IAtomContainer atomContainer, boolean forceInitialization) throws CDKException {
        if (this.atomContainer == atomContainer) {
            if (forceInitialization) {
                this.initializeMolecule();
            }
        } else {
            this.atomContainer = atomContainer;
            this.initializeMolecule();
        }
        if (this.query.getAtomCount() == 1) {
            IQueryAtom queryAtom = (IQueryAtom)this.query.getAtom(0);
            this.mappings = new ArrayList<int[]>();
            for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
                if (!queryAtom.matches(atomContainer.getAtom(i))) continue;
                this.mappings.add(new int[]{i});
            }
        } else {
            this.mappings = FluentIterable.from((Iterable)Ullmann.findSubstructure((IAtomContainer)this.query).matchAll(atomContainer)).filter((Predicate)new SmartsStereoMatch((IAtomContainer)this.query, atomContainer)).filter((Predicate)new ComponentGrouping((IAtomContainer)this.query, atomContainer)).toList();
        }
        return !this.mappings.isEmpty();
    }

    @TestMethod(value="testQueryTool")
    public int countMatches() {
        return this.mappings.size();
    }

    @TestMethod(value="testQueryTool")
    public List<List<Integer>> getMatchingAtoms() {
        ArrayList<List<Integer>> matched = new ArrayList<List<Integer>>(this.mappings.size());
        for (int[] mapping : this.mappings) {
            matched.add(Ints.asList((int[])mapping));
        }
        return matched;
    }

    @TestMethod(value="testUniqueQueries")
    public List<List<Integer>> getUniqueMatchingAtoms() {
        ArrayList<List<Integer>> matched = new ArrayList<List<Integer>>(this.mappings.size());
        HashSet atomSets = Sets.newHashSetWithExpectedSize((int)this.mappings.size());
        for (int[] mapping : this.mappings) {
            BitSet atomSet = new BitSet();
            for (int x : mapping) {
                atomSet.set(x);
            }
            if (!atomSets.add(atomSet)) continue;
            matched.add(Ints.asList((int[])mapping));
        }
        return matched;
    }

    private void initializeMolecule() throws CDKException {
        SmartsMatchers.prepare(this.atomContainer, true);
        try {
            if (!this.skipAromaticity) {
                this.aromaticity.apply(this.atomContainer);
            }
        }
        catch (CDKException e) {
            logger.debug((Object)e.toString());
            throw new CDKException(e.toString(), (Throwable)e);
        }
    }

    private void initializeQuery() throws CDKException {
        this.mappings = null;
        this.query = this.cache.get(this.smarts);
        if (this.query == null) {
            this.query = SMARTSParser.parse(this.smarts, this.builder);
            this.cache.put(this.smarts, this.query);
        }
    }

    private List<Set<Integer>> matchedAtoms(List<List<RMap>> bondMapping, IAtomContainer atomContainer) {
        ArrayList<Set<Integer>> atomMapping = new ArrayList<Set<Integer>>();
        for (List<RMap> mapping : bondMapping) {
            TreeSet<Integer> tmp = new TreeSet<Integer>();
            IAtom atom1 = null;
            IAtom atom2 = null;
            for (RMap map : mapping) {
                int bondID = map.getId1();
                IBond bond = atomContainer.getBond(bondID);
                atom1 = bond.getAtom(0);
                atom2 = bond.getAtom(1);
                Integer idx1 = atomContainer.getAtomNumber(atom1);
                Integer idx2 = atomContainer.getAtomNumber(atom2);
                if (!tmp.contains(idx1)) {
                    tmp.add(idx1);
                }
                if (tmp.contains(idx2)) continue;
                tmp.add(idx2);
            }
            if (tmp.size() == this.query.getAtomCount()) {
                atomMapping.add(tmp);
            }
            if (mapping.size() != 1 || !atom1.getAtomicNumber().equals(atom2.getAtomicNumber())) continue;
            atomMapping.add(new TreeSet(tmp));
        }
        return atomMapping;
    }

    private static enum RingSet {
        SmallestSetOfSmallestRings{

            @Override
            IRingSet ringSet(IAtomContainer m) {
                return Cycles.sssr((IAtomContainer)m).toRingSet();
            }
        }
        ,
        EssentialRings{

            @Override
            IRingSet ringSet(IAtomContainer m) {
                return Cycles.essential((IAtomContainer)m).toRingSet();
            }
        }
        ,
        RelevantRings{

            @Override
            IRingSet ringSet(IAtomContainer m) {
                return Cycles.relevant((IAtomContainer)m).toRingSet();
            }
        };


        abstract IRingSet ringSet(IAtomContainer var1);
    }
}

