/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAdductFormula;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

@TestClass(value="org.openscience.cdk.silent.AdductFormulaTest")
public class AdductFormula
implements Iterable<IMolecularFormula>,
IAdductFormula,
Cloneable {
    private static final long serialVersionUID = -811384981700039389L;
    private List<IMolecularFormula> components = new ArrayList<IMolecularFormula>();

    public AdductFormula() {
    }

    public AdductFormula(IMolecularFormula formula) {
        this.components.add(0, formula);
    }

    @Override
    @TestMethod(value="testAddMolecularFormula_IMolecularFormula")
    public void addMolecularFormula(IMolecularFormula formula) {
        this.components.add(formula);
    }

    @Override
    @TestMethod(value="testAdd_IMolecularFormulaSet")
    public void add(IMolecularFormulaSet formulaSet) {
        for (IMolecularFormula mf : formulaSet.molecularFormulas()) {
            this.addMolecularFormula(mf);
        }
    }

    @Override
    @TestMethod(value="testContains_IIsotope")
    public boolean contains(IIsotope isotope) {
        for (IIsotope thisIsotope : this.isotopes()) {
            if (!this.isTheSame(thisIsotope, isotope)) continue;
            return true;
        }
        return false;
    }

    @Override
    @TestMethod(value="testGetCharge")
    public Integer getCharge() {
        Integer charge = 0;
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            charge = charge + componentIterator.next().getCharge();
        }
        return charge;
    }

    @Override
    @TestMethod(value="testGetIsotopeCount_IIsotope")
    public int getIsotopeCount(IIsotope isotope) {
        int count = 0;
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            count += componentIterator.next().getIsotopeCount(isotope);
        }
        return count;
    }

    @Override
    @TestMethod(value="testGetIsotopeCount")
    public int getIsotopeCount() {
        return this.isotopesList().size();
    }

    @Override
    @TestMethod(value="testIsotopes")
    public Iterable<IIsotope> isotopes() {
        return new Iterable<IIsotope>(){

            @Override
            public Iterator<IIsotope> iterator() {
                return AdductFormula.this.isotopesList().iterator();
            }
        };
    }

    private List<IIsotope> isotopesList() {
        ArrayList<IIsotope> isotopes = new ArrayList<IIsotope>();
        Iterator<IMolecularFormula> componentIterator = this.components.iterator();
        while (componentIterator.hasNext()) {
            for (IIsotope isotope : componentIterator.next().isotopes()) {
                if (isotopes.contains(isotope)) continue;
                isotopes.add(isotope);
            }
        }
        return isotopes;
    }

    @Override
    @TestMethod(value="testSetCharge")
    public void setCharge(Integer charge) {
        throw new IllegalAccessError();
    }

    @Override
    @TestMethod(value="testMolecularFormulas")
    public Iterable<IMolecularFormula> molecularFormulas() {
        return this.components;
    }

    @Override
    @TestMethod(value="testIterator")
    public Iterator<IMolecularFormula> iterator() {
        return this.components.iterator();
    }

    @Override
    @TestMethod(value="testSize")
    public int size() {
        return this.components.size();
    }

    @Override
    @TestMethod(value="testContains_IMolecularFormula")
    public boolean contains(IMolecularFormula formula) {
        return this.components.contains(formula);
    }

    @Override
    @TestMethod(value="testGetMolecularFormulas_int")
    public IMolecularFormula getMolecularFormula(int position) {
        return this.components.get(position);
    }

    @Override
    @TestMethod(value="testRemoveAllMolecularFormulas")
    public void removeAllMolecularFormulas() {
        this.components.clear();
    }

    @Override
    @TestMethod(value="testRemoveMolecularFormula_IMolecularFormula")
    public void removeMolecularFormula(IMolecularFormula formula) {
        this.components.remove(formula);
    }

    @Override
    @TestMethod(value="testRemoveMolecularFormula_int")
    public void removeMolecularFormula(int position) {
        this.components.remove(position);
    }

    @Override
    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        AdductFormula clone = new AdductFormula();
        for (IMolecularFormula form : this.molecularFormulas()) {
            clone.addMolecularFormula((IMolecularFormula)form.clone());
        }
        return clone;
    }

    private boolean isTheSame(IIsotope isotopeOne, IIsotope isotopeTwo) {
        if (isotopeOne.getSymbol() != isotopeTwo.getSymbol()) {
            return false;
        }
        if (isotopeOne.getNaturalAbundance() != isotopeTwo.getNaturalAbundance()) {
            return false;
        }
        return isotopeOne.getExactMass() == isotopeTwo.getExactMass();
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return SilentChemObjectBuilder.getInstance();
    }
}

