/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

@TestClass(value="org.openscience.cdk.renderer.generators.ReactionSceneGeneratorTest")
public class ReactionSceneGenerator
implements IGenerator<IReaction> {
    private IGeneratorParameter<Boolean> showReactionBoxes = new ShowReactionBoxes();
    private IGeneratorParameter<Double> arrowHeadWidth = new ArrowHeadWidth();

    @Override
    @TestMethod(value="testEmptyReaction")
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        return new ElementGroup();
    }

    @Override
    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.showReactionBoxes, this.arrowHeadWidth);
    }

    public static class ArrowHeadWidth
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 10.0;
        }
    }

    public static class ShowReactionBoxes
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }
}

