/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.surface;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;

public class NeighborList {
    HashMap<String, List> boxes;
    double boxSize;
    IAtom[] atoms;

    public NeighborList(IAtom[] atoms, double radius) {
        this.atoms = atoms;
        this.boxes = new HashMap();
        this.boxSize = 2.0 * radius;
        for (int i = 0; i < atoms.length; ++i) {
            String key = this.getKeyString(atoms[i]);
            if (this.boxes.containsKey(key)) {
                List arl = this.boxes.get(key);
                arl.add(i);
                this.boxes.put(key, arl);
                continue;
            }
            this.boxes.put(key, new ArrayList());
        }
    }

    private String getKeyString(IAtom atom) {
        double x = atom.getPoint3d().x;
        double y = atom.getPoint3d().y;
        double z = atom.getPoint3d().z;
        int k1 = (int)Math.floor(x / this.boxSize);
        int k2 = (int)Math.floor(y / this.boxSize);
        int k3 = (int)Math.floor(z / this.boxSize);
        String key = Integer.toString(k1) + " " + Integer.toString(k2) + " " + Integer.toString(k3) + " ";
        return key;
    }

    private int[] getKeyArray(IAtom atom) {
        double x = atom.getPoint3d().x;
        double y = atom.getPoint3d().y;
        double z = atom.getPoint3d().z;
        int k1 = (int)Math.floor(x / this.boxSize);
        int k2 = (int)Math.floor(y / this.boxSize);
        int k3 = (int)Math.floor(z / this.boxSize);
        int[] ret = new int[]{k1, k2, k3};
        return ret;
    }

    public int getNumberOfNeighbors(int i) {
        return this.getNeighbors(i).length;
    }

    public int[] getNeighbors(int ii) {
        int j;
        double maxDist2 = this.boxSize * this.boxSize;
        IAtom ai = this.atoms[ii];
        int[] key = this.getKeyArray(ai);
        ArrayList<Integer> nlist = new ArrayList<Integer>();
        int[] bval = new int[]{-1, 0, 1};
        for (int i = 0; i < bval.length; ++i) {
            int x = bval[i];
            for (j = 0; j < bval.length; ++j) {
                int y = bval[j];
                for (int k = 0; k < bval.length; ++k) {
                    int z = bval[k];
                    String keyj = Integer.toString(key[0] + x) + " " + Integer.toString(key[1] + y) + " " + Integer.toString(key[2] + z) + " ";
                    if (!this.boxes.containsKey(keyj)) continue;
                    ArrayList nbrs = (ArrayList)this.boxes.get(keyj);
                    for (int l = 0; l < nbrs.size(); ++l) {
                        int i2 = (Integer)nbrs.get(l);
                        if (i2 == ii) continue;
                        IAtom aj = this.atoms[i2];
                        double x12 = aj.getPoint3d().x - ai.getPoint3d().x;
                        double y12 = aj.getPoint3d().y - ai.getPoint3d().y;
                        double z12 = aj.getPoint3d().z - ai.getPoint3d().z;
                        double d2 = x12 * x12 + y12 * y12 + z12 * z12;
                        if (!(d2 < maxDist2)) continue;
                        nlist.add(i2);
                    }
                }
            }
        }
        Object[] tmp = nlist.toArray();
        int[] ret = new int[tmp.length];
        for (j = 0; j < tmp.length; ++j) {
            ret[j] = (Integer)tmp[j];
        }
        return ret;
    }
}

