/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.program;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MOPAC7InputFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.io.program.Mopac7WriterTest")
public class Mopac7Writer
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Mopac7Writer.class);
    private static final char BLANK = ' ';
    private NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
    private StringIOSetting mopacCommands;
    private BooleanIOSetting optimize;

    public Mopac7Writer() throws IOException {
        this(new BufferedWriter(new StringWriter()));
    }

    public Mopac7Writer(OutputStream out) throws IOException {
        this(new BufferedWriter(new OutputStreamWriter(out)));
    }

    public Mopac7Writer(Writer out) throws IOException {
        this.numberFormat.setMaximumFractionDigits(4);
        this.writer = new BufferedWriter(out);
        this.initIOSettings();
    }

    @TestMethod(value="testWrite")
    public synchronized void write(IChemObject arg0) throws CDKException {
        this.customizeJob();
        if (arg0 instanceof IAtomContainer) {
            try {
                IAtomContainer container = (IAtomContainer)arg0;
                this.writer.write(this.mopacCommands.getSetting());
                int formalCharge = AtomContainerManipulator.getTotalFormalCharge(container);
                if (formalCharge != 0) {
                    this.writer.write(" CHARGE=" + formalCharge);
                }
                this.writer.newLine();
                if (container.getProperty("Names") != null) {
                    this.writer.write(container.getProperty("Names").toString());
                }
                this.writer.newLine();
                this.writer.write(this.getTitle());
                this.writer.newLine();
                for (int i = 0; i < container.getAtomCount(); ++i) {
                    Serializable point;
                    IAtom atom = container.getAtom(i);
                    if (atom.getPoint3d() != null) {
                        point = atom.getPoint3d();
                        this.writeAtom(atom, point.x, point.y, point.z, this.optimize.isSet() ? 1 : 0);
                        continue;
                    }
                    if (atom.getPoint2d() != null) {
                        point = atom.getPoint2d();
                        this.writeAtom(atom, ((Point2d)point).x, ((Point2d)point).y, 0.0, this.optimize.isSet() ? 1 : 0);
                        continue;
                    }
                    this.writeAtom(atom, 0.0, 0.0, 0.0, 1);
                }
                this.writer.write("0");
                this.writer.newLine();
            }
            catch (IOException ioException) {
                logger.error(ioException);
                throw new CDKException(ioException.getMessage(), ioException);
            }
        } else {
            throw new CDKException("Unsupported object!\t" + arg0.getClass().getName());
        }
    }

    private void writeAtom(IAtom atom, double xCoord, double yCoord, double zCoord, int optimize) throws IOException {
        this.writer.write(atom.getSymbol());
        this.writer.write(32);
        this.writer.write(this.numberFormat.format(xCoord));
        this.writer.write(32);
        this.writer.write(Integer.toString(optimize));
        this.writer.write(32);
        this.writer.write(this.numberFormat.format(yCoord));
        this.writer.write(32);
        this.writer.write(Integer.toString(optimize));
        this.writer.write(32);
        this.writer.write(this.numberFormat.format(zCoord));
        this.writer.write(32);
        this.writer.write(Integer.toString(optimize));
        this.writer.write(32);
        this.writer.newLine();
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.writer.close();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MOPAC7InputFormat.getInstance();
    }

    @TestMethod(value="testSetWriter_Writer")
    public void setWriter(OutputStream writer) throws CDKException {
        this.setWriter(new OutputStreamWriter(writer));
    }

    @TestMethod(value="testSetWriter_OutputStream")
    public void setWriter(Writer writer) throws CDKException {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException exception) {
                logger.error(exception);
            }
            this.writer = null;
        }
        this.writer = new BufferedWriter(writer);
    }

    private String getTitle() {
        return "Generated by " + this.getClass().getName() + " at " + new Date(System.currentTimeMillis());
    }

    private void initIOSettings() {
        this.optimize = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("Optimize", IOSetting.Importance.MEDIUM, "Should the structure be optimized?", "true"));
        this.mopacCommands = (StringIOSetting)this.addSetting(new StringIOSetting("Commands", IOSetting.Importance.LOW, "What Mopac commands should be used (overwrites other choices)?", "PM3 NOINTER NOMM BONDS MULLIK PRECISE"));
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.optimize);
        try {
            if (this.optimize.isSet()) {
                this.mopacCommands.setSetting("PM3 NOINTER NOMM BONDS MULLIK PRECISE");
            } else {
                this.mopacCommands.setSetting("PM3 NOINTER NOMM BONDS MULLIK XYZ 1SCF");
            }
        }
        catch (CDKException exception) {
            throw new IllegalArgumentException(exception);
        }
        this.fireIOSettingQuestion(this.mopacCommands);
    }
}

