/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.GamessFormat;
import org.openscience.cdk.io.formats.IResourceFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.GamessReaderTest")
public class GamessReader
extends DefaultChemObjectReader {
    public static final boolean BOHR_UNIT = true;
    public static final double BOHR_TO_ANGSTROM = 0.529177249;
    public static final boolean ANGSTROM_UNIT = false;
    private BufferedReader input;

    public GamessReader(Reader inputReader) {
        this.input = new BufferedReader(inputReader);
    }

    public GamessReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public GamessReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return GamessFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(this.input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            try {
                return (T)this.readChemFile((IChemFile)object);
            }
            catch (IOException e) {
                return null;
            }
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile file) throws IOException {
        IChemSequence sequence = file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel model = file.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet moleculeSet = file.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        model.setMoleculeSet(moleculeSet);
        sequence.addChemModel(model);
        file.addChemSequence(sequence);
        String currentReadLine = this.input.readLine();
        while (this.input.ready() && currentReadLine != null) {
            if (currentReadLine.indexOf("COORDINATES (BOHR)") >= 0) {
                this.input.readLine();
                moleculeSet.addAtomContainer(this.readCoordinates(file.getBuilder().newInstance(IAtomContainer.class, new Object[0]), true));
            } else if (currentReadLine.indexOf(" COORDINATES OF ALL ATOMS ARE (ANGS)") >= 0) {
                this.input.readLine();
                this.input.readLine();
                moleculeSet.addAtomContainer(this.readCoordinates(file.getBuilder().newInstance(IAtomContainer.class, new Object[0]), false));
            }
            currentReadLine = this.input.readLine();
        }
        return file;
    }

    private IAtomContainer readCoordinates(IAtomContainer molecule, boolean coordinatesUnits) throws IOException {
        String retrievedLineFromFile;
        double unitScaling = GamessReader.scalesCoordinatesUnits(coordinatesUnits);
        while (this.input.ready() && (retrievedLineFromFile = this.input.readLine()) != null && retrievedLineFromFile.trim().length() != 0) {
            String atomicSymbol;
            StreamTokenizer token = new StreamTokenizer(new StringReader(retrievedLineFromFile));
            token.nextToken();
            if (token.nextToken() == -2) {
                int atomicNumber = (int)token.nval;
                atomicSymbol = this.identifyAtomicSymbol(atomicNumber);
                if (atomicNumber == 0) {
                    continue;
                }
            } else {
                throw new IOException("Error reading coordinates");
            }
            double[] coordinates = new double[3];
            for (int i = 0; i < coordinates.length; ++i) {
                if (token.nextToken() != -2) {
                    throw new IOException("Error reading coordinates");
                }
                coordinates[i] = token.nval * unitScaling;
            }
            IAtom atom = molecule.getBuilder().newInstance(IAtom.class, atomicSymbol, new Point3d(coordinates[0], coordinates[1], coordinates[2]));
            molecule.addAtom(atom);
        }
        return molecule;
    }

    private String identifyAtomicSymbol(int atomicNumber) {
        String symbol;
        switch (atomicNumber) {
            case 1: {
                symbol = "H";
                break;
            }
            case 2: {
                symbol = "He";
                break;
            }
            case 3: {
                symbol = "Li";
                break;
            }
            case 4: {
                symbol = "Be";
                break;
            }
            case 5: {
                symbol = "B";
                break;
            }
            case 6: {
                symbol = "C";
                break;
            }
            case 7: {
                symbol = "N";
                break;
            }
            case 8: {
                symbol = "O";
                break;
            }
            case 9: {
                symbol = "F";
                break;
            }
            case 10: {
                symbol = "Ne";
                break;
            }
            case 11: {
                symbol = "Na";
                break;
            }
            case 12: {
                symbol = "Mg";
                break;
            }
            case 13: {
                symbol = "Al";
                break;
            }
            case 14: {
                symbol = "Si";
                break;
            }
            case 15: {
                symbol = "P";
                break;
            }
            case 16: {
                symbol = "S";
                break;
            }
            case 17: {
                symbol = "Cl";
                break;
            }
            case 18: {
                symbol = "Ar";
                break;
            }
            default: {
                symbol = null;
            }
        }
        return symbol;
    }

    private static double scalesCoordinatesUnits(boolean coordinatesUnits) {
        if (coordinatesUnits) {
            return 0.529177249;
        }
        return 1.0;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

