/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.xslt;

import java.io.IOException;
import nu.xom.converters.SAXConverter;
import nu.xom.xslt.XOMInputSource;
import nu.xom.xslt.XSLTHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class XOMReader
implements XMLReader {
    private SAXConverter converter;

    XOMReader() {
    }

    public boolean getFeature(String uri) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespace-prefixes".equals(uri) || "http://xml.org/sax/features/namespaces".equals(uri)) {
            return true;
        }
        throw new SAXNotRecognizedException("XOMReader doesn't support features");
    }

    public void setFeature(String uri, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String uri) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(uri)) {
            return this.converter.getLexicalHandler();
        }
        throw new SAXNotRecognizedException("XOMReader doesn't support features");
    }

    public void setProperty(String uri, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!"http://xml.org/sax/properties/lexical-handler".equals(uri)) {
            throw new SAXNotRecognizedException("XOMReader doesn't support " + uri);
        }
        LexicalHandler handler = (LexicalHandler)value;
        this.converter.setLexicalHandler(handler);
    }

    public void setEntityResolver(EntityResolver resolver) {
        throw new UnsupportedOperationException();
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler handler) {
        this.converter = new SAXConverter(handler);
        this.converter.setContentHandler(new XSLTHandler(null));
    }

    public ContentHandler getContentHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource source) throws IOException, SAXException {
        XOMInputSource xis = (XOMInputSource)source;
        this.converter.convert(xis.getNodes());
    }

    public void parse(String url) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }
}

