/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff.tree;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.tools.diff.tree.IDifference;

@TestClass(value="org.openscience.cdk.tools.diff.tree.DoubleDifferenceTest")
public class DoubleDifference
implements IDifference {
    private static final double ERROR = 1.0E-9;
    private String name;
    private Double first;
    private Double second;

    private DoubleDifference(String name, Double first, Double second) {
        this.name = name;
        this.first = first;
        this.second = second;
    }

    @TestMethod(value="testDiff,testSame,testTwoNull,testOneNull")
    public static IDifference construct(String name, Double first, Double second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null || second == null) {
            return new DoubleDifference(name, first, second);
        }
        if (Math.abs(first - second) < 1.0E-9) {
            return null;
        }
        return new DoubleDifference(name, first, second);
    }

    @TestMethod(value="testToString")
    public String toString() {
        return this.name + ":" + (this.first == null ? "NA" : this.first) + "/" + (this.second == null ? "NA" : this.second);
    }
}

