/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.Builtin;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

public abstract class BaseBuiltin
implements Builtin {
    public static final String BASE_URI = "http://jena.hpl.hp.com/2003/RuleBuiltin/";

    public String getURI() {
        return BASE_URI + this.getName();
    }

    public int getArgLength() {
        return 0;
    }

    public void checkArgs(int length, RuleContext context) {
        int expected = this.getArgLength();
        if (expected > 0 && expected != length) {
            throw new BuiltinException(this, context, "builtin " + this.getName() + " requires " + expected + " arguments but saw " + length);
        }
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        throw new BuiltinException(this, context, "builtin " + this.getName() + " not usable in rule bodies");
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        throw new BuiltinException(this, context, "builtin " + this.getName() + " not usable in rule heads");
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isMonotonic() {
        return true;
    }

    public Node getArg(int n, Node[] args, RuleContext context) {
        return context.getEnv().getGroundVersion(args[n]);
    }
}

