/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import signature.chemistry.Molecule;
import signature.chemistry.MoleculeQuotientGraph;
import signature.chemistry.MoleculeReader;
import signature.chemistry.MoleculeSignature;
import signature.display.TreeDrawer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LargeMoleculeTest {
    public void addRing(int atomToAttachTo, int ringSize, Molecule molecule) {
        int numberOfAtoms = molecule.getAtomCount();
        int previous = atomToAttachTo;
        int i = 0;
        while (i < ringSize) {
            molecule.addAtom("C");
            int current = numberOfAtoms + i;
            molecule.addSingleBond(previous, current);
            previous = current;
            ++i;
        }
        molecule.addSingleBond(numberOfAtoms, numberOfAtoms + (ringSize - 1));
    }

    public Molecule makeMinimalMultiRing(int ringCount, int ringSize) {
        Molecule mol = new Molecule();
        mol.addAtom("C");
        int i = 0;
        while (i < ringCount) {
            this.addRing(0, ringSize, mol);
            ++i;
        }
        return mol;
    }

    public Molecule makeTetrakisTriphenylPhosphoranylRhodium() {
        Molecule ttpr = new Molecule();
        ttpr.addAtom("Rh");
        int phosphateCount = 3;
        int i = 1;
        while (i <= phosphateCount) {
            ttpr.addAtom("P");
            ttpr.addSingleBond(0, i);
            ++i;
        }
        int phenylCount = 3;
        int j = 1;
        while (j <= phosphateCount) {
            int k = 0;
            while (k < phenylCount) {
                this.addRing(j, 6, ttpr);
                ++k;
            }
            ++j;
        }
        return ttpr;
    }

    @Test
    public void dodecahedraneTest() {
        Molecule mol = new Molecule();
        int i = 0;
        while (i < 20) {
            mol.addAtom("C");
            ++i;
        }
        mol.addBond(0, 1, 1);
        mol.addBond(0, 4, 1);
        mol.addBond(0, 5, 2);
        mol.addBond(1, 2, 1);
        mol.addBond(1, 6, 2);
        mol.addBond(2, 3, 2);
        mol.addBond(2, 7, 1);
        mol.addBond(3, 4, 1);
        mol.addBond(3, 8, 1);
        mol.addBond(4, 9, 2);
        mol.addBond(5, 10, 1);
        mol.addBond(5, 11, 1);
        mol.addBond(6, 11, 1);
        mol.addBond(6, 12, 1);
        mol.addBond(7, 12, 2);
        mol.addBond(7, 13, 1);
        mol.addBond(8, 13, 2);
        mol.addBond(8, 14, 1);
        mol.addBond(9, 10, 1);
        mol.addBond(9, 14, 1);
        mol.addBond(10, 15, 2);
        mol.addBond(11, 16, 2);
        mol.addBond(12, 17, 1);
        mol.addBond(13, 18, 1);
        mol.addBond(14, 19, 2);
        mol.addBond(15, 16, 1);
        mol.addBond(15, 19, 1);
        mol.addBond(16, 17, 1);
        mol.addBond(17, 18, 2);
        mol.addBond(18, 19, 1);
        i = 0;
        while (i < 20) {
            Assert.assertEquals((String)("Atom " + i + " has wrong order"), (int)4, (int)mol.getTotalOrder(i));
            ++i;
        }
        MoleculeQuotientGraph mqg = new MoleculeQuotientGraph(mol);
        System.out.println(mqg);
        Assert.assertEquals((int)5, (int)mqg.getVertexCount());
        Assert.assertEquals((int)9, (int)mqg.getEdgeCount());
        Assert.assertEquals((int)3, (int)mqg.numberOfLoopEdges());
    }

    @Test
    public void ttprTest() {
        Molecule ttpr = this.makeTetrakisTriphenylPhosphoranylRhodium();
        MoleculeSignature molSig = new MoleculeSignature(ttpr);
        String sigString = molSig.signatureStringForVertex(0);
        System.out.println(sigString);
    }

    @Test
    public void testMinimalMol() {
        Molecule mol = this.makeMinimalMultiRing(6, 3);
        MoleculeSignature molSig = new MoleculeSignature(mol);
        String sigString = molSig.signatureStringForVertex(0);
        System.out.println(sigString);
        System.out.println(mol);
        System.out.println("result " + sigString);
    }

    public Molecule makeChain(int length) {
        Molecule chain = new Molecule();
        int previous = -1;
        int i = 0;
        while (i < length) {
            chain.addAtom("C");
            if (previous != -1) {
                chain.addSingleBond(previous, i);
            }
            previous = i++;
        }
        return chain;
    }

    @Test
    public void testLongChains() {
        int length = 10;
        Molecule chain = this.makeChain(length);
        MoleculeSignature molSig = new MoleculeSignature(chain);
        String sigString = molSig.toCanonicalString();
        System.out.println(sigString);
    }

    public void drawTrees(MoleculeQuotientGraph mqg, String directoryPath) {
        List<String> signatureStrings = mqg.getVertexSignatureStrings();
        int w = 1200;
        int h = 400;
        TreeDrawer.makeTreeImages(signatureStrings, directoryPath, w, h);
    }

    @Test
    public void buckyballTest() {
        Molecule molecule = MoleculeReader.readMolfile("data/buckyball.mol");
        MoleculeQuotientGraph mqg = new MoleculeQuotientGraph(molecule);
        System.out.println(mqg);
        Assert.assertEquals((int)32, (int)mqg.getVertexCount());
        Assert.assertEquals((int)49, (int)mqg.getEdgeCount());
        Assert.assertEquals((int)6, (int)mqg.numberOfLoopEdges());
    }

    @Test
    public void buckyballWithoutMultipleBonds() {
        Molecule molecule = MoleculeReader.readMolfile("data/buckyball.mol");
        for (Molecule.Bond bond : molecule.bonds()) {
            bond.order = 1;
        }
        MoleculeQuotientGraph mqg = new MoleculeQuotientGraph(molecule);
        System.out.println(mqg);
        Assert.assertEquals((int)1, (int)mqg.getVertexCount());
        Assert.assertEquals((int)1, (int)mqg.getEdgeCount());
        Assert.assertEquals((int)1, (int)mqg.numberOfLoopEdges());
    }

    @Test
    public void faulonsBuckySignatures() {
        Molecule mol = MoleculeReader.readMolfile("data/buckyball.mol");
        try {
            String filename = "data/buckysigs3.txt";
            List<String> sigs = this.readSigs2(filename);
            MoleculeQuotientGraph mqg = new MoleculeQuotientGraph(mol, sigs);
            System.out.println(mqg);
            Assert.assertEquals((int)32, (int)mqg.getVertexCount());
            Assert.assertEquals((int)49, (int)mqg.getEdgeCount());
            Assert.assertEquals((int)6, (int)mqg.numberOfLoopEdges());
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }

    public List<String> readSigs(String filename) throws Exception {
        String line;
        File file = new File(filename);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> sigs = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(" ") + 1;
            int count = Integer.parseInt(line.substring(0, index - 1));
            String sig = line.substring(index);
            System.out.println(count);
            sigs.add(sig);
        }
        return sigs;
    }

    public List<String> readSigs2(String filename) throws Exception {
        String line;
        File file = new File(filename);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> sigs = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            String[] bits = line.split("\\s+");
            String sig = bits[3];
            sigs.add(sig);
        }
        Collections.reverse(sigs);
        return sigs;
    }

    public static void main(String[] args) {
        new LargeMoleculeTest().testMinimalMol();
    }
}

