/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import java.util.List;
import java.util.Map;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class MergeMoleculesEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -4093867960954400453L;
    private IAtom deletedAtom;
    private List<IBond> deletedBonds;
    private Map<IBond, Integer> bondsWithReplacedAtom;
    private IChemModelRelay c2dm;
    private String type;
    private IAtomContainer ac;
    private Vector2d offset;
    private IAtom atomwhichwasmoved;

    public MergeMoleculesEdit(IAtom deletedAtom, IAtomContainer containerWhereAtomWasIn, List<IBond> deletedBonds, Map<IBond, Integer> bondsWithReplacedAtom, Vector2d offset, IAtom atomwhichwasmoved, String type, IChemModelRelay c2dm) {
        this.deletedAtom = deletedAtom;
        this.deletedBonds = deletedBonds;
        this.bondsWithReplacedAtom = bondsWithReplacedAtom;
        this.c2dm = c2dm;
        this.atomwhichwasmoved = atomwhichwasmoved;
        this.type = type;
        this.ac = containerWhereAtomWasIn;
        this.offset = offset;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.ac.removeAtom(this.deletedAtom);
        for (IBond bond : this.deletedBonds) {
            this.ac.removeBond(bond);
        }
        for (IBond bond : this.bondsWithReplacedAtom.keySet()) {
            bond.setAtom(this.atomwhichwasmoved, this.bondsWithReplacedAtom.get(bond).intValue());
        }
        this.deletedAtom.getPoint2d().x -= this.offset.x;
        this.deletedAtom.getPoint2d().y -= this.offset.y;
        this.atomwhichwasmoved.getPoint2d().x -= this.offset.x;
        this.atomwhichwasmoved.getPoint2d().y -= this.offset.y;
        this.c2dm.updateAtom(this.atomwhichwasmoved);
    }

    @Override
    public void undo() throws CannotUndoException {
        this.ac.addAtom(this.deletedAtom);
        for (IBond bond : this.deletedBonds) {
            this.ac.addBond(bond);
        }
        for (IBond bond : this.bondsWithReplacedAtom.keySet()) {
            bond.setAtom(this.deletedAtom, this.bondsWithReplacedAtom.get(bond).intValue());
        }
        this.deletedAtom.getPoint2d().x += this.offset.x;
        this.deletedAtom.getPoint2d().y += this.offset.y;
        this.atomwhichwasmoved.getPoint2d().x += this.offset.x;
        this.atomwhichwasmoved.getPoint2d().y += this.offset.y;
        this.c2dm.updateAtom(this.deletedAtom);
        this.c2dm.updateAtom(this.atomwhichwasmoved);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

