/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.HighlightModule;
import org.openscience.cdk.controller.IChemModelEventRelayHandler;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.IControllerModel;
import org.openscience.cdk.controller.IControllerModule;
import org.openscience.cdk.controller.IMouseEventRelay;
import org.openscience.cdk.controller.IViewEventRelay;
import org.openscience.cdk.controller.ZoomModule;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.controller.edit.OptionalUndoEdit;
import org.openscience.cdk.controller.undoredo.IUndoRedoFactory;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.controller.undoredo.UndoRedoHandler;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.layout.AtomPlacer;
import org.openscience.cdk.layout.RingPlacer;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.layout.TemplateHandler;
import org.openscience.cdk.nonotify.NoNotificationChemObjectBuilder;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.HighlightAtomGenerator;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;
import org.openscience.cdk.renderer.selection.IncrementalSelection;
import org.openscience.cdk.tools.SaturationChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.cdk.tools.manipulator.ReactionSetManipulator;
import org.openscience.cdk.validate.ProblemMarker;

public class ControllerHub
implements IMouseEventRelay,
IChemModelRelay {
    private IChemModel chemModel;
    private IControllerModel controllerModel;
    private IRenderer renderer;
    private IViewEventRelay eventRelay;
    private List<IControllerModule> generalModules;
    private static StructureDiagramGenerator diagramGenerator;
    private IControllerModule activeDrawModule;
    private static final RingPlacer ringPlacer;
    private IAtomContainer phantoms;
    private IChemModelEventRelayHandler changeHandler;
    private IUndoRedoFactory undoredofactory;
    private UndoRedoHandler undoredohandler;
    private CDKAtomTypeMatcher matcher;

    public ControllerHub(IControllerModel controllerModel, IRenderer renderer, IChemModel chemModel, IViewEventRelay eventRelay, UndoRedoHandler undoredohandler, IUndoRedoFactory undoredofactory) {
        this.controllerModel = controllerModel;
        this.renderer = renderer;
        this.chemModel = chemModel;
        this.eventRelay = eventRelay;
        this.phantoms = (IAtomContainer)chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        this.undoredofactory = undoredofactory;
        this.undoredohandler = undoredohandler;
        this.generalModules = new ArrayList<IControllerModule>();
        this.registerGeneralControllerModule(new HighlightModule(this));
        this.registerGeneralControllerModule(new ZoomModule(this));
        this.matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)chemModel.getBuilder());
    }

    public IControllerModel getController2DModel() {
        return this.controllerModel;
    }

    @Override
    public IControllerModel getControlModel() {
        return this.controllerModel;
    }

    @Override
    public IRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public RendererModel getRenderModel() {
        return this.renderer.getRenderer2DModel();
    }

    @Override
    public IChemModel getIChemModel() {
        return this.chemModel;
    }

    public void setChemModel(IChemModel model) {
        this.chemModel = model;
    }

    public void unRegisterAllControllerModule() {
        this.generalModules.clear();
    }

    public void registerGeneralControllerModule(IControllerModule module) {
        module.setChemModelRelay(this);
        this.generalModules.add(module);
    }

    public void mouseWheelMovedBackward(int clicks) {
        for (IControllerModule module : this.generalModules) {
            module.mouseWheelMovedBackward(clicks);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseWheelMovedBackward(clicks);
        }
    }

    public void mouseWheelMovedForward(int clicks) {
        for (IControllerModule module : this.generalModules) {
            module.mouseWheelMovedForward(clicks);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseWheelMovedForward(clicks);
        }
    }

    @Override
    public void mouseClickedDouble(int screenCoordX, int screenCoordY) {
        Point2d worldCoord = this.renderer.toModelCoordinates(screenCoordX, screenCoordY);
        for (IControllerModule module : this.generalModules) {
            module.mouseClickedDouble(worldCoord);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseClickedDouble(worldCoord);
        }
    }

    @Override
    public void mouseClickedDownRight(int screenX, int screenY) {
        Point2d modelCoord = this.renderer.toModelCoordinates(screenX, screenY);
        for (IControllerModule module : this.generalModules) {
            module.mouseClickedDownRight(modelCoord);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseClickedDownRight(modelCoord);
        }
    }

    @Override
    public void mouseClickedUpRight(int screenX, int screenY) {
        Point2d modelCoord = this.renderer.toModelCoordinates(screenX, screenY);
        for (IControllerModule module : this.generalModules) {
            module.mouseClickedUpRight(modelCoord);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseClickedUpRight(modelCoord);
        }
    }

    @Override
    public void mouseClickedDown(int screenX, int screenY) {
        Point2d modelCoord = this.renderer.toModelCoordinates(screenX, screenY);
        for (IControllerModule module : this.generalModules) {
            module.mouseClickedDown(modelCoord);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseClickedDown(modelCoord);
        }
    }

    @Override
    public void mouseClickedUp(int screenX, int screenY) {
        Point2d modelCoord = this.renderer.toModelCoordinates(screenX, screenY);
        for (IControllerModule module : this.generalModules) {
            module.mouseClickedUp(modelCoord);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseClickedUp(modelCoord);
        }
    }

    @Override
    public void mouseDrag(int screenXFrom, int screenYFrom, int screenXTo, int screenYTo) {
        Point2d modelCoordFrom = this.renderer.toModelCoordinates(screenXFrom, screenYFrom);
        Point2d modelCoordTo = this.renderer.toModelCoordinates(screenXTo, screenYTo);
        for (IControllerModule module : this.generalModules) {
            module.mouseDrag(modelCoordFrom, modelCoordTo);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseDrag(modelCoordFrom, modelCoordTo);
        }
    }

    @Override
    public void mouseEnter(int screenX, int screenY) {
        Point2d worldCoord = this.renderer.toModelCoordinates(screenX, screenY);
        for (IControllerModule module : this.generalModules) {
            module.mouseEnter(worldCoord);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseEnter(worldCoord);
        }
    }

    @Override
    public void mouseExit(int screenX, int screenY) {
        Point2d worldCoord = this.renderer.toModelCoordinates(screenX, screenY);
        for (IControllerModule module : this.generalModules) {
            module.mouseExit(worldCoord);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseExit(worldCoord);
        }
    }

    @Override
    public void mouseMove(int screenX, int screenY) {
        Point2d worldCoord = this.renderer.toModelCoordinates(screenX, screenY);
        for (IControllerModule module : this.generalModules) {
            module.mouseMove(worldCoord);
        }
        IControllerModule activeModule = this.getActiveDrawModule();
        if (activeModule != null) {
            activeModule.mouseMove(worldCoord);
        }
    }

    @Override
    public void updateView() {
        this.eventRelay.updateView();
    }

    public IControllerModule getActiveDrawModule() {
        return this.activeDrawModule;
    }

    public void setActiveDrawModule(IControllerModule activeDrawModule) {
        this.activeDrawModule = activeDrawModule;
    }

    @Override
    public IAtom getClosestAtom(Point2d worldCoord) {
        IAtom closestAtom = null;
        double closestDistanceSQ = Double.MAX_VALUE;
        for (IAtomContainer atomContainer : ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel)) {
            for (IAtom atom : atomContainer.atoms()) {
                double distanceSQ;
                if (atom.getPoint2d() == null || !((distanceSQ = atom.getPoint2d().distanceSquared(worldCoord)) < closestDistanceSQ)) continue;
                closestAtom = atom;
                closestDistanceSQ = distanceSQ;
            }
        }
        return closestAtom;
    }

    @Override
    public IBond getClosestBond(Point2d worldCoord) {
        IBond closestBond = null;
        double closestDistanceSQ = Double.MAX_VALUE;
        for (IAtomContainer atomContainer : ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel)) {
            for (IBond bond : atomContainer.bonds()) {
                double distanceSQ;
                boolean hasCenter = true;
                for (IAtom atom : bond.atoms()) {
                    hasCenter = hasCenter && atom.getPoint2d() != null;
                }
                if (!hasCenter || !((distanceSQ = bond.get2DCenter().distanceSquared(worldCoord)) < closestDistanceSQ)) continue;
                closestBond = bond;
                closestDistanceSQ = distanceSQ;
            }
        }
        return closestBond;
    }

    @Override
    public IAtomContainer removeAtomWithoutUndo(IAtom atom) {
        IAtomContainer ac = (IAtomContainer)atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        ac.addAtom(atom);
        Iterator connbonds = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)atom).getConnectedBondsList(atom).iterator();
        while (connbonds.hasNext()) {
            ac.addBond((IBond)connbonds.next());
        }
        ChemModelManipulator.removeAtomAndConnectedElectronContainers((IChemModel)this.chemModel, (IAtom)atom);
        for (IBond bond : ac.bonds()) {
            if (bond.getAtom(0) == atom) {
                this.updateAtom(bond.getAtom(1));
                continue;
            }
            this.updateAtom(bond.getAtom(0));
        }
        this.structureChanged();
        return ac;
    }

    @Override
    public IAtomContainer removeAtom(IAtom atom) {
        IAtomContainer ac = this.removeAtomWithoutUndo(atom);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getRemoveAtomsAndBondsEdit(this.getIChemModel(), ac, "Remove Atom", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        return ac;
    }

    @Override
    public IAtom addAtom(String atomType, Point2d worldCoord) {
        IAtomContainer undoRedoContainer = (IAtomContainer)this.chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        undoRedoContainer.addAtom(this.addAtomWithoutUndo(atomType, worldCoord));
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAddAtomsAndBondsEdit(this.chemModel, undoRedoContainer, "Add Atom", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        return undoRedoContainer.getAtom(0);
    }

    @Override
    public IAtom addAtomWithoutUndo(String atomType, Point2d worldCoord) {
        IAtom newAtom = (IAtom)this.chemModel.getBuilder().newInstance(IAtom.class, new Object[]{atomType, worldCoord});
        IMoleculeSet molSet = this.chemModel.getMoleculeSet();
        if (molSet == null) {
            molSet = (IMoleculeSet)this.chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
            IMolecule ac = (IMolecule)this.chemModel.getBuilder().newInstance(IMolecule.class, new Object[0]);
            ac.addAtom(newAtom);
            molSet.addMolecule(ac);
            this.chemModel.setMoleculeSet(molSet);
        } else {
            molSet.getMolecule(0).addAtom(newAtom);
        }
        this.updateAtom(newAtom);
        RendererModel model = this.getRenderer().getRenderer2DModel();
        double nudgeDistance = (Double)model.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        if (this.getClosestAtom(newAtom) != null) {
            newAtom.getPoint2d().x += nudgeDistance;
        }
        this.structureChanged();
        return newAtom;
    }

    @Override
    public IAtom addAtom(String atomType, IAtom atom) {
        IAtomContainer undoRedoContainer = (IAtomContainer)atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        undoRedoContainer.addAtom(this.addAtomWithoutUndo(atomType, atom));
        IAtomContainer atomContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.getIChemModel(), (IAtom)undoRedoContainer.getAtom(0));
        IBond newBond = atomContainer.getBond(atom, undoRedoContainer.getAtom(0));
        undoRedoContainer.addBond(newBond);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAddAtomsAndBondsEdit(this.chemModel, undoRedoContainer, "Add Atom", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        return undoRedoContainer.getAtom(0);
    }

    @Override
    public IAtom addAtomWithoutUndo(String atomType, IAtom atom) {
        IAtom newAtom = (IAtom)this.chemModel.getBuilder().newInstance(IAtom.class, new Object[]{atomType});
        IBond newBond = (IBond)this.chemModel.getBuilder().newInstance(IBond.class, new Object[]{atom, newAtom});
        IAtomContainer atomCon = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)atom);
        if (atomCon == null) {
            atomCon = (IAtomContainer)this.chemModel.getBuilder().newInstance(IMolecule.class, new Object[0]);
            IMoleculeSet moleculeSet = this.chemModel.getMoleculeSet();
            if (moleculeSet == null) {
                moleculeSet = (IMoleculeSet)this.chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
                this.chemModel.setMoleculeSet(moleculeSet);
            }
            moleculeSet.addAtomContainer(atomCon);
        }
        AtomPlacer atomPlacer = new AtomPlacer();
        atomPlacer.setMolecule((IAtomContainer)this.chemModel.getBuilder().newInstance(IMolecule.class, new Object[]{atomCon}));
        double bondLength = atomCon.getBondCount() >= 1 ? GeometryTools.getBondLengthAverage((IAtomContainer)atomCon) : 1.4;
        List connectedAtoms = atomCon.getConnectedAtomsList(atom);
        if (connectedAtoms.size() == 0) {
            Point2d newAtomPoint = new Point2d(atom.getPoint2d());
            double angle = Math.toRadians(-30.0);
            Vector2d vec1 = new Vector2d(Math.cos(angle), Math.sin(angle));
            vec1.scale(bondLength);
            newAtomPoint.add(vec1);
            newAtom.setPoint2d(newAtomPoint);
        } else if (connectedAtoms.size() == 1) {
            IMolecule ac = (IMolecule)atomCon.getBuilder().newInstance(IMolecule.class, new Object[0]);
            ac.addAtom(atom);
            ac.addAtom(newAtom);
            Point2d distanceMeasure = new Point2d(0.0, 0.0);
            IAtom connectedAtom = (IAtom)connectedAtoms.get(0);
            Vector2d v = atomPlacer.getNextBondVector(atom, connectedAtom, distanceMeasure, true);
            atomPlacer.placeLinearChain((IAtomContainer)ac, v, bondLength);
        } else {
            IMolecule placedAtoms = (IMolecule)atomCon.getBuilder().newInstance(IMolecule.class, new Object[0]);
            for (IAtom conAtom : connectedAtoms) {
                placedAtoms.addAtom(conAtom);
            }
            Point2d center2D = GeometryTools.get2DCenter((IAtomContainer)placedAtoms);
            IAtomContainer unplacedAtoms = (IAtomContainer)atomCon.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            unplacedAtoms.addAtom(newAtom);
            atomPlacer.distributePartners(atom, (IAtomContainer)placedAtoms, center2D, unplacedAtoms, bondLength);
        }
        atomCon.addAtom(newAtom);
        atomCon.addBond(newBond);
        this.updateAtom(newBond.getAtom(0));
        this.updateAtom(newBond.getAtom(1));
        RendererModel model = this.getRenderer().getRenderer2DModel();
        double nudgeDistance = (Double)model.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        if (this.getClosestAtom(newAtom) != null) {
            newAtom.getPoint2d().x += nudgeDistance;
        }
        this.structureChanged();
        return newAtom;
    }

    @Override
    public void addNewBond(Point2d worldCoordinate) {
        IAtomContainer undoRedoContainer = (IAtomContainer)this.getIChemModel().getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        String atomType = this.getController2DModel().getDrawElement();
        IAtom atom = this.addAtomWithoutUndo(atomType, worldCoordinate);
        undoRedoContainer.addAtom(atom);
        IAtom newAtom = this.addAtomWithoutUndo(atomType, atom);
        undoRedoContainer.addAtom(newAtom);
        IAtomContainer atomContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.getIChemModel(), (IAtom)newAtom);
        IBond newBond = atomContainer.getBond(atom, newAtom);
        undoRedoContainer.addBond(newBond);
        this.updateAtom(newBond.getAtom(0));
        this.updateAtom(newBond.getAtom(1));
        this.structureChanged();
        if (this.undoredofactory != null && this.undoredohandler != null) {
            IUndoRedoable undoredo = this.undoredofactory.getAddAtomsAndBondsEdit(this.getIChemModel(), undoRedoContainer, "Add Bond", this);
            this.undoredohandler.postEdit(undoredo);
        }
    }

    @Override
    public void cycleBondValence(IBond bond) {
        IBond.Order[] orders = new IBond.Order[2];
        IBond.Stereo[] stereos = new IBond.Stereo[2];
        orders[1] = bond.getOrder();
        stereos[1] = bond.getStereo();
        if (bond.getStereo() != IBond.Stereo.NONE) {
            bond.setStereo(IBond.Stereo.NONE);
        } else {
            IBond.Order maxOrder = this.getController2DModel().getMaxOrder();
            if (BondManipulator.isLowerOrder((IBond.Order)bond.getOrder(), (IBond.Order)maxOrder)) {
                BondManipulator.increaseBondOrder((IBond)bond);
            } else {
                bond.setOrder(IBond.Order.SINGLE);
            }
        }
        orders[0] = bond.getOrder();
        stereos[0] = bond.getStereo();
        HashMap<IBond, IBond.Order[]> changedBonds = new HashMap<IBond, IBond.Order[]>();
        HashMap<IBond, IBond.Stereo[]> changedBondsStereo = new HashMap<IBond, IBond.Stereo[]>();
        changedBonds.put(bond, orders);
        changedBondsStereo.put(bond, stereos);
        this.updateAtom(bond.getAtom(0));
        this.updateAtom(bond.getAtom(1));
        this.structureChanged();
        if (this.undoredofactory != null && this.undoredohandler != null) {
            IUndoRedoable undoredo = this.undoredofactory.getAdjustBondOrdersEdit(changedBonds, changedBondsStereo, "Adjust Bond Order", this);
            this.undoredohandler.postEdit(undoredo);
        }
    }

    @Override
    public IBond makeNewStereoBond(IAtom atom, IChemModelRelay.Direction desiredDirection) {
        String atomType = this.getController2DModel().getDrawElement();
        IAtom newAtom = this.addAtomWithoutUndo(atomType, atom);
        IAtomContainer undoRedoContainer = (IAtomContainer)this.getIChemModel().getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer atomContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.getIChemModel(), (IAtom)newAtom);
        IBond newBond = atomContainer.getBond(atom, newAtom);
        if (desiredDirection == IChemModelRelay.Direction.UP) {
            newBond.setStereo(IBond.Stereo.UP);
        } else {
            newBond.setStereo(IBond.Stereo.DOWN);
        }
        undoRedoContainer.addAtom(newAtom);
        undoRedoContainer.addBond(newBond);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAddAtomsAndBondsEdit(this.getIChemModel(), undoRedoContainer, "Add Stereo Bond", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        return newBond;
    }

    @Override
    public void moveToWithoutUndo(IAtom atom, Point2d worldCoords) {
        if (atom != null) {
            Point2d atomCoord = new Point2d(worldCoords);
            atom.setPoint2d(atomCoord);
        }
        this.coordinatesChanged();
    }

    @Override
    public void moveTo(IAtom atom, Point2d worldCoords) {
        if (atom != null) {
            if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
                IAtomContainer undoRedoContainer = (IAtomContainer)this.chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                undoRedoContainer.addAtom(atom);
                Vector2d end = new Vector2d();
                end.sub(worldCoords, atom.getPoint2d());
                IUndoRedoable undoredo = this.getUndoRedoFactory().getMoveAtomEdit(undoRedoContainer, end, "Move atom");
                this.getUndoRedoHandler().postEdit(undoredo);
            }
            this.moveToWithoutUndo(atom, worldCoords);
        }
    }

    @Override
    public void moveToWithoutUndo(IBond bond, Point2d point) {
        if (bond != null) {
            Point2d center = bond.get2DCenter();
            for (IAtom atom : bond.atoms()) {
                Vector2d offset = new Vector2d();
                offset.sub(atom.getPoint2d(), center);
                Point2d result = new Point2d();
                result.add(point, offset);
                atom.setPoint2d(result);
            }
        }
        this.coordinatesChanged();
    }

    @Override
    public void moveTo(IBond bond, Point2d point) {
        if (bond != null) {
            if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
                IAtomContainer undoRedoContainer = (IAtomContainer)this.chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                undoRedoContainer.addAtom(bond.getAtom(0));
                undoRedoContainer.addAtom(bond.getAtom(1));
                Vector2d end = new Vector2d();
                end.sub(point, bond.getAtom(0).getPoint2d());
                IUndoRedoable undoredo = this.getUndoRedoFactory().getMoveAtomEdit(undoRedoContainer, end, "Move atom");
                this.getUndoRedoHandler().postEdit(undoredo);
            }
            this.moveToWithoutUndo(bond, point);
        }
    }

    @Override
    public IBond addBond(IAtom fromAtom, IAtom toAtom) {
        IBond newBond = (IBond)this.chemModel.getBuilder().newInstance(IBond.class, new Object[]{fromAtom, toAtom});
        this.chemModel.getMoleculeSet().getAtomContainer(0).addBond(newBond);
        this.updateAtom(newBond.getAtom(0));
        this.updateAtom(newBond.getAtom(1));
        this.structureChanged();
        return newBond;
    }

    @Override
    public void setCharge(IAtom atom, int charge) {
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getChangeChargeEdit(atom, atom.getFormalCharge(), charge, "Change charge to " + charge, this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        atom.setFormalCharge(Integer.valueOf(charge));
        this.updateAtom(atom);
        this.structurePropertiesChanged();
    }

    @Override
    public void setMassNumber(IAtom atom, int massNumber) {
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getChangeIsotopeEdit(atom, atom.getMassNumber(), massNumber, "Change Atomic Mass to " + massNumber);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        atom.setMassNumber(Integer.valueOf(massNumber));
        this.structurePropertiesChanged();
    }

    @Override
    public void setOrder(IBond bond, IBond.Order order) {
        HashMap<IBond, IBond.Order[]> changedBonds = new HashMap<IBond, IBond.Order[]>();
        changedBonds.put(bond, new IBond.Order[]{order, bond.getOrder()});
        bond.setOrder(order);
        this.updateAtom(bond.getAtom(0));
        this.updateAtom(bond.getAtom(1));
        this.structurePropertiesChanged();
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAdjustBondOrdersEdit(changedBonds, new HashMap<IBond, IBond.Stereo[]>(), "Changed Bond Order to " + order, this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
    }

    @Override
    public void setSymbol(IAtom atom, String symbol) {
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getChangeAtomSymbolEdit(atom, atom.getSymbol(), symbol, "Change Atom Symbol to " + symbol, this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        atom.setSymbol(symbol);
        try {
            IsotopeFactory.getInstance((IChemObjectBuilder)atom.getBuilder()).configure(atom);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateAtom(atom);
        this.structurePropertiesChanged();
    }

    @Override
    public void setWedgeType(IBond bond, IBond.Stereo type) {
        bond.setStereo(type);
        this.structurePropertiesChanged();
    }

    @Override
    public void updateImplicitHydrogenCounts() {
        HashMap<IAtom, Integer[]> atomHydrogenCountsMap = new HashMap<IAtom, Integer[]>();
        for (IAtomContainer container : ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel)) {
            for (IAtom atom : container.atoms()) {
                if (atom instanceof IPseudoAtom) continue;
                try {
                    IAtomType type = this.matcher.findMatchingAtomType(container, atom);
                    if (type == null || type.getFormalNeighbourCount() == null) continue;
                    int connectedAtomCount = container.getConnectedAtomsCount(atom);
                    atomHydrogenCountsMap.put(atom, new Integer[]{type.getFormalNeighbourCount() - connectedAtomCount, atom.getImplicitHydrogenCount()});
                    atom.setImplicitHydrogenCount(Integer.valueOf(type.getFormalNeighbourCount() - connectedAtomCount));
                }
                catch (CDKException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getChangeHydrogenCountEdit(atomHydrogenCountsMap, "Update implicit hydrogen count");
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        this.structurePropertiesChanged();
    }

    @Override
    public void zap() {
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getClearAllEdit(this.chemModel, this.chemModel.getMoleculeSet(), this.chemModel.getReactionSet(), "Clear Panel");
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        if (this.chemModel.getMoleculeSet() != null) {
            IMoleculeSet molSet = (IMoleculeSet)this.chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
            IMolecule ac = (IMolecule)this.chemModel.getBuilder().newInstance(IMolecule.class, new Object[0]);
            molSet.addMolecule(ac);
            this.chemModel.setMoleculeSet(molSet);
        }
        if (this.chemModel.getReactionSet() != null) {
            this.chemModel.setReactionSet((IReactionSet)this.chemModel.getBuilder().newInstance(IReactionSet.class, new Object[0]));
        }
        this.structureChanged();
    }

    @Override
    public void makeBondStereo(IBond bond, IChemModelRelay.Direction desiredDirection) {
        IBond.Stereo stereo = bond.getStereo();
        boolean isUp = this.isUp(stereo);
        boolean isDown = this.isDown(stereo);
        boolean noStereo = this.noStereo(stereo);
        if (isUp && desiredDirection == IChemModelRelay.Direction.UP) {
            this.flipDirection(bond, stereo);
        } else if (isDown && desiredDirection == IChemModelRelay.Direction.UP) {
            this.flipOrientation(bond, stereo);
        } else if (isUp && desiredDirection == IChemModelRelay.Direction.DOWN) {
            this.flipOrientation(bond, stereo);
        } else if (isDown && desiredDirection == IChemModelRelay.Direction.DOWN) {
            this.flipDirection(bond, stereo);
        } else if (noStereo && desiredDirection == IChemModelRelay.Direction.UP) {
            bond.setStereo(IBond.Stereo.UP);
        } else if (noStereo && desiredDirection == IChemModelRelay.Direction.DOWN) {
            bond.setStereo(IBond.Stereo.DOWN);
        }
        IBond.Stereo[] stereos = new IBond.Stereo[2];
        stereos[1] = stereo;
        stereos[0] = bond.getStereo();
        HashMap<IBond, IBond.Order[]> changedBonds = new HashMap<IBond, IBond.Order[]>();
        HashMap<IBond, IBond.Stereo[]> changedBondsStereo = new HashMap<IBond, IBond.Stereo[]>();
        changedBondsStereo.put(bond, stereos);
        this.updateAtom(bond.getAtom(0));
        this.updateAtom(bond.getAtom(1));
        this.structureChanged();
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAdjustBondOrdersEdit(changedBonds, changedBondsStereo, "Adjust Bond Stereo", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
    }

    private void flipDirection(IBond bond, IBond.Stereo stereo) {
        if (stereo == IBond.Stereo.UP) {
            bond.setStereo(IBond.Stereo.UP_INVERTED);
        } else if (stereo == IBond.Stereo.UP_INVERTED) {
            bond.setStereo(IBond.Stereo.UP);
        } else if (stereo == IBond.Stereo.DOWN_INVERTED) {
            bond.setStereo(IBond.Stereo.DOWN);
        } else if (stereo == IBond.Stereo.DOWN) {
            bond.setStereo(IBond.Stereo.DOWN_INVERTED);
        }
    }

    private void flipOrientation(IBond bond, IBond.Stereo stereo) {
        if (stereo == IBond.Stereo.UP) {
            bond.setStereo(IBond.Stereo.DOWN_INVERTED);
        } else if (stereo == IBond.Stereo.UP_INVERTED) {
            bond.setStereo(IBond.Stereo.DOWN);
        } else if (stereo == IBond.Stereo.DOWN_INVERTED) {
            bond.setStereo(IBond.Stereo.UP);
        } else if (stereo == IBond.Stereo.DOWN) {
            bond.setStereo(IBond.Stereo.UP_INVERTED);
        }
    }

    private boolean isUp(IBond.Stereo stereo) {
        return stereo == IBond.Stereo.UP || stereo == IBond.Stereo.UP_INVERTED;
    }

    private boolean isDown(IBond.Stereo stereo) {
        return stereo == IBond.Stereo.DOWN || stereo == IBond.Stereo.DOWN_INVERTED;
    }

    private boolean noStereo(IBond.Stereo stereo) {
        return stereo == IBond.Stereo.NONE || stereo == CDKConstants.UNSET;
    }

    public static void avoidOverlap(IChemModel chemModel) {
        Rectangle2D usedReactionbounds = null;
        if (chemModel.getReactionSet() != null) {
            for (IReaction reaction : chemModel.getReactionSet().reactions()) {
                Rectangle2D reactionbounds = BoundsCalculator.calculateBounds(reaction);
                if (usedReactionbounds != null) {
                    double bondLength = GeometryTools.getBondLengthAverage((IReaction)reaction);
                    Rectangle2D shiftedBounds = GeometryTools.shiftReactionVertical((IReaction)reaction, (Rectangle2D)reactionbounds, (Rectangle2D)usedReactionbounds, (double)bondLength);
                    usedReactionbounds = usedReactionbounds.createUnion(shiftedBounds);
                    continue;
                }
                usedReactionbounds = reactionbounds;
            }
        }
        Rectangle2D usedBounds = null;
        if (chemModel.getMoleculeSet() != null) {
            for (IAtomContainer container : AtomContainerSetManipulator.getAllAtomContainers((IAtomContainerSet)chemModel.getMoleculeSet())) {
                Rectangle2D bounds = BoundsCalculator.calculateBounds(container);
                if (usedBounds != null) {
                    double bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)container);
                    Rectangle2D shiftedBounds = GeometryTools.shiftContainer((IAtomContainer)container, (Rectangle2D)bounds, (Rectangle2D)usedBounds, (double)bondLength);
                    usedBounds = usedBounds.createUnion(shiftedBounds);
                    continue;
                }
                usedBounds = bounds;
            }
        }
        if (chemModel.getReactionSet() != null) {
            for (IReaction reaction : chemModel.getReactionSet().reactions()) {
                usedBounds = null;
                for (IAtomContainer container : ReactionManipulator.getAllAtomContainers((IReaction)reaction)) {
                    Rectangle2D bounds = BoundsCalculator.calculateBounds(container);
                    if (usedBounds != null) {
                        double bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)container);
                        Rectangle2D shiftedBounds = GeometryTools.shiftContainer((IAtomContainer)container, (Rectangle2D)bounds, (Rectangle2D)usedBounds, (double)bondLength);
                        usedBounds = usedBounds.createUnion(shiftedBounds);
                        continue;
                    }
                    usedBounds = bounds;
                }
            }
        }
    }

    @Override
    public void cleanup() {
        Point2d[] coordsforatom;
        HashMap<IAtom, Point2d[]> coords = new HashMap<IAtom, Point2d[]>();
        if (this.chemModel.getMoleculeSet() == null || this.chemModel.getMoleculeSet().getAtomContainerCount() == 0) {
            return;
        }
        IAtomContainer container = this.chemModel.getMoleculeSet().getAtomContainer(0);
        for (IAtom atom : container.atoms()) {
            coordsforatom = new Point2d[2];
            coordsforatom[1] = atom.getPoint2d();
            coords.put(atom, coordsforatom);
            atom.setPoint2d(null);
        }
        if (ConnectivityChecker.isConnected((IAtomContainer)container)) {
            ControllerHub.generateNewCoordinates(container);
        } else {
            IMoleculeSet molecules = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)container);
            for (IAtomContainer subContainer : molecules.molecules()) {
                ControllerHub.generateNewCoordinates(subContainer);
            }
            Rectangle2D usedBounds = null;
            for (IAtomContainer subContainer : molecules.molecules()) {
                Rectangle2D bounds = BoundsCalculator.calculateBounds(subContainer);
                if (usedBounds != null) {
                    double bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)subContainer);
                    Rectangle2D shiftedBounds = GeometryTools.shiftContainer((IAtomContainer)subContainer, (Rectangle2D)bounds, (Rectangle2D)usedBounds, (double)bondLength);
                    usedBounds = usedBounds.createUnion(shiftedBounds);
                    continue;
                }
                usedBounds = bounds;
            }
        }
        for (IAtom atom : container.atoms()) {
            coordsforatom = (Point2d[])coords.get(atom);
            coordsforatom[0] = atom.getPoint2d();
        }
        this.coordinatesChanged();
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getChangeCoordsEdit(coords, "Clean Up");
            this.getUndoRedoHandler().postEdit(undoredo);
        }
    }

    public static void generateNewCoordinates(IAtomContainer container) {
        IChemObjectBuilder builder = NoNotificationChemObjectBuilder.getInstance();
        if (diagramGenerator == null) {
            diagramGenerator = new StructureDiagramGenerator();
            diagramGenerator.setTemplateHandler(new TemplateHandler(builder));
        }
        if (container instanceof IMolecule) {
            diagramGenerator.setMolecule((IMolecule)container);
        } else {
            diagramGenerator.setMolecule((IMolecule)builder.newInstance(IMolecule.class, new Object[]{container}));
        }
        try {
            diagramGenerator.generateExperimentalCoordinates();
            IMolecule cleanedMol = diagramGenerator.getMolecule();
            for (int i = 0; i < cleanedMol.getAtomCount(); ++i) {
                container.getAtom(i).setPoint2d(cleanedMol.getAtom(i).getPoint2d());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IRing addRing(int ringSize, Point2d worldcoord) {
        IMolecule container;
        IRing ring = (IRing)this.chemModel.getBuilder().newInstance(IRing.class, new Object[]{ringSize, "C"});
        double bondLength = 1.4;
        ringPlacer.placeRing(ring, worldcoord, bondLength);
        IMoleculeSet set = this.chemModel.getMoleculeSet();
        if (set == null) {
            set = (IMoleculeSet)this.chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
            this.chemModel.setMoleculeSet(set);
        }
        if ((container = set.getMolecule(0)) == null) {
            container = (IMolecule)set.getBuilder().newInstance(IMolecule.class, new Object[0]);
            set.addAtomContainer((IAtomContainer)container);
        }
        container.add((IAtomContainer)ring);
        this.updateAtoms((IAtomContainer)ring, ring.atoms());
        this.structureChanged();
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAddAtomsAndBondsEdit(this.getIChemModel(), (IAtomContainer)ring.getBuilder().newInstance(IAtomContainer.class, new Object[]{ring}), "Ring " + ringSize, this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        return ring;
    }

    @Override
    public IRing addPhenyl(Point2d worldcoord) {
        IMolecule container;
        IRing ring = (IRing)this.chemModel.getBuilder().newInstance(IRing.class, new Object[]{6, "C"});
        ring.getBond(0).setOrder(IBond.Order.DOUBLE);
        ring.getBond(2).setOrder(IBond.Order.DOUBLE);
        ring.getBond(4).setOrder(IBond.Order.DOUBLE);
        this.makeRingAromatic(ring);
        double bondLength = 1.4;
        ringPlacer.placeRing(ring, worldcoord, bondLength);
        IMoleculeSet set = this.chemModel.getMoleculeSet();
        if (set == null) {
            set = (IMoleculeSet)this.chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
            this.chemModel.setMoleculeSet(set);
        }
        if ((container = set.getMolecule(0)) == null) {
            container = (IMolecule)set.getBuilder().newInstance(IMolecule.class, new Object[0]);
            set.addAtomContainer((IAtomContainer)container);
        }
        container.add((IAtomContainer)ring);
        this.updateAtoms((IAtomContainer)ring, ring.atoms());
        this.structureChanged();
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAddAtomsAndBondsEdit(this.getIChemModel(), (IAtomContainer)ring.getBuilder().newInstance(IAtomContainer.class, new Object[]{ring}), "Benzene", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        return ring;
    }

    @Override
    public IRing addRing(IAtom atom, int ringSize) {
        IAtomContainer sourceContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)atom);
        IAtomContainer sharedAtoms = (IAtomContainer)atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        sharedAtoms.addAtom(atom);
        IRing newRing = this.createAttachRing(sharedAtoms, ringSize, "C");
        double bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)sourceContainer);
        Point2d conAtomsCenter = this.getConnectedAtomsCenter(sharedAtoms, this.chemModel);
        Point2d sharedAtomsCenter = atom.getPoint2d();
        Vector2d ringCenterVector = new Vector2d(sharedAtomsCenter);
        ringCenterVector.sub(conAtomsCenter);
        ringPlacer.placeSpiroRing(newRing, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        for (IAtom ringAtom : newRing.atoms()) {
            if (ringAtom == atom) continue;
            sourceContainer.addAtom(ringAtom);
        }
        for (IBond ringBond : newRing.bonds()) {
            sourceContainer.addBond(ringBond);
        }
        this.updateAtoms((IAtomContainer)newRing, newRing.atoms());
        RendererModel rModel = this.getRenderer().getRenderer2DModel();
        double d = (Double)rModel.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)rModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        for (IAtom newatom : newRing.atoms()) {
            if (atom == newatom || this.getClosestAtom(atom) == null) continue;
            atom.getPoint2d().x += d;
        }
        this.structureChanged();
        return newRing;
    }

    @Override
    public IRing addPhenyl(IAtom atom) {
        double bondLength;
        IAtomContainer sourceContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)atom);
        IAtomContainer sharedAtoms = (IAtomContainer)atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        sharedAtoms.addAtom(atom);
        IRing newRing = this.createAttachRing(sharedAtoms, 6, "C");
        newRing.getBond(0).setOrder(IBond.Order.DOUBLE);
        newRing.getBond(2).setOrder(IBond.Order.DOUBLE);
        newRing.getBond(4).setOrder(IBond.Order.DOUBLE);
        this.makeRingAromatic(newRing);
        if (sourceContainer.getBondCount() == 0) {
            bondLength = 1.4;
            Point2d ringCenter = new Point2d(atom.getPoint2d());
            ringPlacer.placeRing(newRing, ringCenter, bondLength);
        } else {
            bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)sourceContainer);
            Point2d conAtomsCenter = this.getConnectedAtomsCenter(sharedAtoms, this.chemModel);
            Point2d sharedAtomsCenter = atom.getPoint2d();
            Vector2d ringCenterVector = new Vector2d(sharedAtomsCenter);
            ringCenterVector.sub(conAtomsCenter);
            ringPlacer.placeSpiroRing(newRing, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        }
        for (IAtom ringAtom : newRing.atoms()) {
            if (ringAtom == atom) continue;
            sourceContainer.addAtom(ringAtom);
        }
        for (IBond ringBond : newRing.bonds()) {
            sourceContainer.addBond(ringBond);
        }
        this.updateAtoms((IAtomContainer)newRing, newRing.atoms());
        for (IAtom newatom : newRing.atoms()) {
            if (atom == newatom || this.getClosestAtom(atom) == null) continue;
            RendererModel rModel = this.getRenderer().getRenderer2DModel();
            double d = (Double)rModel.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)rModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
            atom.getPoint2d().x += d;
        }
        this.structureChanged();
        return newRing;
    }

    private void makeRingAromatic(IRing newRing) {
        for (IAtom atom : newRing.atoms()) {
            atom.setFlag(5, true);
        }
        for (IBond bond : newRing.bonds()) {
            bond.setFlag(5, true);
        }
    }

    private IRing createAttachRing(IAtomContainer sharedAtoms, int ringSize, String symbol) {
        int i;
        IRing newRing = (IRing)sharedAtoms.getBuilder().newInstance(IRing.class, new Object[]{ringSize});
        IAtom[] ringAtoms = new IAtom[ringSize];
        for (i = 0; i < sharedAtoms.getAtomCount(); ++i) {
            ringAtoms[i] = sharedAtoms.getAtom(i);
        }
        for (i = sharedAtoms.getAtomCount(); i < ringSize; ++i) {
            ringAtoms[i] = (IAtom)sharedAtoms.getBuilder().newInstance(IAtom.class, new Object[]{symbol});
        }
        for (IBond bond : sharedAtoms.bonds()) {
            newRing.addBond(bond);
        }
        for (int i2 = sharedAtoms.getBondCount(); i2 < ringSize - 1; ++i2) {
            newRing.addBond((IBond)sharedAtoms.getBuilder().newInstance(IBond.class, new Object[]{ringAtoms[i2], ringAtoms[i2 + 1], IBond.Order.SINGLE}));
        }
        newRing.addBond((IBond)sharedAtoms.getBuilder().newInstance(IBond.class, new Object[]{ringAtoms[ringSize - 1], ringAtoms[0], IBond.Order.SINGLE}));
        newRing.setAtoms(ringAtoms);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IAtomContainer undoRedoContainer = (IAtomContainer)newRing.getBuilder().newInstance(IAtomContainer.class, new Object[]{newRing});
            for (IAtom atom : sharedAtoms.atoms()) {
                undoRedoContainer.removeAtom(atom);
            }
            for (IBond bond : sharedAtoms.bonds()) {
                undoRedoContainer.removeBond(bond);
            }
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAddAtomsAndBondsEdit(this.getIChemModel(), undoRedoContainer, "Ring " + ringSize, this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        return newRing;
    }

    private Point2d getConnectedAtomsCenter(IAtomContainer sharedAtoms, IChemModel chemModel) {
        IAtomContainer conAtoms = (IAtomContainer)sharedAtoms.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtom sharedAtom : sharedAtoms.atoms()) {
            conAtoms.addAtom(sharedAtom);
            IAtomContainer atomCon = ChemModelManipulator.getRelevantAtomContainer((IChemModel)chemModel, (IAtom)sharedAtom);
            for (IAtom atom : atomCon.getConnectedAtomsList(sharedAtom)) {
                conAtoms.addAtom(atom);
            }
        }
        return GeometryTools.get2DCenter((IAtomContainer)conAtoms);
    }

    @Override
    public IRing addRing(IBond bond, int size) {
        IAtomContainer sharedAtoms = (IAtomContainer)bond.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom firstAtom = bond.getAtom(0);
        IAtom secondAtom = bond.getAtom(1);
        sharedAtoms.addAtom(firstAtom);
        sharedAtoms.addAtom(secondAtom);
        sharedAtoms.addBond(bond);
        IAtomContainer sourceContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)firstAtom);
        Point2d sharedAtomsCenter = GeometryTools.get2DCenter((IAtomContainer)sharedAtoms);
        Point2d firstPoint = firstAtom.getPoint2d();
        Point2d secondPoint = secondAtom.getPoint2d();
        Vector2d diff = new Vector2d(secondPoint);
        diff.sub(firstPoint);
        double bondLength = firstPoint.distance(secondPoint);
        double angle = GeometryTools.getAngle((double)diff.x, (double)diff.y);
        Point2d newPoint1 = new Point2d(Math.cos(angle + 1.5707963267948966) * bondLength / 4.0 + sharedAtomsCenter.x, Math.sin(angle + 1.5707963267948966) * bondLength / 4.0 + sharedAtomsCenter.y);
        Point2d newPoint2 = new Point2d(Math.cos(angle - 1.5707963267948966) * bondLength / 4.0 + sharedAtomsCenter.x, Math.sin(angle - 1.5707963267948966) * bondLength / 4.0 + sharedAtomsCenter.y);
        IAtomContainer connectedAtoms = (IAtomContainer)bond.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtom atom : sourceContainer.getConnectedAtomsList(firstAtom)) {
            if (atom == secondAtom) continue;
            connectedAtoms.addAtom(atom);
        }
        for (IAtom atom : sourceContainer.getConnectedAtomsList(secondAtom)) {
            if (atom == firstAtom) continue;
            connectedAtoms.addAtom(atom);
        }
        Point2d conAtomsCenter = GeometryTools.get2DCenter((IAtomContainer)connectedAtoms);
        double distance1 = newPoint1.distance(conAtomsCenter);
        double distance2 = newPoint2.distance(conAtomsCenter);
        Vector2d ringCenterVector = new Vector2d(sharedAtomsCenter);
        if (distance1 < distance2) {
            ringCenterVector.sub(newPoint1);
        } else {
            ringCenterVector.sub(newPoint2);
        }
        IRing newRing = this.createAttachRing(sharedAtoms, size, "C");
        ringPlacer.placeFusedRing(newRing, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        for (IAtom ringAtom : newRing.atoms()) {
            if (ringAtom == firstAtom || ringAtom == secondAtom) continue;
            sourceContainer.addAtom(ringAtom);
        }
        for (IBond ringBond : newRing.bonds()) {
            if (ringBond == bond) continue;
            sourceContainer.addBond(ringBond);
        }
        this.updateAtoms((IAtomContainer)newRing, newRing.atoms());
        RendererModel rModel = this.getRenderer().getRenderer2DModel();
        double d = (Double)rModel.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)rModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        for (IAtom atom : newRing.atoms()) {
            if (atom == firstAtom || atom == secondAtom || this.getClosestAtom(atom) == null) continue;
            atom.getPoint2d().x += d;
        }
        this.structureChanged();
        return newRing;
    }

    @Override
    public IAtom getClosestAtom(IAtom atom) {
        return this.getAtomInRange(null, atom);
    }

    @Override
    public IAtom getAtomInRange(Collection<IAtom> toIgnore, IAtom atom) {
        Point2d atomPosition = atom.getPoint2d();
        RendererModel rModel = this.getRenderer().getRenderer2DModel();
        double highlight = (Double)rModel.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)rModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        IAtom bestClosestAtom = null;
        double bestDistance = -1.0;
        for (IAtomContainer atomContainer : ChemModelManipulator.getAllAtomContainers((IChemModel)this.getIChemModel())) {
            double distance;
            IAtom closestAtom = GeometryTools.getClosestAtom((IAtomContainer)atomContainer, (IAtom)atom);
            if (closestAtom == null || (distance = closestAtom.getPoint2d().distance(atomPosition)) > highlight || toIgnore != null && toIgnore.contains(closestAtom) || bestClosestAtom != null && !(distance < bestDistance)) continue;
            bestClosestAtom = closestAtom;
            bestDistance = distance;
        }
        return bestClosestAtom;
    }

    @Override
    public IRing addPhenyl(IBond bond) {
        IAtomContainer sharedAtoms = (IAtomContainer)bond.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtom firstAtom = bond.getAtom(0);
        IAtom secondAtom = bond.getAtom(1);
        sharedAtoms.addAtom(firstAtom);
        sharedAtoms.addAtom(secondAtom);
        sharedAtoms.addBond(bond);
        IAtomContainer sourceContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)firstAtom);
        Point2d sharedAtomsCenter = GeometryTools.get2DCenter((IAtomContainer)sharedAtoms);
        Point2d firstPoint = firstAtom.getPoint2d();
        Point2d secondPoint = secondAtom.getPoint2d();
        Vector2d diff = new Vector2d(secondPoint);
        diff.sub(firstPoint);
        double bondLength = firstPoint.distance(secondPoint);
        double angle = GeometryTools.getAngle((double)diff.x, (double)diff.y);
        Point2d newPoint1 = new Point2d(Math.cos(angle + 1.5707963267948966) * bondLength / 4.0 + sharedAtomsCenter.x, Math.sin(angle + 1.5707963267948966) * bondLength / 4.0 + sharedAtomsCenter.y);
        Point2d newPoint2 = new Point2d(Math.cos(angle - 1.5707963267948966) * bondLength / 4.0 + sharedAtomsCenter.x, Math.sin(angle - 1.5707963267948966) * bondLength / 4.0 + sharedAtomsCenter.y);
        IAtomContainer connectedAtoms = (IAtomContainer)bond.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtom atom : sourceContainer.getConnectedAtomsList(firstAtom)) {
            if (atom == secondAtom) continue;
            connectedAtoms.addAtom(atom);
        }
        for (IAtom atom : sourceContainer.getConnectedAtomsList(secondAtom)) {
            if (atom == firstAtom) continue;
            connectedAtoms.addAtom(atom);
        }
        Point2d conAtomsCenter = GeometryTools.get2DCenter((IAtomContainer)connectedAtoms);
        double distance1 = newPoint1.distance(conAtomsCenter);
        double distance2 = newPoint2.distance(conAtomsCenter);
        Vector2d ringCenterVector = new Vector2d(sharedAtomsCenter);
        if (distance1 < distance2) {
            ringCenterVector.sub(newPoint1);
        } else {
            ringCenterVector.sub(newPoint2);
        }
        IRing newRing = this.createAttachRing(sharedAtoms, 6, "C");
        this.makeRingAromatic(newRing);
        ringPlacer.placeFusedRing(newRing, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        if (sourceContainer.getMaximumBondOrder(bond.getAtom(0)) == IBond.Order.SINGLE && sourceContainer.getMaximumBondOrder(bond.getAtom(1)) == IBond.Order.SINGLE) {
            newRing.getBond(1).setOrder(IBond.Order.DOUBLE);
            newRing.getBond(3).setOrder(IBond.Order.DOUBLE);
            newRing.getBond(5).setOrder(IBond.Order.DOUBLE);
        } else {
            newRing.getBond(2).setOrder(IBond.Order.DOUBLE);
            newRing.getBond(4).setOrder(IBond.Order.DOUBLE);
        }
        for (IAtom ringAtom : newRing.atoms()) {
            if (ringAtom == firstAtom || ringAtom == secondAtom) continue;
            sourceContainer.addAtom(ringAtom);
        }
        for (IBond ringBond : newRing.bonds()) {
            if (ringBond == bond) continue;
            sourceContainer.addBond(ringBond);
        }
        this.updateAtoms((IAtomContainer)newRing, newRing.atoms());
        RendererModel rModel = this.getRenderer().getRenderer2DModel();
        double d = (Double)rModel.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)rModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        for (IAtom atom : newRing.atoms()) {
            if (atom == firstAtom || atom == secondAtom || this.getClosestAtom(atom) == null) continue;
            atom.getPoint2d().x += d;
        }
        this.structureChanged();
        return newRing;
    }

    @Override
    public void removeBondWithoutUndo(IBond bond) {
        IAtomContainer sourceContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IBond)bond);
        if (sourceContainer != null) {
            sourceContainer.removeBond(bond);
        }
        this.updateAtom(bond.getAtom(0));
        this.updateAtom(bond.getAtom(1));
        this.structureChanged();
    }

    @Override
    public void removeBond(IBond bond) {
        this.removeBondWithoutUndo(bond);
        IAtomContainer undAtomContainer = (IAtomContainer)bond.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        undAtomContainer.addBond(bond);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getRemoveAtomsAndBondsEdit(this.getIChemModel(), undAtomContainer, "Remove Bond", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
    }

    @Override
    public void addPhantomAtom(IAtom atom) {
        this.phantoms.addAtom(atom);
    }

    @Override
    public void addPhantomBond(IBond bond) {
        this.phantoms.addBond(bond);
    }

    @Override
    public void clearPhantoms() {
        this.phantoms.removeAllElements();
    }

    @Override
    public IAtomContainer getPhantoms() {
        return this.phantoms;
    }

    @Override
    public void adjustBondOrders() throws IOException, ClassNotFoundException, CDKException {
        SaturationChecker satChecker = new SaturationChecker();
        List containersList = ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel);
        Iterator iterator = containersList.iterator();
        HashMap<IBond, IBond.Order[]> changedBonds = new HashMap<IBond, IBond.Order[]>();
        while (iterator.hasNext()) {
            IBond.Order[] orders;
            IAtomContainer ac = (IAtomContainer)iterator.next();
            for (IBond bond : ac.bonds()) {
                orders = new IBond.Order[2];
                orders[1] = bond.getOrder();
                changedBonds.put(bond, orders);
            }
            satChecker.saturate(ac);
            for (IBond bond : ac.bonds()) {
                orders = (IBond.Order[])changedBonds.get(bond);
                orders[0] = bond.getOrder();
                changedBonds.put(bond, orders);
            }
        }
        if (this.getController2DModel().getAutoUpdateImplicitHydrogens()) {
            this.updateImplicitHydrogenCounts();
        }
        if (this.undoredofactory != null && this.undoredohandler != null) {
            IUndoRedoable undoredo = this.undoredofactory.getAdjustBondOrdersEdit(changedBonds, new HashMap<IBond, IBond.Stereo[]>(), "Adjust Bond Order of Molecules", this);
            this.undoredohandler.postEdit(undoredo);
        }
    }

    @Override
    public void resetBondOrders() {
        List containersList = ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel);
        Iterator iterator = containersList.iterator();
        HashMap<IBond, IBond.Order[]> changedBonds = new HashMap<IBond, IBond.Order[]>();
        while (iterator.hasNext()) {
            IAtomContainer ac = (IAtomContainer)iterator.next();
            for (IBond bond : ac.bonds()) {
                IBond.Order[] orders = new IBond.Order[2];
                orders[1] = bond.getOrder();
                orders[0] = IBond.Order.SINGLE;
                changedBonds.put(bond, orders);
                bond.setOrder(IBond.Order.SINGLE);
            }
        }
        if (this.getController2DModel().getAutoUpdateImplicitHydrogens()) {
            this.updateImplicitHydrogenCounts();
        }
        if (this.undoredofactory != null && this.undoredohandler != null) {
            IUndoRedoable undoredo = this.undoredofactory.getAdjustBondOrdersEdit(changedBonds, new HashMap<IBond, IBond.Stereo[]>(), "Reset Bond Order of Molecules", this);
            this.undoredohandler.postEdit(undoredo);
        }
    }

    @Override
    public void replaceAtom(IAtom atomnew, IAtom atomold) {
        IAtomContainer relevantContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)atomold);
        AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)relevantContainer, (IAtom)atomold, (IAtom)atomnew);
        this.updateAtom(atomnew);
        this.structureChanged();
        if (this.undoredofactory != null && this.undoredohandler != null) {
            IUndoRedoable undoredo = this.undoredofactory.getReplaceAtomEdit(this.chemModel, atomold, atomnew, "Replace Atom");
            this.undoredohandler.postEdit(undoredo);
        }
    }

    @Override
    public void addSingleElectron(IAtom atom) {
        IAtomContainer relevantContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)atom);
        ISingleElectron singleElectron = (ISingleElectron)atom.getBuilder().newInstance(ISingleElectron.class, new Object[]{atom});
        relevantContainer.addSingleElectron(singleElectron);
        if (this.undoredofactory != null && this.undoredohandler != null) {
            IUndoRedoable undoredo = this.undoredofactory.getConvertToRadicalEdit(relevantContainer, (IElectronContainer)singleElectron, "Convert to Radical");
            this.undoredohandler.postEdit(undoredo);
        }
    }

    @Override
    public void clearValidation() {
        for (IAtomContainer atoms : ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel)) {
            for (int i = 0; i < atoms.getAtomCount(); ++i) {
                ProblemMarker.unmark((IChemObject)atoms.getAtom(i));
            }
        }
    }

    @Override
    public void flip(boolean horizontal) {
        IAtomContainer toflip;
        HashMap<IAtom, Point2d[]> atomCoordsMap = new HashMap<IAtom, Point2d[]>();
        RendererModel renderModel = this.renderer.getRenderer2DModel();
        if (renderModel.getSelection().getConnectedAtomContainer() != null) {
            toflip = renderModel.getSelection().getConnectedAtomContainer();
        } else {
            List toflipall = ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel);
            toflip = (IAtomContainer)((IAtomContainer)toflipall.get(0)).getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            for (IAtomContainer atomContainer : toflipall) {
                toflip.add(atomContainer);
            }
        }
        Point2d center = GeometryTools.get2DCenter((IAtomContainer)toflip);
        for (int i = 0; i < toflip.getAtomCount(); ++i) {
            IAtom atom = toflip.getAtom(i);
            Point2d p2d = atom.getPoint2d();
            Point2d oldCoord = new Point2d(p2d.x, p2d.y);
            if (horizontal) {
                p2d.y = 2.0 * center.y - p2d.y;
            } else {
                p2d.x = 2.0 * center.x - p2d.x;
            }
            Point2d newCoord = p2d;
            if (oldCoord.equals(newCoord)) continue;
            Point2d[] coords = new Point2d[]{newCoord, oldCoord};
            atomCoordsMap.put(atom, coords);
        }
        this.coordinatesChanged();
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getChangeCoordsEdit(atomCoordsMap, "Clean Up");
            this.getUndoRedoHandler().postEdit(undoredo);
        }
    }

    @Override
    public void setEventHandler(IChemModelEventRelayHandler handler) {
        this.changeHandler = handler;
    }

    private void structureChanged() {
        if (this.renderer.getRenderer2DModel().getSelection() instanceof IncrementalSelection) {
            this.select((IncrementalSelection)this.renderer.getRenderer2DModel().getSelection());
        }
        if (this.changeHandler != null) {
            this.changeHandler.structureChanged();
        }
    }

    @Override
    public void fireZoomEvent() {
        this.changeHandler.zoomChanged();
    }

    @Override
    public void fireStructureChangedEvent() {
        this.changeHandler.structureChanged();
    }

    private void structurePropertiesChanged() {
        if (this.changeHandler != null) {
            this.changeHandler.structurePropertiesChanged();
        }
    }

    private void coordinatesChanged() {
        if (this.changeHandler != null) {
            this.changeHandler.coordinatesChanged();
        }
    }

    @Override
    public IUndoRedoFactory getUndoRedoFactory() {
        return this.undoredofactory;
    }

    @Override
    public UndoRedoHandler getUndoRedoHandler() {
        return this.undoredohandler;
    }

    private void selectionChanged() {
        if (this.changeHandler != null) {
            this.changeHandler.selectionChanged();
        }
    }

    @Override
    public void select(IChemObjectSelection selection) {
        if (selection != null) {
            selection.select(this.chemModel);
        }
        this.selectionChanged();
    }

    @Override
    public void addFragment(IAtomContainer toPaste) {
        IMoleculeSet moleculeSet = this.chemModel.getMoleculeSet();
        if (moleculeSet == null) {
            moleculeSet = (IMoleculeSet)this.chemModel.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        }
        moleculeSet.addAtomContainer(toPaste);
        if (this.undoredofactory != null && this.undoredohandler != null) {
            IUndoRedoable undoredo = this.undoredofactory.getAddAtomsAndBondsEdit(this.getIChemModel(), (IAtomContainer)toPaste.getBuilder().newInstance(IAtomContainer.class, new Object[]{toPaste}), "Paste", this);
            this.undoredohandler.postEdit(undoredo);
        }
        this.updateAtoms(toPaste, toPaste.atoms());
        this.structureChanged();
    }

    @Override
    public IAtomContainer deleteFragment(IAtomContainer selected) {
        IAtomContainer removed = (IAtomContainer)selected.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int i = 0; i < selected.getAtomCount(); ++i) {
            removed.addAtom(selected.getAtom(i));
            for (IBond bond : ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)selected.getAtom(i)).getConnectedBondsList(selected.getAtom(i))) {
                if (removed.contains(bond)) continue;
                removed.addBond(bond);
            }
            ChemModelManipulator.removeAtomAndConnectedElectronContainers((IChemModel)this.chemModel, (IAtom)selected.getAtom(i));
        }
        if (this.undoredofactory != null && this.undoredohandler != null) {
            IUndoRedoable undoredo = this.undoredofactory.getRemoveAtomsAndBondsEdit(this.chemModel, removed, "Cut", this);
            this.undoredohandler.postEdit(undoredo);
        }
        this.structureChanged();
        return removed;
    }

    @Override
    public void makeReactantInNewReaction(IAtomContainer newContainer, IAtomContainer oldcontainer) {
        IReaction reaction = (IReaction)newContainer.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.setID("reaction-" + System.currentTimeMillis());
        IMolecule mol = (IMolecule)newContainer.getBuilder().newInstance(IMolecule.class, new Object[]{newContainer});
        mol.setID(newContainer.getID());
        reaction.addReactant(mol);
        IReactionSet reactionSet = this.chemModel.getReactionSet();
        if (reactionSet == null) {
            reactionSet = (IReactionSet)this.chemModel.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        }
        reactionSet.addReaction(reaction);
        this.chemModel.setReactionSet(reactionSet);
        this.chemModel.getMoleculeSet().removeAtomContainer(oldcontainer);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getMakeReactantOrProductInNewReactionEdit(this.chemModel, newContainer, oldcontainer, true, "Make Reactant in new Reaction");
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        this.structureChanged();
    }

    @Override
    public void makeReactantInExistingReaction(String reactionId, IAtomContainer newContainer, IAtomContainer oldcontainer) {
        IReaction reaction = ReactionSetManipulator.getReactionByReactionID((IReactionSet)this.chemModel.getReactionSet(), (String)reactionId);
        IMolecule mol = (IMolecule)newContainer.getBuilder().newInstance(IMolecule.class, new Object[]{newContainer});
        mol.setID(newContainer.getID());
        reaction.addReactant(mol);
        this.chemModel.getMoleculeSet().removeAtomContainer(oldcontainer);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getMakeReactantOrProductInExistingReactionEdit(this.chemModel, newContainer, oldcontainer, reactionId, true, "Make Reactant in " + reactionId);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        this.structureChanged();
    }

    @Override
    public void makeProductInNewReaction(IAtomContainer newContainer, IAtomContainer oldcontainer) {
        IReaction reaction = (IReaction)newContainer.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.setID("reaction-" + System.currentTimeMillis());
        IMolecule mol = (IMolecule)newContainer.getBuilder().newInstance(IMolecule.class, new Object[]{newContainer});
        mol.setID(newContainer.getID());
        reaction.addProduct(mol);
        IReactionSet reactionSet = this.chemModel.getReactionSet();
        if (reactionSet == null) {
            reactionSet = (IReactionSet)this.chemModel.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        }
        reactionSet.addReaction(reaction);
        this.chemModel.setReactionSet(reactionSet);
        this.chemModel.getMoleculeSet().removeAtomContainer(oldcontainer);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getMakeReactantOrProductInNewReactionEdit(this.chemModel, newContainer, oldcontainer, false, "Make Reactant in new Reaction");
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        this.structureChanged();
    }

    @Override
    public void makeProductInExistingReaction(String reactionId, IAtomContainer newContainer, IAtomContainer oldcontainer) {
        IReaction reaction = ReactionSetManipulator.getReactionByReactionID((IReactionSet)this.chemModel.getReactionSet(), (String)reactionId);
        IMolecule mol = (IMolecule)newContainer.getBuilder().newInstance(IMolecule.class, new Object[]{newContainer});
        mol.setID(newContainer.getID());
        reaction.addProduct(mol);
        this.chemModel.getMoleculeSet().removeAtomContainer(oldcontainer);
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getMakeReactantOrProductInExistingReactionEdit(this.chemModel, newContainer, oldcontainer, reactionId, false, "Make Reactant in " + reactionId);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        this.structureChanged();
    }

    @Override
    public void updateAtoms(IAtomContainer container, Iterable<IAtom> atoms) {
        for (IAtom atom : atoms) {
            this.updateAtom(container, atom);
        }
    }

    @Override
    public void updateAtom(IAtom atom) {
        IAtomContainer container = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)atom);
        if (container != null) {
            this.updateAtom(container, atom);
        }
    }

    private void updateAtom(IAtomContainer container, IAtom atom) {
        if (this.getController2DModel().getAutoUpdateImplicitHydrogens()) {
            atom.setImplicitHydrogenCount(Integer.valueOf(0));
            try {
                Integer neighbourCount;
                IAtomType type = this.matcher.findMatchingAtomType(container, atom);
                if (type != null && (neighbourCount = type.getFormalNeighbourCount()) != null) {
                    atom.setImplicitHydrogenCount(Integer.valueOf(neighbourCount - container.getConnectedAtomsCount(atom)));
                }
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void makeAllExplicitImplicit() {
        IAtomContainer undoRedoContainer = (IAtomContainer)this.chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        List containers = ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel);
        for (int i = 0; i < containers.size(); ++i) {
            IAtomContainer removeatoms = (IAtomContainer)this.chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            for (IAtom atom : ((IAtomContainer)containers.get(i)).atoms()) {
                if (!atom.getSymbol().equals("H")) continue;
                removeatoms.addAtom(atom);
                removeatoms.addBond((IBond)((IAtomContainer)containers.get(i)).getConnectedBondsList(atom).get(0));
                ((IAtom)((IAtomContainer)containers.get(i)).getConnectedAtomsList(atom).get(0)).setImplicitHydrogenCount(Integer.valueOf(((IAtom)((IAtomContainer)containers.get(i)).getConnectedAtomsList(atom).get(0)).getImplicitHydrogenCount() + 1));
            }
            ((IAtomContainer)containers.get(i)).remove(removeatoms);
            undoRedoContainer.add(removeatoms);
        }
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getRemoveAtomsAndBondsEdit(this.chemModel, undoRedoContainer, "Make explicit Hs implicit", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        this.structureChanged();
    }

    @Override
    public void makeAllImplicitExplicit() {
        IAtomContainer undoRedoContainer = (IAtomContainer)this.chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        List containers = ChemModelManipulator.getAllAtomContainers((IChemModel)this.chemModel);
        for (int i = 0; i < containers.size(); ++i) {
            for (IAtom atom : ((IAtomContainer)containers.get(i)).atoms()) {
                int hcount = atom.getImplicitHydrogenCount();
                for (int k = 0; k < hcount; ++k) {
                    IAtom newAtom = this.addAtomWithoutUndo("H", atom);
                    IAtomContainer atomContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.getIChemModel(), (IAtom)newAtom);
                    IBond newBond = atomContainer.getBond(atom, newAtom);
                    undoRedoContainer.addAtom(newAtom);
                    undoRedoContainer.addBond(newBond);
                }
            }
        }
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            IUndoRedoable undoredo = this.getUndoRedoFactory().getAddAtomsAndBondsEdit(this.chemModel, undoRedoContainer, "Make implicit Hs explicit", this);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        this.structureChanged();
    }

    @Override
    public void setHydrogenCount(IAtom atom, int intValue) {
        if (this.getUndoRedoFactory() != null && this.getUndoRedoHandler() != null) {
            HashMap<IAtom, Integer[]> atomhydrogenmap = new HashMap<IAtom, Integer[]>();
            atomhydrogenmap.put(atom, new Integer[]{intValue, atom.getImplicitHydrogenCount()});
            IUndoRedoable undoredo = this.getUndoRedoFactory().getChangeHydrogenCountEdit(atomhydrogenmap, "Change hydrogen count to " + intValue);
            this.getUndoRedoHandler().postEdit(undoredo);
        }
        atom.setImplicitHydrogenCount(Integer.valueOf(intValue));
        this.structureChanged();
    }

    @Override
    public void mergeMolecules(Vector2d movedDistance) {
        IAtomContainer movedAtomContainer;
        RendererModel model = this.getRenderer().getRenderer2DModel();
        Map<IAtom, IAtom> mergeMap = model.getMerge();
        Iterator<IAtom> it = model.getMerge().keySet().iterator();
        if (it.hasNext() && (movedAtomContainer = this.renderer.getRenderer2DModel().getSelection().getConnectedAtomContainer()) != null) {
            IAtom atomA = it.next();
            IAtom atomB = mergeMap.get(atomA);
            Vector2d shift = new Vector2d();
            shift.sub(atomB.getPoint2d(), atomA.getPoint2d());
            for (IAtom shiftAtom : movedAtomContainer.atoms()) {
                shiftAtom.getPoint2d().add(shift);
            }
        }
        it = model.getMerge().keySet().iterator();
        while (it.hasNext()) {
            ArrayList<IBond> removedBonds = new ArrayList<IBond>();
            HashMap<IBond, Integer> bondsWithReplacedAtoms = new HashMap<IBond, Integer>();
            IAtom mergedAtom = it.next();
            IAtom mergedPartnerAtom = model.getMerge().get(mergedAtom);
            IAtomContainer container = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)mergedAtom);
            IAtomContainer container2 = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)mergedPartnerAtom);
            for (IAtom atom : container.atoms()) {
                if (atom.equals(mergedAtom) || container.getBond(mergedAtom, atom) == null || !model.getMerge().containsKey(atom)) continue;
                for (IAtom atom2 : container2.atoms()) {
                    if (atom2.equals(mergedPartnerAtom) || container.getBond(mergedPartnerAtom, atom2) == null || !model.getMerge().get(atom).equals(atom2)) continue;
                    System.out.println("removing ");
                    IBond redundantBond = container.getBond(atom, mergedAtom);
                    container.removeBond(redundantBond);
                    removedBonds.add(redundantBond);
                }
            }
            for (IBond bond : container.bonds()) {
                if (!bond.contains(mergedAtom)) continue;
                if (bond.getAtom(0).equals(mergedAtom)) {
                    bond.setAtom(mergedPartnerAtom, 0);
                    bondsWithReplacedAtoms.put(bond, 0);
                    continue;
                }
                bond.setAtom(mergedPartnerAtom, 1);
                bondsWithReplacedAtoms.put(bond, 1);
            }
            container.removeAtom(mergedAtom);
            this.updateAtom(mergedPartnerAtom);
            IUndoRedoFactory factory = this.getUndoRedoFactory();
            UndoRedoHandler handler = this.getUndoRedoHandler();
            if (factory == null || handler == null) continue;
            IUndoRedoable undoredo = factory.getMergeMoleculesEdit(mergedAtom, container, removedBonds, bondsWithReplacedAtoms, movedDistance, mergedPartnerAtom, "Merge atom", this);
            handler.postEdit(undoredo);
        }
        model.getMerge().clear();
        this.structureChanged();
    }

    @Override
    public void execute(IEdit edit) {
        IAtomContainer ac = this.chemModel.getMoleculeSet().getAtomContainer(0);
        edit.execute(ac);
        if (!(edit instanceof OptionalUndoEdit) || ((OptionalUndoEdit)edit).isFinal()) {
            this.postEdit(edit);
        }
        for (IAtom atom : edit.getAtomsToUpdate()) {
            this.updateAtom(ac, atom);
        }
        this.fireEvents(edit.getTypeOfChanges());
    }

    private void fireEvents(Collection<Changed> events) {
        for (Changed changed : events) {
            switch (changed) {
                case Structure: {
                    this.changeHandler.structureChanged();
                    break;
                }
                case Properties: {
                    this.changeHandler.structurePropertiesChanged();
                    break;
                }
                case Coordinates: {
                    this.changeHandler.coordinatesChanged();
                    break;
                }
                case Selection: {
                    this.changeHandler.selectionChanged();
                    break;
                }
                case Zoom: {
                    this.changeHandler.zoomChanged();
                }
            }
        }
    }

    private void postEdit(IEdit edit) {
        IUndoRedoFactory factory = this.getUndoRedoFactory();
        UndoRedoHandler handler = this.getUndoRedoHandler();
        if (factory != null && handler != null) {
            handler.postEdit(factory.getEditOperation(edit));
        }
    }

    static {
        ringPlacer = new RingPlacer();
    }
}

