/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula.rules;

import java.util.HashMap;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class MMElementRule
implements IRule {
    private Database databaseUsed = Database.WILEY;
    private RangeMass rangeMassUsed = RangeMass.Minus500;
    private HashMap<String, Integer> hashMap = this.getWisley_500();
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MMElementRule.class);

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 2) {
            throw new CDKException("MMElementRule only expects maximal two parameters");
        }
        if (params[0] != null) {
            if (!(params[0] instanceof Database)) {
                throw new CDKException("The parameter must be of type Database enum");
            }
            this.databaseUsed = (Database)((Object)params[0]);
        }
        if (params.length > 1 && params[1] != null) {
            if (!(params[1] instanceof RangeMass)) {
                throw new CDKException("The parameter must be of type RangeMass enum");
            }
            this.rangeMassUsed = (RangeMass)((Object)params[1]);
        }
        if (this.databaseUsed == Database.DNP && this.rangeMassUsed == RangeMass.Minus500) {
            this.hashMap = this.getDNP_500();
        } else if (this.databaseUsed == Database.DNP && this.rangeMassUsed == RangeMass.Minus1000) {
            this.hashMap = this.getDNP_1000();
        } else if (this.databaseUsed == Database.DNP && this.rangeMassUsed == RangeMass.Minus2000) {
            this.hashMap = this.getDNP_2000();
        } else if (this.databaseUsed == Database.DNP && this.rangeMassUsed == RangeMass.Minus3000) {
            this.hashMap = this.getDNP_3000();
        } else if (this.databaseUsed == Database.WILEY && this.rangeMassUsed == RangeMass.Minus500) {
            this.hashMap = this.getWisley_500();
        } else if (this.databaseUsed == Database.WILEY && this.rangeMassUsed == RangeMass.Minus1000) {
            this.hashMap = this.getWisley_1000();
        } else if (this.databaseUsed == Database.WILEY && this.rangeMassUsed == RangeMass.Minus2000) {
            this.hashMap = this.getWisley_2000();
        }
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.databaseUsed, this.rangeMassUsed};
        return params;
    }

    @Override
    public double validate(IMolecularFormula formula) throws CDKException {
        logger.info("Start validation of ", formula);
        double isValid = 1.0;
        for (IElement element : MolecularFormulaManipulator.elements(formula)) {
            int occur = MolecularFormulaManipulator.getElementCount(formula, element);
            if (occur <= this.hashMap.get(element.getSymbol())) continue;
            isValid = 0.0;
            break;
        }
        return isValid;
    }

    private HashMap<String, Integer> getDNP_500() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("C", 29);
        map.put("H", 72);
        map.put("N", 10);
        map.put("O", 18);
        map.put("P", 4);
        map.put("S", 7);
        map.put("F", 15);
        map.put("Cl", 8);
        map.put("Br", 5);
        return map;
    }

    private HashMap<String, Integer> getDNP_1000() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("C", 66);
        map.put("H", 126);
        map.put("N", 25);
        map.put("O", 27);
        map.put("P", 6);
        map.put("S", 8);
        map.put("F", 16);
        map.put("Cl", 11);
        map.put("Br", 8);
        return map;
    }

    private HashMap<String, Integer> getDNP_2000() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("C", 115);
        map.put("H", 236);
        map.put("N", 32);
        map.put("O", 63);
        map.put("P", 6);
        map.put("S", 8);
        map.put("F", 16);
        map.put("Cl", 11);
        map.put("Br", 8);
        return map;
    }

    private HashMap<String, Integer> getDNP_3000() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("C", 162);
        map.put("H", 208);
        map.put("N", 48);
        map.put("O", 78);
        map.put("P", 6);
        map.put("S", 9);
        map.put("F", 16);
        map.put("Cl", 11);
        map.put("Br", 8);
        return map;
    }

    private HashMap<String, Integer> getWisley_500() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("C", 39);
        map.put("H", 72);
        map.put("N", 20);
        map.put("O", 20);
        map.put("P", 9);
        map.put("S", 10);
        map.put("F", 16);
        map.put("Cl", 10);
        map.put("Br", 4);
        map.put("Br", 8);
        return map;
    }

    private HashMap<String, Integer> getWisley_1000() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("C", 78);
        map.put("H", 126);
        map.put("N", 20);
        map.put("O", 27);
        map.put("P", 9);
        map.put("S", 14);
        map.put("F", 34);
        map.put("Cl", 12);
        map.put("Br", 8);
        map.put("Si", 14);
        return map;
    }

    private HashMap<String, Integer> getWisley_2000() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("C", 156);
        map.put("H", 180);
        map.put("N", 20);
        map.put("O", 40);
        map.put("P", 9);
        map.put("S", 14);
        map.put("F", 48);
        map.put("Cl", 12);
        map.put("Br", 10);
        map.put("Si", 15);
        return map;
    }

    public static enum Database {
        WILEY,
        DNP;

    }

    public static enum RangeMass {
        Minus500,
        Minus1000,
        Minus2000,
        Minus3000;

    }
}

