/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.periodictable;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTableElement;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class ElementPTHandler
extends DefaultHandler {
    private final int SCALAR_UNSET = 0;
    private final int LABEL_CAS = 1;
    private final int SCALAR_NAME = 2;
    private final int SCALAR_ATOMICNUMBER = 3;
    private final int SCALAR_CHEMICALSERIE = 4;
    private final int SCALAR_PERIOD = 5;
    private final int SCALAR_GROUP = 6;
    private final int SCALAR_PHASE = 7;
    private final int SCALAR_RADCOV = 8;
    private final int SCALAR_RADVDW = 9;
    private final int SCALAR_PAULE = 10;
    private int scalarType;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ElementPTHandler.class);
    private String currentChars;
    private List<PeriodicTableElement> elements;
    public PeriodicTableElement elementType;
    public String currentElement;
    public String dictRef;

    public List<PeriodicTableElement> getElements() {
        return this.elements;
    }

    @Override
    public void startDocument() {
        this.elements = new ArrayList<PeriodicTableElement>();
        this.scalarType = 0;
        this.elementType = null;
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        logger.debug("end element: ", raw);
        if ("elementType".equals(local)) {
            this.elements.add(this.elementType);
        } else if ("label".equals(local)) {
            this.currentChars.trim();
            try {
                if (this.scalarType == 1) {
                    this.elementType.setCASid(this.currentChars);
                }
            }
            catch (NumberFormatException exception) {
                logger.error("The abundance value is incorrect: ", this.currentChars);
                logger.debug(exception);
            }
        } else if ("scalar".equals(local)) {
            this.currentChars.trim();
            try {
                if (this.scalarType == 2) {
                    this.elementType.setName(this.currentChars);
                } else if (this.scalarType == 3) {
                    this.elementType.setAtomicNumber(Integer.parseInt(this.currentChars));
                } else if (this.scalarType == 4) {
                    this.elementType.setChemicalSerie(this.currentChars);
                } else if (this.scalarType == 5) {
                    this.elementType.setPeriod(Integer.parseInt(this.currentChars));
                } else if (this.scalarType == 6) {
                    this.elementType.setGroup(Integer.parseInt(this.currentChars));
                } else if (this.scalarType == 7) {
                    this.elementType.setPhase(this.currentChars);
                } else if (this.scalarType == 8) {
                    this.elementType.setCovalentRadius(Double.parseDouble(this.currentChars));
                } else if (this.scalarType == 9) {
                    this.elementType.setVdwRadius(Double.parseDouble(this.currentChars));
                } else if (this.scalarType == 10) {
                    this.elementType.setPaulingEneg(Double.parseDouble(this.currentChars));
                }
            }
            catch (NumberFormatException exception) {
                logger.error("The abundance value is incorrect: ", this.currentChars);
                logger.debug(exception);
            }
            catch (CDKException e) {
                logger.error("Invalid IUPAC group number is specified");
            }
            this.scalarType = 0;
        }
        this.currentChars = "";
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes atts) {
        block13: {
            block14: {
                block12: {
                    this.currentChars = "";
                    this.dictRef = "";
                    logger.debug("startElement: ", raw);
                    logger.debug("uri: ", uri);
                    logger.debug("local: ", local);
                    logger.debug("raw: ", raw);
                    if (!"elementType".equals(local)) break block12;
                    for (int i = 0; i < atts.getLength(); ++i) {
                        if (!"id".equals(atts.getQName(i))) continue;
                        this.elementType = new PeriodicTableElement(atts.getValue(i));
                    }
                    break block13;
                }
                if (!"label".equals(local)) break block14;
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (!"dictRef".equals(atts.getQName(i)) || !"cas:id".equals(atts.getValue(i))) continue;
                    this.scalarType = 1;
                }
                break block13;
            }
            if (!"scalar".equals(local)) break block13;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!"dictRef".equals(atts.getQName(i))) continue;
                if ("cdk:name".equals(atts.getValue(i))) {
                    this.scalarType = 2;
                    continue;
                }
                if ("cdk:atomicNumber".equals(atts.getValue(i))) {
                    this.scalarType = 3;
                    continue;
                }
                if ("cdk:name".equals(atts.getValue(i))) {
                    this.scalarType = 2;
                    continue;
                }
                if ("cdk:chemicalSerie".equals(atts.getValue(i))) {
                    this.scalarType = 4;
                    continue;
                }
                if ("cdk:period".equals(atts.getValue(i))) {
                    this.scalarType = 5;
                    continue;
                }
                if ("cdk:group".equals(atts.getValue(i))) {
                    this.scalarType = 6;
                    continue;
                }
                if ("cdk:phase".equals(atts.getValue(i))) {
                    this.scalarType = 7;
                    continue;
                }
                if ("cdk:radiiCova".equals(atts.getValue(i))) {
                    this.scalarType = 8;
                    continue;
                }
                if ("cdk:radiiVdw".equals(atts.getValue(i))) {
                    this.scalarType = 9;
                    continue;
                }
                if (!"cdk:paulingE".equals(atts.getValue(i))) continue;
                this.scalarType = 10;
            }
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        logger.debug("character data");
        this.currentChars = this.currentChars + new String(chars, start, length);
    }
}

