/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IAtomTypeConfigurator;
import org.openscience.cdk.config.atomtypes.AtomTypeReader;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.config.CDKBasedAtomTypeConfiguratorTest")
public class CDKBasedAtomTypeConfigurator
implements IAtomTypeConfigurator {
    private String configFile = "org.openscience.cdk.config.data.structgen_atomtypes.xml";
    private InputStream ins = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CDKBasedAtomTypeConfigurator.class);

    @Override
    @TestMethod(value="testSetInputStream_InputStream")
    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    @Override
    @TestMethod(value="testReadAtomTypes_IChemObjectBuilder")
    public List<IAtomType> readAtomTypes(IChemObjectBuilder builder) throws IOException {
        if (this.ins == null) {
            try {
                this.ins = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
            }
            catch (Exception exc) {
                logger.error(exc.getMessage());
                logger.debug(exc);
                throw new IOException("There was a problem getting a stream for " + this.configFile + " with getClass.getClassLoader.getResourceAsStream");
            }
            if (this.ins == null) {
                try {
                    this.ins = this.getClass().getResourceAsStream(this.configFile);
                }
                catch (Exception exc) {
                    logger.error(exc.getMessage());
                    logger.debug(exc);
                    throw new IOException("There was a problem getting a stream for " + this.configFile + " with getClass.getResourceAsStream");
                }
            }
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting an input stream");
        }
        AtomTypeReader reader = new AtomTypeReader(new InputStreamReader(this.ins));
        List<IAtomType> atomTypes = reader.readAtomTypes(builder);
        for (IAtomType atomType : atomTypes) {
            if (atomType != null) continue;
            logger.debug("Expecting an object but found null!");
        }
        return atomTypes;
    }
}

