/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.selection;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import javax.vecmath.Point2d;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.PathElement;
import org.openscience.cdk.renderer.selection.ShapeSelection;

public class LassoSelection
extends ShapeSelection {
    private final ArrayList<Point2d> points = new ArrayList();
    private GeneralPath path = null;

    @Override
    public IRenderingElement generate(Color color) {
        return new PathElement(this.points, color);
    }

    @Override
    public boolean contains(Point2d p) {
        if (this.points.size() < 3) {
            return false;
        }
        this.path = new GeneralPath();
        Point2d p0 = this.points.get(0);
        this.path.moveTo((float)p0.x, (float)p0.y);
        for (Point2d point : this.points) {
            this.path.lineTo((float)point.x, (float)point.y);
        }
        this.path.closePath();
        return this.path.contains(p.x, p.y);
    }

    @Override
    public void addPoint(Point2d p) {
        this.points.add(new Point2d(p.x, p.y));
    }

    @Override
    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    public void reset() {
        this.finished = true;
        this.points.clear();
        this.path = null;
    }
}

