/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

public class RadicalGenerator
implements IGenerator<IAtomContainer> {
    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        ElementGroup group = new ElementGroup();
        double SCREEN_RADIUS = 2.0;
        Color RADICAL_COLOR = Color.BLACK;
        double ATOM_RADIUS = (Double)model.getParameter(BasicAtomGenerator.AtomRadius.class).getValue();
        double modelRadius = 2.0 / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        HashMap<IAtom, Integer> singleElectronsPerAtom = new HashMap<IAtom, Integer>();
        for (ISingleElectron e : ac.singleElectrons()) {
            IAtom atom = e.getAtom();
            if (singleElectronsPerAtom.get(atom) == null) {
                singleElectronsPerAtom.put(atom, 0);
            }
            Point2d p = atom.getPoint2d();
            int align = GeometryTools.getBestAlignmentForLabelXY((IAtomContainer)ac, (IAtom)atom);
            double rx = p.x;
            double ry = p.y;
            if (align == 1) {
                rx += ATOM_RADIUS + (double)((Integer)singleElectronsPerAtom.get(atom)).intValue() * ATOM_RADIUS;
            } else if (align == -1) {
                rx -= ATOM_RADIUS + (double)((Integer)singleElectronsPerAtom.get(atom)).intValue() * ATOM_RADIUS;
            } else if (align == 2) {
                ry += ATOM_RADIUS + (double)((Integer)singleElectronsPerAtom.get(atom)).intValue() * ATOM_RADIUS;
            } else if (align == -2) {
                ry -= ATOM_RADIUS + (double)((Integer)singleElectronsPerAtom.get(atom)).intValue() * ATOM_RADIUS;
            }
            singleElectronsPerAtom.put(atom, (Integer)singleElectronsPerAtom.get(atom) + 1);
            group.add(new OvalElement(rx, ry, modelRadius, true, RADICAL_COLOR));
        }
        return group;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Collections.emptyList();
    }
}

