/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.color.CDK2DAtomColors;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.elements.AtomSymbolElement;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;
import org.openscience.cdk.validate.ProblemMarker;

public class BasicAtomGenerator
implements IGenerator<IAtomContainer> {
    private IGeneratorParameter<Color> atomColor = new AtomColor();
    private IGeneratorParameter<IAtomColorer> atomColorer = new AtomColorer();
    private IGeneratorParameter<Boolean> colorByType = new ColorByType();
    private IGeneratorParameter<Boolean> showExplicitHydrogens = new ShowExplicitHydrogens();
    private IGeneratorParameter<Double> atomRadius = new AtomRadius();
    private IGeneratorParameter<Boolean> isCompact = new CompactAtom();
    private IGeneratorParameter<Boolean> isKekule = new KekuleStructure();
    private IGeneratorParameter<Shape> compactShape = new CompactShape();
    private IGeneratorParameter<Boolean> showEndCarbons = new ShowEndCarbons();

    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        ElementGroup elementGroup = new ElementGroup();
        for (IAtom atom : ac.atoms()) {
            elementGroup.add(this.generate(ac, atom, model));
        }
        return elementGroup;
    }

    public boolean hasCoordinates(IAtom atom) {
        return atom != null && atom.getPoint2d() != null;
    }

    public boolean invisibleHydrogen(IAtom atom, RendererModel model) {
        return this.isHydrogen(atom) && this.showExplicitHydrogens.getValue() == false;
    }

    public boolean invisibleCarbon(IAtom atom, IAtomContainer ac, RendererModel model) {
        return this.isCarbon(atom) && !this.showCarbon(atom, ac, model);
    }

    public boolean canDraw(IAtom atom, IAtomContainer ac, RendererModel model) {
        if (!this.hasCoordinates(atom)) {
            return false;
        }
        if (this.invisibleHydrogen(atom, model)) {
            return false;
        }
        return !this.invisibleCarbon(atom, ac, model);
    }

    public IRenderingElement generate(IAtomContainer ac, IAtom atom, RendererModel model) {
        if (!this.canDraw(atom, ac, model)) {
            return null;
        }
        if (this.isCompact.getValue().booleanValue()) {
            return this.generateCompactElement(atom, model);
        }
        int alignment = 0;
        alignment = this.isCarbon(atom) ? GeometryTools.getBestAlignmentForLabel((IAtomContainer)ac, (IAtom)atom) : GeometryTools.getBestAlignmentForLabelXY((IAtomContainer)ac, (IAtom)atom);
        return this.generateElements(atom, alignment, model);
    }

    public IRenderingElement generateCompactElement(IAtom atom, RendererModel model) {
        Point2d p = atom.getPoint2d();
        double r = this.atomRadius.getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double d = 2.0 * r;
        if (this.compactShape.getValue() == Shape.SQUARE) {
            return new RectangleElement(p.x - r, p.y - r, d, d, true, this.getAtomColor(atom));
        }
        return new OvalElement(p.x, p.y, r, true, this.getAtomColor(atom));
    }

    public IRenderingElement generateElements(IAtom atom, int alignment, RendererModel model) {
        String text = atom instanceof IPseudoAtom ? ((IPseudoAtom)atom).getLabel() : atom.getSymbol();
        return new AtomSymbolElement(atom.getPoint2d().x, atom.getPoint2d().y, text, atom.getFormalCharge(), atom.getImplicitHydrogenCount(), alignment, this.getAtomColor(atom));
    }

    public boolean isHydrogen(IAtom atom) {
        return "H".equals(atom.getSymbol());
    }

    public boolean isCarbon(IAtom atom) {
        return "C".equals(atom.getSymbol());
    }

    public boolean showCarbon(IAtom atom, IAtomContainer ac, RendererModel model) {
        if (this.isKekule.getValue().booleanValue()) {
            return true;
        }
        if (atom.getFormalCharge() != 0) {
            return true;
        }
        if (ac.getConnectedBondsList(atom).size() < 1) {
            return true;
        }
        if (this.showEndCarbons.getValue().booleanValue() && ac.getConnectedBondsList(atom).size() == 1) {
            return true;
        }
        if (atom.getProperty((Object)ProblemMarker.ERROR_MARKER) != null) {
            return true;
        }
        return ac.getConnectedSingleElectronsCount(atom) > 0;
    }

    protected Color getAtomColor(IAtom atom) {
        Color atomColor = this.atomColor.getValue();
        if (this.colorByType.getValue().booleanValue()) {
            atomColor = this.atomColorer.getValue().getAtomColor(atom);
        }
        return atomColor;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.atomColor, this.atomColorer, this.atomRadius, this.colorByType, this.compactShape, this.isCompact, this.isKekule, this.showEndCarbons, this.showExplicitHydrogens);
    }

    public static class ShowEndCarbons
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class CompactShape
    extends AbstractGeneratorParameter<Shape> {
        @Override
        public Shape getDefault() {
            return Shape.SQUARE;
        }
    }

    public static enum Shape {
        OVAL,
        SQUARE;

    }

    public static class KekuleStructure
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class CompactAtom
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class AtomRadius
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 8.0;
        }
    }

    public static class ShowExplicitHydrogens
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    public static class ColorByType
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    public static class AtomColorer
    extends AbstractGeneratorParameter<IAtomColorer> {
        @Override
        public IAtomColorer getDefault() {
            return new CDK2DAtomColors();
        }
    }

    public static class AtomColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.BLACK;
        }
    }
}

