/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReactionSet;

public class LoadNewModelEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -9022673628051651034L;
    private IChemModel chemModel;
    private IMoleculeSet oldsom;
    private IReactionSet oldsor;
    private IMoleculeSet newsom;
    private IReactionSet newsor;
    private String type;

    public LoadNewModelEdit(IChemModel chemModel, IMoleculeSet oldsom, IReactionSet oldsor, IMoleculeSet newsom, IReactionSet newsor, String type) {
        this.chemModel = chemModel;
        this.newsom = newsom;
        this.newsor = newsor;
        this.oldsom = oldsom;
        this.oldsor = oldsor;
        this.type = type;
    }

    @Override
    public void redo() {
        this.chemModel.setMoleculeSet(this.newsom);
        this.chemModel.setReactionSet(this.newsor);
    }

    @Override
    public void undo() {
        this.chemModel.setMoleculeSet(this.oldsom);
        this.chemModel.setReactionSet(this.oldsor);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

