/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.renderer.AtomContainerRenderer;
import org.openscience.cdk.renderer.font.AWTFontManager;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.RingGenerator;
import org.openscience.cdk.renderer.visitor.AWTDrawVisitor;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;
import org.openscience.cdk.smiles.SmilesParser;

public class MoleculeCell
extends JPanel {
    private int preferredWidth;
    private int preferredHeight;
    private IAtomContainer atomContainer;
    private AtomContainerRenderer renderer;
    private boolean isNew;

    public MoleculeCell(IAtomContainer atomContainer, int w, int h) {
        for (IAtom atom : atomContainer.atoms()) {
            if (atom.getPoint2d() != null) continue;
            throw new IllegalArgumentException("Molecule must have 2D coordinates");
        }
        this.atomContainer = atomContainer;
        this.preferredWidth = w;
        this.preferredHeight = h;
        this.setPreferredSize(new Dimension(w, h));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder());
        ArrayList<Object> generators = new ArrayList<Object>();
        generators.add(new BasicSceneGenerator());
        generators.add(new RingGenerator());
        generators.add(new BasicAtomGenerator());
        this.renderer = new AtomContainerRenderer(generators, (IFontManager)new AWTFontManager());
        this.isNew = true;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isNew) {
            Rectangle drawArea = new Rectangle(0, 0, this.preferredWidth, this.preferredHeight);
            this.renderer.setup(this.atomContainer, drawArea);
            this.isNew = false;
            this.renderer.paint(this.atomContainer, (IDrawVisitor)new AWTDrawVisitor((Graphics2D)g), (Rectangle2D)drawArea, this.isNew);
        } else {
            Rectangle drawArea = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            this.renderer.setup(this.atomContainer, drawArea);
            this.renderer.paint(this.atomContainer, (IDrawVisitor)new AWTDrawVisitor((Graphics2D)g), (Rectangle2D)drawArea, false);
        }
    }

    public static void main(String[] args) throws InvalidSmilesException {
        SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
        IAtomContainer container = sp.parseSmiles("C1CN2CCN(CCCN(CCN(C1)Cc1ccccn1)CC2)C");
        StructureDiagramGenerator sdg = new StructureDiagramGenerator();
        sdg.setMolecule(container);
        try {
            sdg.generateCoordinates();
        }
        catch (Exception e) {
            // empty catch block
        }
        container = sdg.getMolecule();
        MoleculeCell mcell = new MoleculeCell(container, 200, 200);
        JFrame frame = new JFrame("Molecule Cell");
        frame.getContentPane().add(mcell);
        frame.pack();
        frame.setVisible(true);
    }
}

