% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obia.R
\name{obia}
\alias{obia}
\title{Object-based image analysis of canopy photographs}
\usage{
obia(r, z = NULL, a = NULL, bin, segmentation, gf_mn = 0.2, gf_mx = 0.95)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically,
the blue channel extracted from a canopy photograph. Please see
\code{\link{read_caim}} and \code{\link{normalize}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link{azimuth_image}}.}

\item{bin}{\linkS4class{SpatRaster}. This should be a working binarization
of \code{r} without gross errors.}

\item{segmentation}{\linkS4class{SpatRaster} built with
\code{\link{polar_qtree}} or \code{\link{qtree}}.}

\item{gf_mn, gf_mx}{Numeric vector of length one. The minimum/maximum gap
fraction that a segment should comply with to be considered as one
containing foliage.}
}
\value{
\linkS4class{SpatRaster}.
}
\description{
Object-based image analysis targeting the canopy  silhouette.
}
\details{
This method was first presented in \insertCite{Diaz2015;textual}{rcaiman}.
This version is simpler since it relies on a better working binarized image.
The version from 2015 uses an automatic selection of samples followed by a
\emph{knn} classification of segments containing foliage. This version uses
de gap fraction extracted from \code{bin} to classify \emph{foliage} by
defining upper and lower limits through the arguments \code{gf_mx} and
\code{gf_mn}.

This method produces a synthetic layer by computing the ratio of \code{r} to
the maximum value of \code{r} at the segment level. This process is carried
out only on the pixels covered by the classes \emph{foliage} and \emph{sky}--
the latter is defined by \code{bin} equal to one. To avoid spurious values,
the quantile \code{0.9} is computed instead of the maximum. Pixels not
belonging to the class \emph{foliage} return as \code{NA}.

Default values of \code{z} and \code{a} allows the processing of
restricted view photographs.

If you use this function in your research, please cite
\insertCite{Diaz2015;textual}{rcaiman} in addition to this package.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue \%>\% gbc()
caim <- normalize(caim)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
m <- !is.na(z)
m2 <- !mask_sunlit_canopy(caim, m)
ecaim <- enhance_caim(caim, m)
bin <- apply_thr(ecaim, thr_isodata(ecaim[m2]))

seg <- polar_qtree(caim, z, a)
synth <- obia(r, z, a, bin, seg)
plot(synth)
foliage <- !is.na(synth)
hist(synth[foliage])
synth <- terra::cover(synth, bin)
plot(synth)
bin_obia <- apply_thr(synth, thr_isodata(synth[foliage]))
plot(bin - bin_obia)
plot(bin_obia)
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Binarization Functions: 
\code{\link{apply_thr}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{ootb_mblt}()},
\code{\link{ootb_obia}()},
\code{\link{regional_thresholding}()},
\code{\link{thr_image}()},
\code{\link{thr_isodata}()}
}
\concept{Binarization Functions}
