% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_grid.R
\name{grid_plot}
\alias{grid_plot}
\title{Create a Bokeh grid plot from a list of Bokeh figures}
\usage{
grid_plot(
  figs,
  width = NULL,
  height = NULL,
  nrow = 1,
  ncol = 1,
  byrow = TRUE,
  xlim = NULL,
  ylim = NULL,
  logo = NULL,
  same_axes = FALSE,
  simplify_axes = TRUE,
  y_margin = NULL,
  x_margin = NULL,
  link_data = FALSE
)
}
\arguments{
\item{figs}{list of Bokeh figures - see details for what is acceptable}

\item{width}{width of the entire grid plot in pixels - if \code{NULL}, the sum of the grid widths of columns will be used - if not \code{NULL}, the widths of the plots will be proportionately shrunk to meet the specified width}

\item{height}{height of the entire grid plot in pixels - if \code{NULL}, the sum of the grid heights of rows will be used - if not \code{NULL}, the heights of the plots will be proportionately shrunk to meet the specified height}

\item{nrow}{number of rows in the grid}

\item{ncol}{number of columns in the grid}

\item{byrow}{populate the grid by row according to the order of figure elements supplied in \code{params}}

\item{xlim}{the extent of the plotting area in the x-dimension to be applied to every panel (original individual panel limits will be honored if not specified).}

\item{ylim}{the extent of the plotting area in the y-dimension to be applied to every panel (original individual panel limits will be honored if not specified).}

\item{logo}{('normal', 'grey') What version of the Bokeh logo to display on the toolbar. If set to NULL, no logo will be displayed.}

\item{same_axes}{logical or vector of two logicals specifying whether the x and/or y axis limits should be the same for each plot in the grid}

\item{simplify_axes}{logical or vector of logicals specifying whether to simply the x and/or y axes (only show the axes along the bottom and left sides of the grid) - only valid if \code{same_axes} is \code{TRUE} for the axis}

\item{x_margin, y_margin}{specify the margin space in pixels to be left for axes when using \code{simplify_axes=TRUE}}

\item{link_data}{logical - should an attempt be made to join the data sources of each plot for linked brushing? (see details)}
}
\description{
Create a Bokeh grid plot from a list of Bokeh figures
}
\details{
The \code{figs} parameter can either be a list of figures or a list of lists of figures.  If the latter, the list structure will determine the layout, with each super-list of figures defining a single row of the grid.  If the former, the parameters \code{nrow} and \code{ncol} and \code{byrow} are used to determine the layout.  The grid is from top to bottom left to right.

If \code{link_data} is \code{TRUE}, then an effort will be made to link all data sources that are common among the different figures in the plot.  Note that at this point, only data sources that are specified in the \code{data} argument to the different layer functions are checked.
}
\examples{
\donttest{
idx <- split(1:150, iris$Species)
figs <- lapply(idx, function(x) {
  figure(width = 300, height = 300) \%>\%
    ly_points(Sepal.Length, Sepal.Width, data = iris[x, ],
      hover = list(Sepal.Length, Sepal.Width))
})

# 1 row, 3 columns
grid_plot(figs)
# specify xlim and ylim to be applied to all panels
grid_plot(figs, xlim = c(4, 8), ylim = c(1.5, 4.5))
# unnamed list will remove labels
grid_plot(unname(figs))
# 2 rows, 2 columns
grid_plot(figs, nrow = 2)
# x and y axis with same (and linked) limits
grid_plot(figs, same_axes = TRUE)
# x axis with same (and linked) limits
grid_plot(figs, same_axes = c(TRUE, FALSE), nrow = 2)
# x axis with same (and linked) limits and custom xlim
grid_plot(figs, same_axes = c(TRUE, FALSE), xlim = c(5, 7), nrow = 2)
# send lists instead of specifying nrow and ncol
grid_plot(list(
  c(list(figs[[1]]), list(figs[[3]])),
  c(list(NULL), list(figs[[2]]))
))
# a null entry will be skipped in the grid
figs2 <- figs
figs2[1] <- list(NULL)
grid_plot(figs2, nrow = 2)
# with themes
grid_plot(figs) \%>\%
  theme_title(text_color = "red") \%>\%
  theme_plot(background_fill_color = "#E6E6E6",
    outline_line_color = "white") \%>\%
  theme_grid(c("x", "y"), grid_line_color = "white",
    minor_grid_line_color = "white",
    minor_grid_line_alpha = 0.4) \%>\%
  theme_axis(c("x", "y"), axis_line_color = "white",
    major_label_text_color = "#7F7F7F",
    major_tick_line_color = "#7F7F7F",
    minor_tick_line_alpha = 0, num_minor_ticks = 2)
# themes again
grid_plot(figs) \%>\%
  set_theme(bk_ggplot_theme)

# link data across plots in the grid (try box_select tool)
# (data sources must be the same)
tools <- c("pan", "wheel_zoom", "box_zoom", "box_select", "reset")
p1 <- figure(tools = tools, width = 500, height = 500) \%>\%
  ly_points(Sepal.Length, Sepal.Width, data = iris, color = Species)
p2 <- figure(tools = tools, width = 500, height = 500) \%>\%
  ly_points(Petal.Length, Petal.Width, data = iris, color = Species)
grid_plot(list(p1, p2), same_axes = TRUE, link_data = TRUE)
}
}
