% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_gmap.R
\name{gmap}
\alias{gmap}
\title{Initialize a Bokeh Google Map plot}
\usage{
gmap(lat = 0, lng = 0, zoom = 0, map_type = "hybrid",
  map_style = NULL, width = 480, height = 480, title = NULL,
  xlab = NULL, ylab = NULL, xlim = NULL, ylim = NULL,
  padding_factor = 0.07, xgrid = FALSE, ygrid = FALSE, xaxes = FALSE,
  yaxes = FALSE, tools = c("pan", "wheel_zoom", "save"),
  theme = getOption("bokeh_theme"))
}
\arguments{
\item{lat}{latitude where the map should be centered}

\item{lng}{longitude where the map should be centered}

\item{zoom}{initial \href{https://developers.google.com/maps/documentation/staticmaps/#Zoomlevels}{zoom level} to use when displaying the map}

\item{map_type}{\href{https://developers.google.com/maps/documentation/staticmaps/#MapTypes}{map type} to use for the plot - one of "hybrid", "satellite", "roadmap", "terrain"}

\item{map_style}{a json string of a Google Maps style - see \code{\link{gmap_style}}}

\item{width}{figure width in pixels}

\item{height}{figure width in pixels}

\item{title}{a title to display above the plot. - "title" is also the prefix for a set of Text Properties, so you can set the font for the title with the parameter text_font.}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{xlim}{the extent of the plotting area in the x-dimension (will be computed automatically if not specified).}

\item{ylim}{the extent of the plotting area in the y-dimension (will be computed automatically if not specified).}

\item{padding_factor}{if limits are not specified, by what factor should the extents of the data be padded}

\item{xgrid}{whether to draw x axis grid lines}

\item{ygrid}{whether to draw y axis grid lines}

\item{xaxes}{where to put x axis, or FALSE if no x axis ticks / labels}

\item{yaxes}{where to put y axis, or FALSE if no y axis ticks / labels}

\item{tools}{character vector of interactivity tools options (acceptable values are: "pan", "wheel_zoom", "box_zoom", "resize", "crosshair", "box_select", "lasso_select", "reset", "save", "help").  Additionally, tool functions can be called on a figure to specify more control - see the "See Also" section below for a list of tool functions.  If \code{NULL}, the toolbar will not be drawn.  If \code{""} the toolbar will be drawn but no tools will be added by default.}

\item{theme}{an rbokeh theme to use}
}
\description{
Initialize a Bokeh Google Map plot
}
\note{
This can be used in the same way as \code{\link{figure}}, adding layers on top of the Google Map.
There is an open issue documenting points appearing to sometimes be a few pixels off from their intended location.
Google has its own terms of service for using Google Maps API and any use of rbokeh with Google Maps must be within Google's Terms of Service
}
\examples{
\donttest{
gmap(title = "NYC taxi pickups January 2013",
  lat = 40.74, lng = -73.95, zoom = 11,
  map_type = "roadmap", width = 1000, height = 800) \%>\%
  ly_hexbin(nyctaxihex, alpha = 0.5,
    palette = "Spectral10", trans = log, inv = exp)

# custom map style
gmap(lat = 40.74, lng = -73.95, zoom = 11,
  width = 600, height = 600,
  map_style = gmap_style("blue_water"))
}




}
\seealso{
\code{\link{gmap_style}}
}

