// Generated by rstantools.  Do not edit by hand.

/*
    rbmi is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rbmi is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rbmi.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_MMRM_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'MMRM', line 43, column 4 to column 20)",
                                                      " (in 'MMRM', line 44, column 4 to column 39)",
                                                      " (in 'MMRM', line 71, column 3 to column 38)",
                                                      " (in 'MMRM', line 47, column 4 to column 27)",
                                                      " (in 'MMRM', line 48, column 11 to column 12)",
                                                      " (in 'MMRM', line 48, column 4 to column 29)",
                                                      " (in 'MMRM', line 50, column 8 to column 57)",
                                                      " (in 'MMRM', line 49, column 17 to line 51, column 5)",
                                                      " (in 'MMRM', line 49, column 4 to line 51, column 5)",
                                                      " (in 'MMRM', line 54, column 8 to column 34)",
                                                      " (in 'MMRM', line 55, column 8 to column 30)",
                                                      " (in 'MMRM', line 56, column 8 to column 25)",
                                                      " (in 'MMRM', line 58, column 14 to column 18)",
                                                      " (in 'MMRM', line 58, column 8 to column 63)",
                                                      " (in 'MMRM', line 59, column 15 to column 19)",
                                                      " (in 'MMRM', line 59, column 20 to column 24)",
                                                      " (in 'MMRM', line 59, column 8 to column 63)",
                                                      " (in 'MMRM', line 61, column 8 to column 63)",
                                                      " (in 'MMRM', line 63, column 14 to column 17)",
                                                      " (in 'MMRM', line 63, column 26 to column 30)",
                                                      " (in 'MMRM', line 63, column 8 to column 99)",
                                                      " (in 'MMRM', line 64, column 14 to column 17)",
                                                      " (in 'MMRM', line 64, column 26 to column 30)",
                                                      " (in 'MMRM', line 64, column 8 to column 101)",
                                                      " (in 'MMRM', line 65, column 8 to column 42)",
                                                      " (in 'MMRM', line 67, column 8 to column 43)",
                                                      " (in 'MMRM', line 52, column 22 to line 68, column 5)",
                                                      " (in 'MMRM', line 52, column 4 to line 68, column 5)",
                                                      " (in 'MMRM', line 25, column 4 to column 19)",
                                                      " (in 'MMRM', line 26, column 4 to column 19)",
                                                      " (in 'MMRM', line 27, column 4 to column 19)",
                                                      " (in 'MMRM', line 28, column 4 to column 25)",
                                                      " (in 'MMRM', line 29, column 4 to column 23)",
                                                      " (in 'MMRM', line 30, column 10 to column 15)",
                                                      " (in 'MMRM', line 30, column 4 to column 36)",
                                                      " (in 'MMRM', line 31, column 10 to column 15)",
                                                      " (in 'MMRM', line 31, column 4 to column 39)",
                                                      " (in 'MMRM', line 32, column 10 to column 15)",
                                                      " (in 'MMRM', line 32, column 4 to column 42)",
                                                      " (in 'MMRM', line 33, column 10 to column 15)",
                                                      " (in 'MMRM', line 33, column 17 to column 24)",
                                                      " (in 'MMRM', line 33, column 4 to column 55)",
                                                      " (in 'MMRM', line 34, column 11 to column 12)",
                                                      " (in 'MMRM', line 34, column 4 to column 16)",
                                                      " (in 'MMRM', line 35, column 11 to column 12)",
                                                      " (in 'MMRM', line 35, column 13 to column 14)",
                                                      " (in 'MMRM', line 35, column 4 to column 18)",
                                                      " (in 'MMRM', line 36, column 11 to column 12)",
                                                      " (in 'MMRM', line 36, column 13 to column 14)",
                                                      " (in 'MMRM', line 36, column 4 to column 18)",
                                                      " (in 'MMRM', line 37, column 10 to column 11)",
                                                      " (in 'MMRM', line 37, column 20 to column 27)",
                                                      " (in 'MMRM', line 37, column 29 to column 36)",
                                                      " (in 'MMRM', line 37, column 4 to column 49)",
                                                      " (in 'MMRM', line 40, column 10 to column 11)",
                                                      " (in 'MMRM', line 40, column 13 to column 14)",
                                                      " (in 'MMRM', line 40, column 3 to column 39)",
                                                      " (in 'MMRM', line 43, column 11 to column 12)",
                                                      " (in 'MMRM', line 44, column 10 to column 11)",
                                                      " (in 'MMRM', line 44, column 24 to column 31)",
                                                      " (in 'MMRM', line 71, column 10 to column 11)",
                                                      " (in 'MMRM', line 4, column 8 to column 18)",
                                                      " (in 'MMRM', line 6, column 12 to column 22)",
                                                      " (in 'MMRM', line 5, column 28 to line 7, column 9)",
                                                      " (in 'MMRM', line 5, column 8 to line 7, column 9)",
                                                      " (in 'MMRM', line 8, column 8 to column 18)",
                                                      " (in 'MMRM', line 2, column 39 to line 9, column 5)",
                                                      " (in 'MMRM', line 13, column 14 to column 62)",
                                                      " (in 'MMRM', line 13, column 71 to column 83)",
                                                      " (in 'MMRM', line 13, column 8 to column 89)",
                                                      " (in 'MMRM', line 14, column 8 to column 18)",
                                                      " (in 'MMRM', line 15, column 8 to column 18)",
                                                      " (in 'MMRM', line 17, column 12 to column 48)",
                                                      " (in 'MMRM', line 18, column 12 to column 20)",
                                                      " (in 'MMRM', line 19, column 12 to column 33)",
                                                      " (in 'MMRM', line 16, column 38 to line 20, column 9)",
                                                      " (in 'MMRM', line 16, column 8 to line 20, column 9)",
                                                      " (in 'MMRM', line 21, column 8 to column 20)",
                                                      " (in 'MMRM', line 10, column 69 to line 22, column 5)"};
int
integer_division(const int& a, const int& b, std::ostream* pstream__) {
  using local_scalar_t__ = double;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int i;
    i = std::numeric_limits<int>::min();
    
    current_statement__ = 62;
    i = 0;
    current_statement__ = 65;
    while (logical_lte((b * (i + 1)), a)) {
      current_statement__ = 63;
      i = (i + 1);
    }
    current_statement__ = 66;
    return i;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct integer_division_functor__ {
int
operator()(const int& a, const int& b, std::ostream* pstream__)  const 
{
return integer_division(a, b, pstream__);
}
};
template <typename T0__>
std::vector<Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>>
to_vector_of_arrays(const T0__& vec_arg__, const int& length_array,
                    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& vec = to_ref(vec_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 68;
    validate_non_negative_index("res",
                                "integer_division(num_elements(vec), length_array)",
                                integer_division(num_elements(vec),
                                  length_array, pstream__));
    current_statement__ = 69;
    validate_non_negative_index("res", "length_array", length_array);
    std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> res;
    res = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(integer_division(
                                                                num_elements(
                                                                  vec),
                                                                length_array, pstream__), Eigen::Matrix<local_scalar_t__, -1, 1>(length_array));
    stan::math::fill(res, DUMMY_VAR__);
    
    int j;
    j = std::numeric_limits<int>::min();
    
    current_statement__ = 71;
    j = 1;
    int i;
    i = std::numeric_limits<int>::min();
    
    current_statement__ = 72;
    i = 1;
    current_statement__ = 77;
    while (logical_lte(j, num_elements(vec))) {
      current_statement__ = 73;
      assign(res,
        cons_list(index_uni(i), cons_list(index_omni(), nil_index_list())),
        rvalue(vec,
          cons_list(index_min_max(j, ((j + length_array) - 1)),
            nil_index_list()), "vec"), "assigning variable res");
      current_statement__ = 74;
      i = (i + 1);
      current_statement__ = 75;
      j = (j + length_array);
    }
    current_statement__ = 78;
    return res;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct to_vector_of_arrays_functor__ {
template <typename T0__>
std::vector<Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>>
operator()(const T0__& vec, const int& length_array, std::ostream* pstream__)  const 
{
return to_vector_of_arrays(vec, length_array, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_MMRM final : public model_base_crtp<model_MMRM> {
private:
  int N;
  int P;
  int G;
  int n_visit;
  int n_pat;
  std::vector<int> pat_G;
  std::vector<int> pat_n_pt;
  std::vector<int> pat_n_visit;
  std::vector<std::vector<int>> pat_sigma_index;
  Eigen::Matrix<double, -1, 1> y;
  Eigen::Matrix<double, -1, -1> Q;
  Eigen::Matrix<double, -1, -1> R;
  std::vector<Eigen::Matrix<double, -1, -1>> Sigma_init;
  Eigen::Matrix<double, -1, -1> R_inverse;
 
public:
  ~model_MMRM() { }
  
  inline std::string model_name() const final { return "model_MMRM"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_MMRM(stan::io::var_context& context__,
             unsigned int random_seed__ = 0,
             std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_MMRM_namespace::model_MMRM";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 29;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 29;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 29;
      current_statement__ = 29;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 30;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 30;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 30;
      current_statement__ = 30;
      check_greater_or_equal(function__, "P", P, 1);
      current_statement__ = 31;
      context__.validate_dims("data initialization","G","int",
          context__.to_vec());
      G = std::numeric_limits<int>::min();
      
      current_statement__ = 31;
      G = context__.vals_i("G")[(1 - 1)];
      current_statement__ = 31;
      current_statement__ = 31;
      check_greater_or_equal(function__, "G", G, 1);
      current_statement__ = 32;
      context__.validate_dims("data initialization","n_visit","int",
          context__.to_vec());
      n_visit = std::numeric_limits<int>::min();
      
      current_statement__ = 32;
      n_visit = context__.vals_i("n_visit")[(1 - 1)];
      current_statement__ = 32;
      current_statement__ = 32;
      check_greater_or_equal(function__, "n_visit", n_visit, 1);
      current_statement__ = 33;
      context__.validate_dims("data initialization","n_pat","int",
          context__.to_vec());
      n_pat = std::numeric_limits<int>::min();
      
      current_statement__ = 33;
      n_pat = context__.vals_i("n_pat")[(1 - 1)];
      current_statement__ = 33;
      current_statement__ = 33;
      check_greater_or_equal(function__, "n_pat", n_pat, 1);
      current_statement__ = 34;
      validate_non_negative_index("pat_G", "n_pat", n_pat);
      current_statement__ = 35;
      context__.validate_dims("data initialization","pat_G","int",
          context__.to_vec(n_pat));
      pat_G = std::vector<int>(n_pat, std::numeric_limits<int>::min());
      
      current_statement__ = 35;
      assign(pat_G, nil_index_list(), context__.vals_i("pat_G"),
        "assigning variable pat_G");
      current_statement__ = 35;
      for (int sym1__ = 1; sym1__ <= n_pat; ++sym1__) {
        current_statement__ = 35;
        current_statement__ = 35;
        check_greater_or_equal(function__, "pat_G[sym1__]",
                               pat_G[(sym1__ - 1)], 1);}
      current_statement__ = 36;
      validate_non_negative_index("pat_n_pt", "n_pat", n_pat);
      current_statement__ = 37;
      context__.validate_dims("data initialization","pat_n_pt","int",
          context__.to_vec(n_pat));
      pat_n_pt = std::vector<int>(n_pat, std::numeric_limits<int>::min());
      
      current_statement__ = 37;
      assign(pat_n_pt, nil_index_list(), context__.vals_i("pat_n_pt"),
        "assigning variable pat_n_pt");
      current_statement__ = 37;
      for (int sym1__ = 1; sym1__ <= n_pat; ++sym1__) {
        current_statement__ = 37;
        current_statement__ = 37;
        check_greater_or_equal(function__, "pat_n_pt[sym1__]",
                               pat_n_pt[(sym1__ - 1)], 1);}
      current_statement__ = 38;
      validate_non_negative_index("pat_n_visit", "n_pat", n_pat);
      current_statement__ = 39;
      context__.validate_dims("data initialization","pat_n_visit","int",
          context__.to_vec(n_pat));
      pat_n_visit = std::vector<int>(n_pat, std::numeric_limits<int>::min());
      
      current_statement__ = 39;
      assign(pat_n_visit, nil_index_list(), context__.vals_i("pat_n_visit"),
        "assigning variable pat_n_visit");
      current_statement__ = 39;
      for (int sym1__ = 1; sym1__ <= n_pat; ++sym1__) {
        current_statement__ = 39;
        current_statement__ = 39;
        check_greater_or_equal(function__, "pat_n_visit[sym1__]",
                               pat_n_visit[(sym1__ - 1)], 1);}
      current_statement__ = 40;
      validate_non_negative_index("pat_sigma_index", "n_pat", n_pat);
      current_statement__ = 41;
      validate_non_negative_index("pat_sigma_index", "n_visit", n_visit);
      current_statement__ = 42;
      context__.validate_dims("data initialization","pat_sigma_index","int",
          context__.to_vec(n_pat, n_visit));
      pat_sigma_index = std::vector<std::vector<int>>(n_pat, std::vector<int>(n_visit, std::numeric_limits<int>::min()));
      
      {
        std::vector<int> pat_sigma_index_flat__;
        current_statement__ = 42;
        assign(pat_sigma_index_flat__, nil_index_list(),
          context__.vals_i("pat_sigma_index"),
          "assigning variable pat_sigma_index_flat__");
        current_statement__ = 42;
        pos__ = 1;
        current_statement__ = 42;
        for (int sym1__ = 1; sym1__ <= n_visit; ++sym1__) {
          current_statement__ = 42;
          for (int sym2__ = 1; sym2__ <= n_pat; ++sym2__) {
            current_statement__ = 42;
            assign(pat_sigma_index,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              pat_sigma_index_flat__[(pos__ - 1)],
              "assigning variable pat_sigma_index");
            current_statement__ = 42;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 42;
      for (int sym1__ = 1; sym1__ <= n_pat; ++sym1__) {
        current_statement__ = 42;
        for (int sym2__ = 1; sym2__ <= n_visit; ++sym2__) {
          current_statement__ = 42;
          current_statement__ = 42;
          check_greater_or_equal(function__,
                                 "pat_sigma_index[sym1__, sym2__]",
                                 pat_sigma_index[(sym1__ - 1)][(sym2__ - 1)],
                                 1);}}
      current_statement__ = 43;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 44;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 44;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 44;
        pos__ = 1;
        current_statement__ = 44;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 44;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 44;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 45;
      validate_non_negative_index("Q", "N", N);
      current_statement__ = 46;
      validate_non_negative_index("Q", "P", P);
      current_statement__ = 47;
      context__.validate_dims("data initialization","Q","double",
          context__.to_vec(N, P));
      Q = Eigen::Matrix<double, -1, -1>(N, P);
      stan::math::fill(Q, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Q_flat__;
        current_statement__ = 47;
        assign(Q_flat__, nil_index_list(), context__.vals_r("Q"),
          "assigning variable Q_flat__");
        current_statement__ = 47;
        pos__ = 1;
        current_statement__ = 47;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 47;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 47;
            assign(Q,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Q_flat__[(pos__ - 1)], "assigning variable Q");
            current_statement__ = 47;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 48;
      validate_non_negative_index("R", "P", P);
      current_statement__ = 49;
      validate_non_negative_index("R", "P", P);
      current_statement__ = 50;
      context__.validate_dims("data initialization","R","double",
          context__.to_vec(P, P));
      R = Eigen::Matrix<double, -1, -1>(P, P);
      stan::math::fill(R, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> R_flat__;
        current_statement__ = 50;
        assign(R_flat__, nil_index_list(), context__.vals_r("R"),
          "assigning variable R_flat__");
        current_statement__ = 50;
        pos__ = 1;
        current_statement__ = 50;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 50;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 50;
            assign(R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              R_flat__[(pos__ - 1)], "assigning variable R");
            current_statement__ = 50;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 51;
      validate_non_negative_index("Sigma_init", "G", G);
      current_statement__ = 52;
      validate_non_negative_index("Sigma_init", "n_visit", n_visit);
      current_statement__ = 53;
      validate_non_negative_index("Sigma_init", "n_visit", n_visit);
      current_statement__ = 54;
      context__.validate_dims("data initialization","Sigma_init","double",
          context__.to_vec(G, n_visit, n_visit));
      Sigma_init = std::vector<Eigen::Matrix<double, -1, -1>>(G, Eigen::Matrix<double, -1, -1>(n_visit, n_visit));
      stan::math::fill(Sigma_init, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Sigma_init_flat__;
        current_statement__ = 54;
        assign(Sigma_init_flat__, nil_index_list(),
          context__.vals_r("Sigma_init"),
          "assigning variable Sigma_init_flat__");
        current_statement__ = 54;
        pos__ = 1;
        current_statement__ = 54;
        for (int sym1__ = 1; sym1__ <= n_visit; ++sym1__) {
          current_statement__ = 54;
          for (int sym2__ = 1; sym2__ <= n_visit; ++sym2__) {
            current_statement__ = 54;
            for (int sym3__ = 1; sym3__ <= G; ++sym3__) {
              current_statement__ = 54;
              assign(Sigma_init,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                Sigma_init_flat__[(pos__ - 1)],
                "assigning variable Sigma_init");
              current_statement__ = 54;
              pos__ = (pos__ + 1);}}}
      }
      current_statement__ = 55;
      validate_non_negative_index("R_inverse", "P", P);
      current_statement__ = 56;
      validate_non_negative_index("R_inverse", "P", P);
      current_statement__ = 57;
      R_inverse = Eigen::Matrix<double, -1, -1>(P, P);
      stan::math::fill(R_inverse, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 57;
      assign(R_inverse, nil_index_list(), inverse(R),
        "assigning variable R_inverse");
      current_statement__ = 58;
      validate_non_negative_index("theta", "P", P);
      current_statement__ = 59;
      validate_non_negative_index("Sigma", "G", G);
      current_statement__ = 60;
      validate_non_negative_index("Sigma", "n_visit", n_visit);
      current_statement__ = 60;
      validate_non_negative_index("Sigma", "n_visit", n_visit);
      current_statement__ = 61;
      validate_non_negative_index("beta", "P", P);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += P;
      num_params_r__ += G * (n_visit + ((n_visit * (n_visit - 1)) / 2));
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_MMRM_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, 1>(P);
      stan::math::fill(theta, DUMMY_VAR__);
      
      current_statement__ = 1;
      theta = in__.vector(P);
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> Sigma;
      Sigma = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(G, Eigen::Matrix<local_scalar_t__, -1, -1>(n_visit, n_visit));
      stan::math::fill(Sigma, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> Sigma_in__;
      Sigma_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(G, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (n_visit + ((n_visit * (n_visit - 1)) / 2))));
      stan::math::fill(Sigma_in__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        current_statement__ = 2;
        assign(Sigma_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((n_visit + ((n_visit * (n_visit - 1)) / 2))),
          "assigning variable Sigma_in__");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(Sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(Sigma_in__[(sym1__ - 1)],
              n_visit, lp__), "assigning variable Sigma");
        } else {
          current_statement__ = 2;
          assign(Sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(Sigma_in__[(sym1__ - 1)],
              n_visit), "assigning variable Sigma");
        }}
      {
        int data_start_row;
        data_start_row = std::numeric_limits<int>::min();
        
        current_statement__ = 4;
        data_start_row = 1;
        current_statement__ = 5;
        validate_non_negative_index("mu", "N", N);
        Eigen::Matrix<local_scalar_t__, -1, 1> mu;
        mu = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
        stan::math::fill(mu, DUMMY_VAR__);
        
        current_statement__ = 6;
        assign(mu, nil_index_list(), multiply(Q, theta),
          "assigning variable mu");
        current_statement__ = 9;
        for (int g = 1; g <= G; ++g) {
          current_statement__ = 7;
          lp_accum__.add(
            inv_wishart_lpdf<propto__>(Sigma[(g - 1)], (n_visit + 2),
              Sigma_init[(g - 1)]));}
        current_statement__ = 28;
        for (int i = 1; i <= n_pat; ++i) {
          int nvis;
          nvis = std::numeric_limits<int>::min();
          
          current_statement__ = 10;
          nvis = pat_n_visit[(i - 1)];
          int npt;
          npt = std::numeric_limits<int>::min();
          
          current_statement__ = 11;
          npt = pat_n_pt[(i - 1)];
          int g;
          g = std::numeric_limits<int>::min();
          
          current_statement__ = 12;
          g = pat_G[(i - 1)];
          current_statement__ = 13;
          validate_non_negative_index("sig_index", "nvis", nvis);
          std::vector<int> sig_index;
          sig_index = std::vector<int>(nvis, std::numeric_limits<int>::min());
          
          current_statement__ = 14;
          assign(sig_index, nil_index_list(),
            rvalue(pat_sigma_index,
              cons_list(index_uni(i),
                cons_list(index_min_max(1, nvis), nil_index_list())),
              "pat_sigma_index"), "assigning variable sig_index");
          current_statement__ = 15;
          validate_non_negative_index("sig", "nvis", nvis);
          current_statement__ = 16;
          validate_non_negative_index("sig", "nvis", nvis);
          Eigen::Matrix<local_scalar_t__, -1, -1> sig;
          sig = Eigen::Matrix<local_scalar_t__, -1, -1>(nvis, nvis);
          stan::math::fill(sig, DUMMY_VAR__);
          
          current_statement__ = 17;
          assign(sig, nil_index_list(),
            rvalue(Sigma[(g - 1)],
              cons_list(index_multi(sig_index),
                cons_list(index_multi(sig_index), nil_index_list())),
              "Sigma[g]"), "assigning variable sig");
          int data_stop_row;
          data_stop_row = std::numeric_limits<int>::min();
          
          current_statement__ = 18;
          data_stop_row = (data_start_row + ((nvis * npt) - 1));
          current_statement__ = 19;
          validate_non_negative_index("y_obs", "npt", npt);
          current_statement__ = 20;
          validate_non_negative_index("y_obs", "nvis", nvis);
          std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> y_obs;
          y_obs = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(npt, Eigen::Matrix<local_scalar_t__, -1, 1>(nvis));
          stan::math::fill(y_obs, DUMMY_VAR__);
          
          current_statement__ = 21;
          assign(y_obs, nil_index_list(),
            to_vector_of_arrays(
              rvalue(y,
                cons_list(index_min_max(data_start_row, data_stop_row),
                  nil_index_list()), "y"), nvis, pstream__),
            "assigning variable y_obs");
          current_statement__ = 22;
          validate_non_negative_index("mu_obs", "npt", npt);
          current_statement__ = 23;
          validate_non_negative_index("mu_obs", "nvis", nvis);
          std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> mu_obs;
          mu_obs = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(npt, Eigen::Matrix<local_scalar_t__, -1, 1>(nvis));
          stan::math::fill(mu_obs, DUMMY_VAR__);
          
          current_statement__ = 24;
          assign(mu_obs, nil_index_list(),
            to_vector_of_arrays(
              rvalue(mu,
                cons_list(index_min_max(data_start_row, data_stop_row),
                  nil_index_list()), "mu"), nvis, pstream__),
            "assigning variable mu_obs");
          current_statement__ = 25;
          lp_accum__.add(multi_normal_lpdf<propto__>(y_obs, mu_obs, sig));
          current_statement__ = 26;
          data_start_row = (data_stop_row + 1);}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_MMRM_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> theta;
      theta = Eigen::Matrix<double, -1, 1>(P);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      theta = in__.vector(P);
      std::vector<Eigen::Matrix<double, -1, -1>> Sigma;
      Sigma = std::vector<Eigen::Matrix<double, -1, -1>>(G, Eigen::Matrix<double, -1, -1>(n_visit, n_visit));
      stan::math::fill(Sigma, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> Sigma_in__;
      Sigma_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(G, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (n_visit + ((n_visit * (n_visit - 1)) / 2))));
      stan::math::fill(Sigma_in__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        current_statement__ = 2;
        assign(Sigma_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((n_visit + ((n_visit * (n_visit - 1)) / 2))),
          "assigning variable Sigma_in__");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        current_statement__ = 2;
        assign(Sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_constrain(Sigma_in__[(sym1__ - 1)], n_visit),
          "assigning variable Sigma");}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        vars__.emplace_back(theta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_visit; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= n_visit; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= G; ++sym3__) {
            vars__.emplace_back(
              rvalue(Sigma,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "Sigma"));}}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(P);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(beta, nil_index_list(), multiply(R_inverse, theta),
        "assigning variable beta");
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> theta;
      theta = Eigen::Matrix<double, -1, 1>(P);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_flat__;
        current_statement__ = 1;
        assign(theta_flat__, nil_index_list(), context__.vals_r("theta"),
          "assigning variable theta_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 1;
          assign(theta, cons_list(index_uni(sym1__), nil_index_list()),
            theta_flat__[(pos__ - 1)], "assigning variable theta");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      std::vector<Eigen::Matrix<double, -1, -1>> Sigma;
      Sigma = std::vector<Eigen::Matrix<double, -1, -1>>(G, Eigen::Matrix<double, -1, -1>(n_visit, n_visit));
      stan::math::fill(Sigma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Sigma_flat__;
        current_statement__ = 2;
        assign(Sigma_flat__, nil_index_list(), context__.vals_r("Sigma"),
          "assigning variable Sigma_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= n_visit; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= n_visit; ++sym2__) {
            current_statement__ = 2;
            for (int sym3__ = 1; sym3__ <= G; ++sym3__) {
              current_statement__ = 2;
              assign(Sigma,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                Sigma_flat__[(pos__ - 1)], "assigning variable Sigma");
              current_statement__ = 2;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> Sigma_free__;
      Sigma_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(G, Eigen::Matrix<double, -1, 1>(
        (n_visit + ((n_visit * (n_visit - 1)) / 2))));
      stan::math::fill(Sigma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        current_statement__ = 2;
        assign(Sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_free(Sigma[(sym1__ - 1)]),
          "assigning variable Sigma_free__");}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        vars__.emplace_back(theta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        for (int sym2__ = 1;
             sym2__ <= (n_visit + ((n_visit * (n_visit - 1)) / 2)); ++sym2__) {
          vars__.emplace_back(Sigma_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("theta");
    names__.emplace_back("Sigma");
    names__.emplace_back("beta");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(G),
                                             static_cast<size_t>(n_visit),
                                             static_cast<size_t>(n_visit)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_visit; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= n_visit; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= G; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "Sigma" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1;
         sym1__ <= (n_visit + ((n_visit * (n_visit - 1)) / 2)); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= G; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "Sigma" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"theta\",\"type\":{\"name\":\"vector\",\"length\":" << P << "},\"block\":\"parameters\"},{\"name\":\"Sigma\",\"type\":{\"name\":\"array\",\"length\":" << G << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << n_visit << ",\"cols\":" << n_visit << "}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << P << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"theta\",\"type\":{\"name\":\"vector\",\"length\":" << P << "},\"block\":\"parameters\"},{\"name\":\"Sigma\",\"type\":{\"name\":\"array\",\"length\":" << G << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (n_visit + ((n_visit * (n_visit - 1)) / 2)) << "}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << P << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_MMRM_namespace::model_MMRM;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_MMRM_namespace::profiles__;
}
#endif
#endif
