// Generated by rstantools.  Do not edit by hand.

/*
    rbmi is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rbmi is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rbmi.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_MMRM_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_MMRM");
    reader.add_event(97, 95, "end", "model_MMRM");
    return reader;
}
int
integer_division(const int& a,
                     const int& b, std::ostream* pstream__) {
    typedef double local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        int i(0);
        (void) i;  // dummy to suppress unused var warning
        stan::math::fill(i, std::numeric_limits<int>::min());
        stan::math::assign(i,0);
        current_statement_begin__ = 5;
        while (as_bool(logical_lte((b * (i + 1)), a))) {
            current_statement_begin__ = 6;
            stan::math::assign(i, (i + 1));
        }
        current_statement_begin__ = 8;
        return stan::math::promote_scalar<fun_return_scalar_t__>(i);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct integer_division_functor__ {
            int
    operator()(const int& a,
                     const int& b, std::ostream* pstream__) const {
        return integer_division(a, b, pstream__);
    }
};
template <typename T0__>
std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1> >
to_vector_of_arrays(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& vec,
                        const int& length_array, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 14;
        validate_non_negative_index("res", "length_array", length_array);
        validate_non_negative_index("res", "integer_division(num_elements(vec), length_array, pstream__)", integer_division(num_elements(vec), length_array, pstream__));
        std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>  > res(integer_division(num_elements(vec), length_array, pstream__), Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(length_array));
        stan::math::initialize(res, DUMMY_VAR__);
        stan::math::fill(res, DUMMY_VAR__);
        current_statement_begin__ = 16;
        int j(0);
        (void) j;  // dummy to suppress unused var warning
        stan::math::fill(j, std::numeric_limits<int>::min());
        stan::math::assign(j,1);
        current_statement_begin__ = 17;
        int i(0);
        (void) i;  // dummy to suppress unused var warning
        stan::math::fill(i, std::numeric_limits<int>::min());
        stan::math::assign(i,1);
        current_statement_begin__ = 18;
        while (as_bool(logical_lte(j, num_elements(vec)))) {
            current_statement_begin__ = 19;
            stan::model::assign(res, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        stan::model::rvalue(vec, stan::model::cons_list(stan::model::index_min_max(j, ((j + length_array) - 1)), stan::model::nil_index_list()), "vec"), 
                        "assigning variable res");
            current_statement_begin__ = 20;
            stan::math::assign(i, (i + 1));
            current_statement_begin__ = 21;
            stan::math::assign(j, (j + length_array));
        }
        current_statement_begin__ = 23;
        return stan::math::promote_scalar<fun_return_scalar_t__>(res);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct to_vector_of_arrays_functor__ {
    template <typename T0__>
        std::vector<Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, 1> >
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& vec,
                        const int& length_array, std::ostream* pstream__) const {
        return to_vector_of_arrays(vec, length_array, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_MMRM
  : public stan::model::model_base_crtp<model_MMRM> {
private:
        int N;
        int P;
        int G;
        int n_visit;
        int n_pat;
        std::vector<int> pat_G;
        std::vector<int> pat_n_pt;
        std::vector<int> pat_n_visit;
        std::vector<std::vector<int> > pat_sigma_index;
        vector_d y;
        matrix_d Q;
        matrix_d R;
        std::vector<matrix_d> Sigma_init;
        matrix_d R_inverse;
public:
    model_MMRM(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_MMRM(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_MMRM_namespace::model_MMRM";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 1);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "G", "int", context__.to_vec());
            G = int(0);
            vals_i__ = context__.vals_i("G");
            pos__ = 0;
            G = vals_i__[pos__++];
            check_greater_or_equal(function__, "G", G, 1);
            current_statement_begin__ = 32;
            context__.validate_dims("data initialization", "n_visit", "int", context__.to_vec());
            n_visit = int(0);
            vals_i__ = context__.vals_i("n_visit");
            pos__ = 0;
            n_visit = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_visit", n_visit, 1);
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "n_pat", "int", context__.to_vec());
            n_pat = int(0);
            vals_i__ = context__.vals_i("n_pat");
            pos__ = 0;
            n_pat = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_pat", n_pat, 1);
            current_statement_begin__ = 35;
            validate_non_negative_index("pat_G", "n_pat", n_pat);
            context__.validate_dims("data initialization", "pat_G", "int", context__.to_vec(n_pat));
            pat_G = std::vector<int>(n_pat, int(0));
            vals_i__ = context__.vals_i("pat_G");
            pos__ = 0;
            size_t pat_G_k_0_max__ = n_pat;
            for (size_t k_0__ = 0; k_0__ < pat_G_k_0_max__; ++k_0__) {
                pat_G[k_0__] = vals_i__[pos__++];
            }
            size_t pat_G_i_0_max__ = n_pat;
            for (size_t i_0__ = 0; i_0__ < pat_G_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pat_G[i_0__]", pat_G[i_0__], 1);
            }
            current_statement_begin__ = 36;
            validate_non_negative_index("pat_n_pt", "n_pat", n_pat);
            context__.validate_dims("data initialization", "pat_n_pt", "int", context__.to_vec(n_pat));
            pat_n_pt = std::vector<int>(n_pat, int(0));
            vals_i__ = context__.vals_i("pat_n_pt");
            pos__ = 0;
            size_t pat_n_pt_k_0_max__ = n_pat;
            for (size_t k_0__ = 0; k_0__ < pat_n_pt_k_0_max__; ++k_0__) {
                pat_n_pt[k_0__] = vals_i__[pos__++];
            }
            size_t pat_n_pt_i_0_max__ = n_pat;
            for (size_t i_0__ = 0; i_0__ < pat_n_pt_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pat_n_pt[i_0__]", pat_n_pt[i_0__], 1);
            }
            current_statement_begin__ = 37;
            validate_non_negative_index("pat_n_visit", "n_pat", n_pat);
            context__.validate_dims("data initialization", "pat_n_visit", "int", context__.to_vec(n_pat));
            pat_n_visit = std::vector<int>(n_pat, int(0));
            vals_i__ = context__.vals_i("pat_n_visit");
            pos__ = 0;
            size_t pat_n_visit_k_0_max__ = n_pat;
            for (size_t k_0__ = 0; k_0__ < pat_n_visit_k_0_max__; ++k_0__) {
                pat_n_visit[k_0__] = vals_i__[pos__++];
            }
            size_t pat_n_visit_i_0_max__ = n_pat;
            for (size_t i_0__ = 0; i_0__ < pat_n_visit_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pat_n_visit[i_0__]", pat_n_visit[i_0__], 1);
            }
            current_statement_begin__ = 38;
            validate_non_negative_index("pat_sigma_index", "n_pat", n_pat);
            validate_non_negative_index("pat_sigma_index", "n_visit", n_visit);
            context__.validate_dims("data initialization", "pat_sigma_index", "int", context__.to_vec(n_pat,n_visit));
            pat_sigma_index = std::vector<std::vector<int> >(n_pat, std::vector<int>(n_visit, int(0)));
            vals_i__ = context__.vals_i("pat_sigma_index");
            pos__ = 0;
            size_t pat_sigma_index_k_0_max__ = n_pat;
            size_t pat_sigma_index_k_1_max__ = n_visit;
            for (size_t k_1__ = 0; k_1__ < pat_sigma_index_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < pat_sigma_index_k_0_max__; ++k_0__) {
                    pat_sigma_index[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t pat_sigma_index_i_0_max__ = n_pat;
            size_t pat_sigma_index_i_1_max__ = n_visit;
            for (size_t i_0__ = 0; i_0__ < pat_sigma_index_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < pat_sigma_index_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "pat_sigma_index[i_0__][i_1__]", pat_sigma_index[i_0__][i_1__], 1);
                }
            }
            current_statement_begin__ = 40;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 41;
            validate_non_negative_index("Q", "N", N);
            validate_non_negative_index("Q", "P", P);
            context__.validate_dims("data initialization", "Q", "matrix_d", context__.to_vec(N,P));
            Q = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, P);
            vals_r__ = context__.vals_r("Q");
            pos__ = 0;
            size_t Q_j_2_max__ = P;
            size_t Q_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < Q_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Q_j_1_max__; ++j_1__) {
                    Q(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 42;
            validate_non_negative_index("R", "P", P);
            validate_non_negative_index("R", "P", P);
            context__.validate_dims("data initialization", "R", "matrix_d", context__.to_vec(P,P));
            R = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(P, P);
            vals_r__ = context__.vals_r("R");
            pos__ = 0;
            size_t R_j_2_max__ = P;
            size_t R_j_1_max__ = P;
            for (size_t j_2__ = 0; j_2__ < R_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                    R(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 43;
            validate_non_negative_index("Sigma_init", "n_visit", n_visit);
            validate_non_negative_index("Sigma_init", "n_visit", n_visit);
            validate_non_negative_index("Sigma_init", "G", G);
            context__.validate_dims("data initialization", "Sigma_init", "matrix_d", context__.to_vec(G,n_visit,n_visit));
            Sigma_init = std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> >(G, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_visit, n_visit));
            vals_r__ = context__.vals_r("Sigma_init");
            pos__ = 0;
            size_t Sigma_init_j_2_max__ = n_visit;
            size_t Sigma_init_j_1_max__ = n_visit;
            size_t Sigma_init_k_0_max__ = G;
            for (size_t j_2__ = 0; j_2__ < Sigma_init_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Sigma_init_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < Sigma_init_k_0_max__; ++k_0__) {
                        Sigma_init[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                    }
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 48;
            validate_non_negative_index("R_inverse", "P", P);
            validate_non_negative_index("R_inverse", "P", P);
            R_inverse = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(P, P);
            stan::math::fill(R_inverse, DUMMY_VAR__);
            stan::math::assign(R_inverse,inverse(R));
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 54;
            validate_non_negative_index("theta", "P", P);
            num_params_r__ += P;
            current_statement_begin__ = 55;
            validate_non_negative_index("Sigma", "n_visit", n_visit);
            validate_non_negative_index("Sigma", "n_visit", n_visit);
            validate_non_negative_index("Sigma", "G", G);
            num_params_r__ += ((n_visit + ((n_visit * (n_visit - 1)) / 2)) * G);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_MMRM() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 54;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "P", P);
        context__.validate_dims("parameter initialization", "theta", "vector_d", context__.to_vec(P));
        Eigen::Matrix<double, Eigen::Dynamic, 1> theta(P);
        size_t theta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            theta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 55;
        if (!(context__.contains_r("Sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable Sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("Sigma");
        pos__ = 0U;
        validate_non_negative_index("Sigma", "n_visit", n_visit);
        validate_non_negative_index("Sigma", "n_visit", n_visit);
        validate_non_negative_index("Sigma", "G", G);
        context__.validate_dims("parameter initialization", "Sigma", "matrix_d", context__.to_vec(G,n_visit,n_visit));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > Sigma(G, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_visit, n_visit));
        size_t Sigma_j_2_max__ = n_visit;
        size_t Sigma_j_1_max__ = n_visit;
        size_t Sigma_k_0_max__ = G;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < Sigma_k_0_max__; ++k_0__) {
                    Sigma[k_0__](j_1__, j_2__) = vals_r__[pos__++];
                }
            }
        }
        size_t Sigma_i_0_max__ = G;
        for (size_t i_0__ = 0; i_0__ < Sigma_i_0_max__; ++i_0__) {
            try {
                writer__.cov_matrix_unconstrain(Sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable Sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 54;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.vector_constrain(P, lp__);
            else
                theta = in__.vector_constrain(P);
            current_statement_begin__ = 55;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > Sigma;
            size_t Sigma_d_0_max__ = G;
            Sigma.reserve(Sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < Sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    Sigma.push_back(in__.cov_matrix_constrain(n_visit, lp__));
                else
                    Sigma.push_back(in__.cov_matrix_constrain(n_visit));
            }
            // model body
            {
            current_statement_begin__ = 60;
            int data_start_row(0);
            (void) data_start_row;  // dummy to suppress unused var warning
            stan::math::fill(data_start_row, std::numeric_limits<int>::min());
            stan::math::assign(data_start_row,1);
            current_statement_begin__ = 62;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            stan::math::assign(mu,multiply(Q, theta));
            current_statement_begin__ = 64;
            for (int g = 1; g <= G; ++g) {
                current_statement_begin__ = 65;
                lp_accum__.add(inv_wishart_log<propto__>(get_base1(Sigma, g, "Sigma", 1), (n_visit + 2), get_base1(Sigma_init, g, "Sigma_init", 1)));
            }
            current_statement_begin__ = 68;
            for (int i = 1; i <= n_pat; ++i) {
                {
                current_statement_begin__ = 70;
                int nvis(0);
                (void) nvis;  // dummy to suppress unused var warning
                stan::math::fill(nvis, std::numeric_limits<int>::min());
                stan::math::assign(nvis,get_base1(pat_n_visit, i, "pat_n_visit", 1));
                current_statement_begin__ = 71;
                int npt(0);
                (void) npt;  // dummy to suppress unused var warning
                stan::math::fill(npt, std::numeric_limits<int>::min());
                stan::math::assign(npt,get_base1(pat_n_pt, i, "pat_n_pt", 1));
                current_statement_begin__ = 72;
                int g(0);
                (void) g;  // dummy to suppress unused var warning
                stan::math::fill(g, std::numeric_limits<int>::min());
                stan::math::assign(g,get_base1(pat_G, i, "pat_G", 1));
                current_statement_begin__ = 75;
                validate_non_negative_index("sig_index", "nvis", nvis);
                std::vector<int  > sig_index(nvis, int(0));
                stan::math::fill(sig_index, std::numeric_limits<int>::min());
                stan::math::assign(sig_index,stan::model::rvalue(pat_sigma_index, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_min_max(1, nvis), stan::model::nil_index_list())), "pat_sigma_index"));
                current_statement_begin__ = 76;
                validate_non_negative_index("sig", "nvis", nvis);
                validate_non_negative_index("sig", "nvis", nvis);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> sig(nvis, nvis);
                stan::math::initialize(sig, DUMMY_VAR__);
                stan::math::fill(sig, DUMMY_VAR__);
                stan::math::assign(sig,stan::model::rvalue(get_base1(Sigma, g, "Sigma", 1), stan::model::cons_list(stan::model::index_multi(sig_index), stan::model::cons_list(stan::model::index_multi(sig_index), stan::model::nil_index_list())), "Sigma[g]"));
                current_statement_begin__ = 79;
                int data_stop_row(0);
                (void) data_stop_row;  // dummy to suppress unused var warning
                stan::math::fill(data_stop_row, std::numeric_limits<int>::min());
                stan::math::assign(data_stop_row,(data_start_row + ((nvis * npt) - 1)));
                current_statement_begin__ = 82;
                validate_non_negative_index("y_obs", "nvis", nvis);
                validate_non_negative_index("y_obs", "npt", npt);
                std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>  > y_obs(npt, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nvis));
                stan::math::initialize(y_obs, DUMMY_VAR__);
                stan::math::fill(y_obs, DUMMY_VAR__);
                stan::math::assign(y_obs,to_vector_of_arrays(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_min_max(data_start_row, data_stop_row), stan::model::nil_index_list()), "y"), nvis, pstream__));
                current_statement_begin__ = 83;
                validate_non_negative_index("mu_obs", "nvis", nvis);
                validate_non_negative_index("mu_obs", "npt", npt);
                std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>  > mu_obs(npt, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nvis));
                stan::math::initialize(mu_obs, DUMMY_VAR__);
                stan::math::fill(mu_obs, DUMMY_VAR__);
                stan::math::assign(mu_obs,to_vector_of_arrays(stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_min_max(data_start_row, data_stop_row), stan::model::nil_index_list()), "mu"), nvis, pstream__));
                current_statement_begin__ = 85;
                lp_accum__.add(multi_normal_log<propto__>(y_obs, mu_obs, sig));
                current_statement_begin__ = 88;
                stan::math::assign(data_start_row, (data_stop_row + 1));
                }
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("theta");
        names__.push_back("Sigma");
        names__.push_back("beta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(P);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(G);
        dims__.push_back(n_visit);
        dims__.push_back(n_visit);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_MMRM_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> theta = in__.vector_constrain(P);
        size_t theta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            vars__.push_back(theta(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > Sigma;
        size_t Sigma_d_0_max__ = G;
        Sigma.reserve(Sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < Sigma_d_0_max__; ++d_0__) {
            Sigma.push_back(in__.cov_matrix_constrain(n_visit));
        }
        size_t Sigma_j_2_max__ = n_visit;
        size_t Sigma_j_1_max__ = n_visit;
        size_t Sigma_k_0_max__ = G;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < Sigma_k_0_max__; ++k_0__) {
                    vars__.push_back(Sigma[k_0__](j_1__, j_2__));
                }
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 94;
            validate_non_negative_index("beta", "P", P);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta(P);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            stan::math::assign(beta,multiply(R_inverse, theta));
            // validate, write generated quantities
            current_statement_begin__ = 94;
            size_t beta_j_1_max__ = P;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                vars__.push_back(beta(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_MMRM";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Sigma_j_2_max__ = n_visit;
        size_t Sigma_j_1_max__ = n_visit;
        size_t Sigma_k_0_max__ = G;
        for (size_t j_2__ = 0; j_2__ < Sigma_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < Sigma_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t beta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t Sigma_j_1_max__ = (n_visit + ((n_visit * (n_visit - 1)) / 2));
        size_t Sigma_k_0_max__ = G;
        for (size_t j_1__ = 0; j_1__ < Sigma_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < Sigma_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Sigma" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t beta_j_1_max__ = P;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_MMRM_namespace::model_MMRM stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
