% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biorxiv_publisher.R
\name{biorxiv_publisher}
\alias{biorxiv_publisher}
\title{Retrieve details of published articles with bioRxiv preprints by a specific
publisher}
\usage{
biorxiv_publisher(
  prefix = NULL,
  from = NULL,
  to = NULL,
  limit = 100,
  skip = 0,
  format = "list"
)
}
\arguments{
\item{prefix}{(character) The prefix of a digital object identifier (DOI)
associated with a publisher. Default: \code{NULL}}

\item{from}{(date) The date from when details of published articles should
be collected. Date must be supplied in \code{YYYY-MM-DD} format. Default: \code{NULL}}

\item{to}{(date) The date until when details of published articles should
be collected. Date must be supplied in \code{YYYY-MM-DD} format. Default: \code{NULL}}

\item{limit}{(integer) The maximum number of results to return. Not
relevant when querying a doi. Default: \code{100}}

\item{skip}{(integer) The number of results to skip in a query.
Default: \code{0}}

\item{format}{(character) Return data in list \code{list}, json \code{json} or data
frame \code{df} format. Default: \code{list}}
}
\description{
Retrieve details of published articles with bioRxiv preprints by a specific
publisher
}
\examples{
\donttest{

# Get details of articles published by eLife (doi prefix = 10.7554)
# between 2018-01-01 and 2018-01-30
# By default, only the first 100 records are returned
biorxiv_publisher(prefix = "10.7554", from = "2017-01-01", to = "2018-01-01")

# Set a limit to return more than 100 records
biorxiv_publisher(prefix = "10.7554", from = "2017-01-01", to = "2018-01-01",
                  limit = 200)

# Set limit as "*" to return all records
biorxiv_publisher(prefix = "10.7554", from = "2017-01-01", to = "2018-01-01",
                  limit = "*")

# Skip the first 100 records
biorxiv_publisher(prefix = "10.7554", from = "2017-01-01", to = "2018-01-01",
                  limit = 200, skip = 100)

# Specify the format to return data
biorxiv_publisher(prefix = "10.7554", from = "2017-01-01", to = "2018-01-01",
                  format = "df")
}
}
