% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.div.r
\name{beta.div}
\alias{beta.div}
\title{Make a distance matrix of samples vs samples.}
\usage{
beta.div(biom, method, weighted = TRUE, tree = NULL)
}
\arguments{
\item{biom}{A \code{matrix}, \code{simple_triplet_matrix}, or \code{BIOM} 
object, as returned from \link{read.biom}. For matrices, the rows and 
columns are assumed to be the taxa and samples, respectively.}

\item{method}{The distance algorithm to use. Options are:
\bold{\dQuote{manhattan}}, \bold{\dQuote{euclidean}}, 
\bold{\dQuote{bray-curtis}}, \bold{\dQuote{jaccard}}, and
\bold{\dQuote{unifrac}}. Non-ambiguous abbrevations of the method 
names are also accepted. A phylogentic tree must be present in 
\code{biom} or explicitly provided via \code{tree=} to use the UniFrac methods.}

\item{weighted}{Take relative abundances into account. When 
\code{weighted=FALSE}, only presence/absence is considered.}

\item{tree}{A \code{phylo} object representing the phylogenetic
relationships of the taxa in \code{biom}. Will be taken from the tree
embedded in the \code{biom} object if not explicitly specified. Only
required for computing UniFrac distance matrices.}
}
\value{
A distance matrix.
}
\description{
Make a distance matrix of samples vs samples.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "hmp50.bz2", package = "rbiom")
    biom <- read.biom(infile)
    biom <- select(biom, 1:10)
    
    dm <- beta.div(biom, 'unifrac')
    
    as.matrix(dm)[1:4,1:4]
    plot(hclust(dm))

}
