% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_proteins_crossref}
\alias{rba_uniprot_proteins_crossref}
\title{Get UniProt Entry by UniProt Cross-Reference Database and ID}
\usage{
rba_uniprot_proteins_crossref(
  db_id,
  db_name,
  reviewed = NULL,
  isoform = NULL,
  ...
)
}
\arguments{
\item{db_id}{The protein ID in the cross-reference (external) database.}

\item{db_name}{\href{https://www.uniprot.org/database/}{cross-reference}
(external database) name.}

\item{reviewed}{Logical: (Optional) If TRUE, only returns
"UniProtKB/Swiss-Prot" (reviewed) entries; If FALSE, only returns TrEMBL
(un-reviewed) entries.}

\item{isoform}{Numeric: (Optional) you have two options:\itemize{
\item 0: Exclude isoforms.
\item 1: Return isoforms only.}
see: \href{https://www.uniprot.org/help/alternative_products}{Alternative
products}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List which each element is a UniProt entity that correspond to
  your supplied cross-reference database name and ID.
}
\description{
\href{https://www.uniprot.org/database/}{UniProt Cross-Reference} links
  protein Entities with cross-reference (external) databases. Using this
  function, you can retrieve a UniProt entity using external database name
  and protein ID in that database.
}
\section{Corresponding API Resources}{

 "GET https://www.ebi.ac.uk/proteins/api/proteins/{dbtype}:{dbid}"
}

\examples{
\donttest{
rba_uniprot_proteins_crossref("cd40", "hgnc")
}
\donttest{
rba_uniprot_proteins_crossref("cd40", "hgnc", reviewed = TRUE)
}
\donttest{
rba_uniprot_proteins_crossref("mica", "hgnc", isoform = 0)
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Proteins": 
\code{\link{rba_uniprot_proteins_search}()},
\code{\link{rba_uniprot_proteins}()}
}
\concept{"UniProt - Proteins"}
