% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_annotations}
\alias{rba_string_annotations}
\title{Retrieving Functional Annotation}
\usage{
rba_string_annotations(
  ids,
  species = NULL,
  allow_pubmed = FALSE,
  split_df = TRUE,
  ...
)
}
\arguments{
\item{ids}{Your protein ID(s). It is strongly recommended to supply
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.
(Recommended, but optional if your input is less than 100 IDs.)}

\item{allow_pubmed}{logical: (default = FALSE) PubMed usually  assigns a
large number of reference publications to each protein. In order to reduce
the output size, PubMed's results will be excluded from the results,
unless stated otherwise by setting this argument to TRUE.}

\item{split_df}{(logical, default = TRUE), If TRUE, instead of one
data frame, results from different categories will be split into
multiple data frames based on their 'category'.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame which every row is an assigned terms and the columns
  are the terms category, description, number of genes, and other pertinent
  information.
}
\description{
STRING cross-reference the proteins with several databases (see "Details"
  section). By providing your input set o proteins (and optionally
  background or universe protein set), you can use this function to
  retrieve full set of terms (annotations) pertinent to your input proteins in
  each database, among with information for each term.
}
\details{
STRING currently maps to and retrieve enrichment results based on Gene
  Ontology (GO), KEGG pathways, UniProt Keywords, PubMed publications, Pfam
  domains, InterPro domains, and SMART domains.
  \cr Note that this function will return a full list of the terms containing
  your supplied proteins. To perform enrichment and only retrieve a enriched
  subset of the terms, use \code{\link{rba_string_enrichment}}.
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/[output_format]/functional_annotation?
 identifiers=[your_identifiers]&[optional_parameters]"
}

\examples{
\donttest{
rba_string_annotations(ids = "TP53", species = 9606)
}

}
\references{
\itemize{
  \item Damian Szklarczyk, Rebecca Kirsch, Mikaela Koutrouli, Katerina
   Nastou, Farrokh Mehryary, Radja Hachilif, Annika L Gable, Tao Fang,
   Nadezhda T Doncheva, Sampo Pyysalo, Peer Bork, Lars J Jensen, Christian
   von Mering, The STRING database in 2023: protein–protein association
   networks and functional enrichment analyses for any sequenced genome of
   interest, Nucleic Acids Research, Volume 51, Issue D1, 6 January 2023,
   Pages D638–D646, https://doi.org/10.1093/nar/gkac1000
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  \item
  \href{https://string-db.org/cgi/about?footer_active_subpage=references}{
  Citations note on STRING website}
  }
}
\seealso{
\code{\link{rba_string_map_ids}, \link{rba_string_enrichment}}

Other "STRING": 
\code{\link{rba_string_enrichment_ppi}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_interactions_network}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
