% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{rba_panther_mapping}
\alias{rba_panther_mapping}
\title{Map A Gene-set to PANTHER Database}
\usage{
rba_panther_mapping(genes, organism, ...)
}
\arguments{
\item{genes}{Character vector of genes identifiers with maximum length of
1000. Can be any of: Ensemble gene ID, Ensemble protein ID, Ensemble
transcript ID, Entrez gene ID, gene symbol, NCBI GI, HGNC ID,
International protein index ID, NCBI UniGene ID, UniProt accession
and/or UniProt ID.}

\item{organism}{(numeric) NCBI taxon ID. run \code{\link{rba_panther_info}}
with argument 'what = "organisms"' to get a list of PANTHER's
supported organisms.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list containing your unmapped inputs and mapped genes with
  pertinent information.
}
\description{
Using this function, you can search your genes in PANTHER database and
  retrieve attributes and annotations associated to your genes.
}
\section{Corresponding API Resources}{

 "GET http://www.pantherdb.org/services/oai/pantherdb/geneinfo"
}

\examples{
\donttest{
rba_panther_mapping(genes = c("Cd40", 7124, "ENSG00000203747", "P33681"),
    organism = 9606)
}

}
\references{
\itemize{
  \item Huaiyu Mi, Dustin Ebert, Anushya Muruganujan, Caitlin Mills,
  Laurent-Philippe Albou, Tremayne Mushayamaha, Paul D Thomas, PANTHER
  version 16: a revised family classification, tree-based classification
  tool, enhancer regions and extensive API, Nucleic Acids Research,
  Volume 49, Issue D1, 8 January 2021, Pages D394–D403,
  https://doi.org/10.1093/nar/gkaa1106
  \item \href{http://www.pantherdb.org/services/details.jsp}{PANTHER
  Services Details}
  \item
  \href{http://www.pantherdb.org/publications.jsp#HowToCitePANTHER}{Citations
  note on PANTHER website}
  }
}
\seealso{
Other "PANTHER": 
\code{\link{rba_panther_enrich}()},
\code{\link{rba_panther_family}()},
\code{\link{rba_panther_homolog}()},
\code{\link{rba_panther_info}()},
\code{\link{rba_panther_ortholog}()},
\code{\link{rba_panther_tree_grafter}()}
}
\concept{"PANTHER"}
