% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_interactions_network}
\alias{rba_string_interactions_network}
\title{Get STRING Network Interactions}
\usage{
rba_string_interactions_network(
  ids,
  species = NA,
  required_score = NA,
  add_nodes = NA,
  network_type = "functional",
  ...
)
}
\arguments{
\item{ids}{Your protein IDs. It is strongly recommended to provide
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.}

\item{species}{Numeric: NCBI Taxonomy identifier; Human Taxonomy ID is 9606.
(Recommended, but optional if your input is less than 100 IDs.)}

\item{required_score}{Numeric: A minimum of interaction score for an
interaction to be included in the image. if not provided, the threshold
will be applied by STRING Based in the network. (low Confidence = 150,
Medium Confidence = 400, High Confidence = 700, Highest confidence = 900)}

\item{add_nodes}{Numeric: Number of neighboring proteins to be added to the
network. If none provided by the user, this argument value will depend
on the number of provided "ids" argument:\enumerate{
\item Single id: add_node will be set to 10 to retrieve the interaction
neighborhood  of you input protein.
\item Multiple ids: add_node will be set to 0, thus the output will be the
interactions between your input proteins.}}

\item{network_type}{should be one of:\itemize{
\item "functional": (default) The edge's indicate both physical and
functional associations.
\item "physical": The edges indicate that two proteins have a physical
interaction or are parts of a complex.}}

\item{...}{rbioapi option(s). Refer to \code{\link{rba_options}}'s
arguments documentation for more information on available options.}
}
\value{
A data frame which each row is a network interaction and the
  columns contains interactor information and interaction scores: \itemize{
  \item stringId_A: STRING identifier (protein A)
  \item stringId_B:STRING identifier (protein B)
  \item preferredName_A: common protein name (protein A)
  \item preferredName_B: common protein name (protein B)
  \item ncbiTaxonId: NCBI taxon identifier
  \item score: combined score
  \item nscore: gene neighborhood score
  \item fscore: gene fusion score
  \item pscore: phylogenetic profile score
  \item ascore: co-expression score
  \item escore: experimental score
  \item dscore: database score
  \item tscore: textmining score}
}
\description{
This function will retrieve Sting interaction pairs among your input protein
  ids, with the combined score and separate score for each STRING score
  channels. You can further expand your network to a defined size by
  providing "add_node" parameter.
}
\details{
Note that this function will return interactions between your set of
  provided proteins, or at most, expand the interaction network by the
  given parameters. TO retrieve a list of all possible interacting proteins
  with your given input, refer to
  \code{\link{rba_string_interaction_partners}}.
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/[output-format]/network?identifiers=
 [your_identifiers]&[optional_parameters]"
}

\examples{
\donttest{
rba_string_interactions_network(ids = c("9606.ENSP00000269305",
    "9606.ENSP00000398698",
    "9606.ENSP00000275493"),
    network_type = "functional")
}
\donttest{
rba_string_interactions_network(ids = c("9606.ENSP00000269305",
    "9606.ENSP00000398698",
    "9606.ENSP00000275493"),
    species = 9606,
    add_nodes = 10)
}

}
\references{
\itemize{
  \item Szklarczyk D, Gable AL, Lyon D, Junge A, Wyder S, Huerta-Cepas J,
  Simonovic M, Doncheva NT, Morris JH, Bork P, Jensen LJ, Mering CV.
  STRING v11: protein-protein association networks with increased coverage,
  supporting functional discovery in genome-wide experimental datasets.
  Nucleic Acids Res. 2019 Jan 8;47(D1):D607-D613. doi: 10.1093/nar/gky1131.
  PMID: 30476243; PMCID: PMC6323986.
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  }
}
\seealso{
\code{\link{rba_string_map_ids}, \link{rba_string_interaction_partners}}

Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment_ppi}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_homology_inter}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
