% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BchAddresses.R
\name{base58CheckDecode}
\alias{base58CheckDecode}
\title{Base 58 binary-to-text-decoding}
\usage{
base58CheckDecode(x)
}
\arguments{
\item{x}{\code{character}, string in hex format.}
}
\value{
\code{list}, the decoded elements of the string.
}
\description{
This is a modified binary-to-text decoding used
for decoding Bitcoin addresses, aka \emph{Base58Check}.
If this is applied to a WIF address and the first and last four
bytes are dropped, the result is the corresponding private key.
}
\references{
\url{https://en.bitcoin.it/wiki/Wallet_import_format},\cr
\url{https://en.bitcoin.it/wiki/Address},\cr
\url{https://en.bitcoin.it/wiki/Base58Check_encoding}
}
\seealso{
Other BchAdresses: 
\code{\link{BCHADR-class}},
\code{\link{BTCADR-class}},
\code{\link{PubHash2BchAdr}()},
\code{\link{PubKey2PubHash}()},
\code{\link{base58CheckEncode}()},
\code{\link{concatHex}()},
\code{\link{decodeHex}()},
\code{\link{hash160}()},
\code{\link{hash256}()},
\code{\link{validBchAdr}()},
\code{\link{validBtcAdr}()}
}
\author{
Bernhard Pfaff
}
\concept{BchAdresses}
