% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{montereybay}
\alias{montereybay}
\title{Monterey Bay combined topographic and bathymetric elevation matrix.}
\format{
A matrix with 540 rows and 540 columns. Elevation is in meters, and the spacing between each
coordinate is 200 meters (zscale = 200). Water level is 0. Raster extent located in "extent" attribute. CRS located in "CRS" attribute.
}
\source{
\url{https://www.ncei.noaa.gov/metadata/geoportal/rest/metadata/item/gov.noaa.ngdc.mgg.dem:3544/html}
}
\usage{
montereybay
}
\description{
This dataset is a downsampled version of a combined topographic and bathymetric 
elevation matrix representing the Monterey Bay, CA region. Original data from 
from the NOAA National Map website.
}
\examples{
# This is the full code (commented out) used to generate this dataset from the original NOAA data:
#raster::raster("monterey_13_navd88_2012.nc")
#bottom_left = c(y=-122.366765, x=36.179392)
#top_right   = c(y=-121.366765, x=37.179392) 
#extent_latlong = sp::SpatialPoints(rbind(bottom_left, top_right), 
#                 proj4string=sp::CRS("+proj=longlat +ellps=WGS84 +datum=WGS84"))
#monterey_cropped = raster::crop(montbay,extent_latlong)
#montbay_mat = raster_to_matrix(montbay_cropped)
#montereybay = resize_matrix(montbay_mat,0.05)
#attr(montereybay, "extent") = extent_latlong
#attr(montereybay, "crs") = crs(monterey_cropped)
#attr(montereybay, "crs") = crs(monterey_cropped)
#attr(montereybay, "rayshader_data") = TRUE
}
\keyword{datasets}
