% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_box}
\alias{csg_box}
\title{CSG Box}
\usage{
csg_box(x = 0, y = 0, z = 0, width = c(1, 1, 1), corner_radius = 0)
}
\arguments{
\item{x}{Default `0`. An x-coordinate on the box.}

\item{y}{Default `0`. A y-coordinate on the box.}

\item{z}{Default `0`. A z-coordinate on the box}

\item{width}{Default `c(1,1,1)`. Length-3 vector describing the x/y/z widths of the box}

\item{corner_radius}{Default `0`. Radius if rounded box.}
}
\value{
List describing the box in the scene.
}
\description{
CSG Box
}
\examples{
if(run_documentation()) {
#Generate a box
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_box(), material=glossy(color="#FF69B4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=5))) \%>\%  
  render_scene(clamp_value=10,lookfrom=c(7,3,7))
  }
if(run_documentation()) {
#Change the width
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_box(width = c(2,1,0.5)), material=glossy(color="#FF69B4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=5))) \%>\%  
  render_scene(clamp_value=10,lookfrom=c(7,3,7))
}
if(run_documentation()) {
#Subtract two boxes to make stairs
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
    csg_box(),
    csg_box(x=0.5,y=0.5,width=c(1,1,1.1)),operation="subtract"),
   material=glossy(color="#FF69B4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=5))) \%>\%  
  render_scene(clamp_value=10,lookfrom=c(7,3,7),fov=13)
  }
}
