% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_image.R
\name{plot_image}
\alias{plot_image}
\title{Plot Image}
\usage{
plot_image(
  image,
  rotate = 0,
  draw_grid = FALSE,
  asp = 1,
  new_page = TRUE,
  return_grob = FALSE
)
}
\arguments{
\item{image}{Image array or filename of an image to be plotted.}

\item{rotate}{Default 0. Rotates the output. Possible values: 0, 90, 180, 270.}

\item{draw_grid}{Default \code{FALSE}. If \code{TRUE}, this will draw a grid in the background to help
disambiguate the actual image from the device (helpful if the image background is the same as the
device's background).}

\item{asp}{Default \code{1}. Aspect ratio of the pixels in the plot. For example, an aspect ratio of \code{4/3} will
slightly widen the image.}

\item{new_page}{Default \code{TRUE}. Whether to call \code{grid::grid.newpage()} before plotting the image.}

\item{return_grob}{Default \code{FALSE}. Whether to return the grob object.}
}
\description{
Displays the image in the current device.
}
\examples{
#if(interactive()){
#Plot the dragon array
plot_image(dragon)
#Make pixels twice as wide as tall
plot_image(dragon, asp = 2)
#Plot non-square images
plot_image(dragon[1:100,,])
#Make pixels twice as tall as wide
plot_image(dragon[1:100,,], asp = 1/2)
#end}
}
