% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_bloggers.R
\name{r_bloggers}
\alias{r_bloggers}
\title{Retrieve raw R code from a kaggle notebook}
\usage{
r_bloggers(url, method, padding)
}
\arguments{
\item{url}{Link to an R-bloggers article}

\item{method}{Not all websites are formatted consistently. To overcome this, try a different
method by setting the method
parameter to integers 2 and greater to try other available methods}

\item{padding}{Specify what goes between the last character of one code block and the
first character of the next code block. Default is a two new lines, which appears
visually as one new line between code blocks.}
}
\value{
A character vector of length 1 containing the R code from the target url.
}
\description{
Retrieve raw R code from a kaggle notebook
}
\examples{
\donttest{
library(dplyr)
paste0("https://www.r-bloggers.com/how-to-create-a-bar-",
"chart-race-in-r-mapping-united-states-city-population-1790-2010/") \%>\%
r_bloggers

# Same as above but provided to cat for easy viewing
paste0("https://www.r-bloggers.com/how-to-create-a-bar-",
"chart-race-in-r-mapping-united-states-city-population-1790-2010/") \%>\%
r_bloggers \%>\% cat
}

}
